---
title: Signing
series: customization
hideFromIndex: true
weight: 60
---

Signing ensures that the artifacts have been generated by yourself and your
users can verify that by comparing the generated signature with your public
signing key.

GoReleaser provides means to sign both executables and archives.

## Archives

Signing works in combination with checksum files and it is generally sufficient
to sign the checksum files only.

The default is configured to create a detached signature for the checksum files
with [GnuPG](https://www.gnupg.org/) and your default key. To enable signing
just add

```yaml
# goreleaser.yml
signs:
  - artifacts: checksum
```

To customize the signing pipeline you can use the following options:

```yml
# .goreleaser.yml
signs:
  -
    # ID of the sign config, must be unique.
    # Defaults to "default".
    id: foo

    # name of the signature file.
    # '${artifact}' is the path to the artifact that should be signed.
    #
    # defaults to `${artifact}.sig`
    signature: "${artifact}_sig"

    # path to the signature command
    #
    # defaults to `gpg`
    cmd: gpg2

    # command line templateable arguments for the command
    #
    # to sign with a specific key use
    # args: ["-u", "<key id, fingerprint, email, ...>", "--output", "${signature}", "--detach-sign", "${artifact}"]
    #
    # defaults to `["--output", "${signature}", "--detach-sign", "${artifact}"]`
    args: ["--output", "${signature}", "${artifact}", "{{ .ProjectName }}"]


    # which artifacts to sign
    #
    #   checksum: only checksum file(s)
    #   all:      all artifacts
    #   none:     no signing
    #
    # defaults to `none`
    artifacts: all

    # IDs of the artifacts to sign.
    # Defaults to all.
    # If `artifacts` is checksum, this fields has no effect.
    ids:
      - foo
      - bar
```

### Limitations

You can sign with any command that outputs a file.
If what you want to use does not do it, you can always hack by setting the
command to `sh -c`. For example:

```yaml
# goreleaser.yml
signs:
- cmd: sh
  args:
  - '-c'
  - 'echo "${artifact} is signed and I can prove it" | tee ${signature}'
  artifacts: all
```

And it will work just fine. Just make sure to always use the `${signature}`
template variable as the result file name and `${artifact}` as the origin file.


## Executables

Executables can be signed after build using post hooks.

For example you can use [gon][] to create notarized MacOS apps:

```yaml
builds:
- binary: foo
  id: foo
  goos:
  - linux
  - windows
  goarch:
  - amd64

# notice that we need a separated build for the MacOS binary only:
- binary: foo
  id: foo-macos
  goos:
  - darwin
  goarch:
  - amd64
  hooks:
    post: gon gon.hcl
```
**`gon.hcl`:**
```hcl
# The path follows a pattern
# ./dist/BUILD-ID_TARGET/BINARY-NAME
source = ["./dist/foo-macos_darwin_amd64/foo"]
bundle_id = "com.mitchellh.example.terraform"

apple_id {
  username = "mitchell@example.com"
  password = "@env:AC_PASSWORD"
}

sign {
  application_identity = "Developer ID Application: Mitchell Hashimoto"
}
```

Note that notarizing may take some time, and will need to be run from a MacOS machine.

If you generate ZIP or DMG as part of your signing via gon you may need
to ensure their file names align with desired pattern of other artifacts
as GoReleaser doesn't control how these get generated beyond just executing `gon`
with given arguments. Relatedly you may need to list these additional artifacts
as `extra_files` in the `release` section to make sure they also get uploaded.

You can also check [this issue](https://github.com/goreleaser/goreleaser/issues/1227) for more details.

[gon]: https://github.com/mitchellh/gon
