// Code generated by genny. DO NOT EDIT.
// This file was automatically generated by genny.
// Any changes will be lost if this file is regenerated.
// see https://github.com/mauricelam/genny

// Copyright (c) 2020 StackRox Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License

package sliceutils

// BoolDiff returns, given two sorted bool slices a and b, a slice of the elements occurring in a and b only,
// respectively.
func BoolDiff(a, b []bool, lessFunc func(a, b bool) bool) (aOnly, bOnly []bool) {
	i, j := 0, 0
	for i < len(a) && j < len(b) {
		if lessFunc(a[i], b[j]) {
			aOnly = append(aOnly, a[i])
			i++
		} else if lessFunc(b[j], a[i]) {
			bOnly = append(bOnly, b[j])
			j++
		} else { // a[i] and b[j] are "equal"
			i++
			j++
		}
	}

	aOnly = append(aOnly, a[i:]...)
	bOnly = append(bOnly, b[j:]...)
	return
}

// BoolClone clones a slice, creating a new slice
// and copying the contents of the underlying array.
// If `in` is a nil slice, a nil slice is returned.
// If `in` is an empty slice, an empty slice is returned.
func BoolClone(in []bool) []bool {
	if in == nil {
		return nil
	}
	if len(in) == 0 {
		return []bool{}
	}
	out := make([]bool, len(in))
	copy(out, in)
	return out
}

// BoolFind returns, given a slice and an element, the first index of elem in the slice, or -1 if the slice does
// not contain elem.
func BoolFind(slice []bool, elem bool) int {
	for i, sliceElem := range slice {
		if sliceElem == elem {
			return i
		}
	}
	return -1
}

// ConcatBoolSlices concatenates slices, returning a slice with newly allocated backing storage of the exact
// size.
func ConcatBoolSlices(slices ...[]bool) []bool {
	length := 0
	for _, slice := range slices {
		length += len(slice)
	}
	result := make([]bool, length)
	i := 0
	for _, slice := range slices {
		nextI := i + len(slice)
		copy(result[i:nextI], slice)
		i = nextI
	}
	return result
}

// BoolUnique returns a new slice that contains only the first occurrence of each element in slice.
func BoolUnique(slice []bool) []bool {
	result := make([]bool, 0, len(slice))
	seen := make(map[bool]struct{}, len(slice))
	for _, elem := range slice {
		if _, ok := seen[elem]; !ok {
			result = append(result, elem)
			seen[elem] = struct{}{}
		}
	}
	return result
}

// BoolDifference returns the array of elements in the first slice that aren't in the second slice
func BoolDifference(slice1, slice2 []bool) []bool {
	if len(slice1) == 0 || len(slice2) == 0 {
		return slice1
	}

	slice2Map := make(map[bool]struct{}, len(slice2))
	for _, s := range slice2 {
		slice2Map[s] = struct{}{}
	}
	var newSlice []bool
	for _, s := range slice1 {
		if _, ok := slice2Map[s]; !ok {
			newSlice = append(newSlice, s)
		}
	}
	return newSlice
}

// BoolUnion returns the union array of slice1 and slice2 without duplicates
func BoolUnion(slice1, slice2 []bool) []bool {
	// Fast path
	if len(slice1) == 0 {
		return slice2
	}
	if len(slice2) == 0 {
		return slice1
	}

	newSlice := make([]bool, len(slice1))
	copy(newSlice, slice1)

	slice1Map := make(map[bool]struct{}, len(slice1))
	for _, s := range slice1 {
		slice1Map[s] = struct{}{}
	}
	for _, s := range slice2 {
		if _, ok := slice1Map[s]; !ok {
			newSlice = append(newSlice, s)
		}
	}
	return newSlice
}

// ByteDiff returns, given two sorted byte slices a and b, a slice of the elements occurring in a and b only,
// respectively.
func ByteDiff(a, b []byte, lessFunc func(a, b byte) bool) (aOnly, bOnly []byte) {
	i, j := 0, 0
	for i < len(a) && j < len(b) {
		if lessFunc(a[i], b[j]) {
			aOnly = append(aOnly, a[i])
			i++
		} else if lessFunc(b[j], a[i]) {
			bOnly = append(bOnly, b[j])
			j++
		} else { // a[i] and b[j] are "equal"
			i++
			j++
		}
	}

	aOnly = append(aOnly, a[i:]...)
	bOnly = append(bOnly, b[j:]...)
	return
}

// ByteClone clones a slice, creating a new slice
// and copying the contents of the underlying array.
// If `in` is a nil slice, a nil slice is returned.
// If `in` is an empty slice, an empty slice is returned.
func ByteClone(in []byte) []byte {
	if in == nil {
		return nil
	}
	if len(in) == 0 {
		return []byte{}
	}
	out := make([]byte, len(in))
	copy(out, in)
	return out
}

// ByteFind returns, given a slice and an element, the first index of elem in the slice, or -1 if the slice does
// not contain elem.
func ByteFind(slice []byte, elem byte) int {
	for i, sliceElem := range slice {
		if sliceElem == elem {
			return i
		}
	}
	return -1
}

// ConcatByteSlices concatenates slices, returning a slice with newly allocated backing storage of the exact
// size.
func ConcatByteSlices(slices ...[]byte) []byte {
	length := 0
	for _, slice := range slices {
		length += len(slice)
	}
	result := make([]byte, length)
	i := 0
	for _, slice := range slices {
		nextI := i + len(slice)
		copy(result[i:nextI], slice)
		i = nextI
	}
	return result
}

// ByteUnique returns a new slice that contains only the first occurrence of each element in slice.
func ByteUnique(slice []byte) []byte {
	result := make([]byte, 0, len(slice))
	seen := make(map[byte]struct{}, len(slice))
	for _, elem := range slice {
		if _, ok := seen[elem]; !ok {
			result = append(result, elem)
			seen[elem] = struct{}{}
		}
	}
	return result
}

// ByteDifference returns the array of elements in the first slice that aren't in the second slice
func ByteDifference(slice1, slice2 []byte) []byte {
	if len(slice1) == 0 || len(slice2) == 0 {
		return slice1
	}

	slice2Map := make(map[byte]struct{}, len(slice2))
	for _, s := range slice2 {
		slice2Map[s] = struct{}{}
	}
	var newSlice []byte
	for _, s := range slice1 {
		if _, ok := slice2Map[s]; !ok {
			newSlice = append(newSlice, s)
		}
	}
	return newSlice
}

// ByteUnion returns the union array of slice1 and slice2 without duplicates
func ByteUnion(slice1, slice2 []byte) []byte {
	// Fast path
	if len(slice1) == 0 {
		return slice2
	}
	if len(slice2) == 0 {
		return slice1
	}

	newSlice := make([]byte, len(slice1))
	copy(newSlice, slice1)

	slice1Map := make(map[byte]struct{}, len(slice1))
	for _, s := range slice1 {
		slice1Map[s] = struct{}{}
	}
	for _, s := range slice2 {
		if _, ok := slice1Map[s]; !ok {
			newSlice = append(newSlice, s)
		}
	}
	return newSlice
}

// Complex128Diff returns, given two sorted complex128 slices a and b, a slice of the elements occurring in a and b only,
// respectively.
func Complex128Diff(a, b []complex128, lessFunc func(a, b complex128) bool) (aOnly, bOnly []complex128) {
	i, j := 0, 0
	for i < len(a) && j < len(b) {
		if lessFunc(a[i], b[j]) {
			aOnly = append(aOnly, a[i])
			i++
		} else if lessFunc(b[j], a[i]) {
			bOnly = append(bOnly, b[j])
			j++
		} else { // a[i] and b[j] are "equal"
			i++
			j++
		}
	}

	aOnly = append(aOnly, a[i:]...)
	bOnly = append(bOnly, b[j:]...)
	return
}

// Complex128Clone clones a slice, creating a new slice
// and copying the contents of the underlying array.
// If `in` is a nil slice, a nil slice is returned.
// If `in` is an empty slice, an empty slice is returned.
func Complex128Clone(in []complex128) []complex128 {
	if in == nil {
		return nil
	}
	if len(in) == 0 {
		return []complex128{}
	}
	out := make([]complex128, len(in))
	copy(out, in)
	return out
}

// Complex128Find returns, given a slice and an element, the first index of elem in the slice, or -1 if the slice does
// not contain elem.
func Complex128Find(slice []complex128, elem complex128) int {
	for i, sliceElem := range slice {
		if sliceElem == elem {
			return i
		}
	}
	return -1
}

// ConcatComplex128Slices concatenates slices, returning a slice with newly allocated backing storage of the exact
// size.
func ConcatComplex128Slices(slices ...[]complex128) []complex128 {
	length := 0
	for _, slice := range slices {
		length += len(slice)
	}
	result := make([]complex128, length)
	i := 0
	for _, slice := range slices {
		nextI := i + len(slice)
		copy(result[i:nextI], slice)
		i = nextI
	}
	return result
}

// Complex128Unique returns a new slice that contains only the first occurrence of each element in slice.
func Complex128Unique(slice []complex128) []complex128 {
	result := make([]complex128, 0, len(slice))
	seen := make(map[complex128]struct{}, len(slice))
	for _, elem := range slice {
		if _, ok := seen[elem]; !ok {
			result = append(result, elem)
			seen[elem] = struct{}{}
		}
	}
	return result
}

// Complex128Difference returns the array of elements in the first slice that aren't in the second slice
func Complex128Difference(slice1, slice2 []complex128) []complex128 {
	if len(slice1) == 0 || len(slice2) == 0 {
		return slice1
	}

	slice2Map := make(map[complex128]struct{}, len(slice2))
	for _, s := range slice2 {
		slice2Map[s] = struct{}{}
	}
	var newSlice []complex128
	for _, s := range slice1 {
		if _, ok := slice2Map[s]; !ok {
			newSlice = append(newSlice, s)
		}
	}
	return newSlice
}

// Complex128Union returns the union array of slice1 and slice2 without duplicates
func Complex128Union(slice1, slice2 []complex128) []complex128 {
	// Fast path
	if len(slice1) == 0 {
		return slice2
	}
	if len(slice2) == 0 {
		return slice1
	}

	newSlice := make([]complex128, len(slice1))
	copy(newSlice, slice1)

	slice1Map := make(map[complex128]struct{}, len(slice1))
	for _, s := range slice1 {
		slice1Map[s] = struct{}{}
	}
	for _, s := range slice2 {
		if _, ok := slice1Map[s]; !ok {
			newSlice = append(newSlice, s)
		}
	}
	return newSlice
}

// Complex64Diff returns, given two sorted complex64 slices a and b, a slice of the elements occurring in a and b only,
// respectively.
func Complex64Diff(a, b []complex64, lessFunc func(a, b complex64) bool) (aOnly, bOnly []complex64) {
	i, j := 0, 0
	for i < len(a) && j < len(b) {
		if lessFunc(a[i], b[j]) {
			aOnly = append(aOnly, a[i])
			i++
		} else if lessFunc(b[j], a[i]) {
			bOnly = append(bOnly, b[j])
			j++
		} else { // a[i] and b[j] are "equal"
			i++
			j++
		}
	}

	aOnly = append(aOnly, a[i:]...)
	bOnly = append(bOnly, b[j:]...)
	return
}

// Complex64Clone clones a slice, creating a new slice
// and copying the contents of the underlying array.
// If `in` is a nil slice, a nil slice is returned.
// If `in` is an empty slice, an empty slice is returned.
func Complex64Clone(in []complex64) []complex64 {
	if in == nil {
		return nil
	}
	if len(in) == 0 {
		return []complex64{}
	}
	out := make([]complex64, len(in))
	copy(out, in)
	return out
}

// Complex64Find returns, given a slice and an element, the first index of elem in the slice, or -1 if the slice does
// not contain elem.
func Complex64Find(slice []complex64, elem complex64) int {
	for i, sliceElem := range slice {
		if sliceElem == elem {
			return i
		}
	}
	return -1
}

// ConcatComplex64Slices concatenates slices, returning a slice with newly allocated backing storage of the exact
// size.
func ConcatComplex64Slices(slices ...[]complex64) []complex64 {
	length := 0
	for _, slice := range slices {
		length += len(slice)
	}
	result := make([]complex64, length)
	i := 0
	for _, slice := range slices {
		nextI := i + len(slice)
		copy(result[i:nextI], slice)
		i = nextI
	}
	return result
}

// Complex64Unique returns a new slice that contains only the first occurrence of each element in slice.
func Complex64Unique(slice []complex64) []complex64 {
	result := make([]complex64, 0, len(slice))
	seen := make(map[complex64]struct{}, len(slice))
	for _, elem := range slice {
		if _, ok := seen[elem]; !ok {
			result = append(result, elem)
			seen[elem] = struct{}{}
		}
	}
	return result
}

// Complex64Difference returns the array of elements in the first slice that aren't in the second slice
func Complex64Difference(slice1, slice2 []complex64) []complex64 {
	if len(slice1) == 0 || len(slice2) == 0 {
		return slice1
	}

	slice2Map := make(map[complex64]struct{}, len(slice2))
	for _, s := range slice2 {
		slice2Map[s] = struct{}{}
	}
	var newSlice []complex64
	for _, s := range slice1 {
		if _, ok := slice2Map[s]; !ok {
			newSlice = append(newSlice, s)
		}
	}
	return newSlice
}

// Complex64Union returns the union array of slice1 and slice2 without duplicates
func Complex64Union(slice1, slice2 []complex64) []complex64 {
	// Fast path
	if len(slice1) == 0 {
		return slice2
	}
	if len(slice2) == 0 {
		return slice1
	}

	newSlice := make([]complex64, len(slice1))
	copy(newSlice, slice1)

	slice1Map := make(map[complex64]struct{}, len(slice1))
	for _, s := range slice1 {
		slice1Map[s] = struct{}{}
	}
	for _, s := range slice2 {
		if _, ok := slice1Map[s]; !ok {
			newSlice = append(newSlice, s)
		}
	}
	return newSlice
}

// ErrorDiff returns, given two sorted error slices a and b, a slice of the elements occurring in a and b only,
// respectively.
func ErrorDiff(a, b []error, lessFunc func(a, b error) bool) (aOnly, bOnly []error) {
	i, j := 0, 0
	for i < len(a) && j < len(b) {
		if lessFunc(a[i], b[j]) {
			aOnly = append(aOnly, a[i])
			i++
		} else if lessFunc(b[j], a[i]) {
			bOnly = append(bOnly, b[j])
			j++
		} else { // a[i] and b[j] are "equal"
			i++
			j++
		}
	}

	aOnly = append(aOnly, a[i:]...)
	bOnly = append(bOnly, b[j:]...)
	return
}

// ErrorClone clones a slice, creating a new slice
// and copying the contents of the underlying array.
// If `in` is a nil slice, a nil slice is returned.
// If `in` is an empty slice, an empty slice is returned.
func ErrorClone(in []error) []error {
	if in == nil {
		return nil
	}
	if len(in) == 0 {
		return []error{}
	}
	out := make([]error, len(in))
	copy(out, in)
	return out
}

// ErrorFind returns, given a slice and an element, the first index of elem in the slice, or -1 if the slice does
// not contain elem.
func ErrorFind(slice []error, elem error) int {
	for i, sliceElem := range slice {
		if sliceElem == elem {
			return i
		}
	}
	return -1
}

// ConcatErrorSlices concatenates slices, returning a slice with newly allocated backing storage of the exact
// size.
func ConcatErrorSlices(slices ...[]error) []error {
	length := 0
	for _, slice := range slices {
		length += len(slice)
	}
	result := make([]error, length)
	i := 0
	for _, slice := range slices {
		nextI := i + len(slice)
		copy(result[i:nextI], slice)
		i = nextI
	}
	return result
}

// ErrorUnique returns a new slice that contains only the first occurrence of each element in slice.
func ErrorUnique(slice []error) []error {
	result := make([]error, 0, len(slice))
	seen := make(map[error]struct{}, len(slice))
	for _, elem := range slice {
		if _, ok := seen[elem]; !ok {
			result = append(result, elem)
			seen[elem] = struct{}{}
		}
	}
	return result
}

// ErrorDifference returns the array of elements in the first slice that aren't in the second slice
func ErrorDifference(slice1, slice2 []error) []error {
	if len(slice1) == 0 || len(slice2) == 0 {
		return slice1
	}

	slice2Map := make(map[error]struct{}, len(slice2))
	for _, s := range slice2 {
		slice2Map[s] = struct{}{}
	}
	var newSlice []error
	for _, s := range slice1 {
		if _, ok := slice2Map[s]; !ok {
			newSlice = append(newSlice, s)
		}
	}
	return newSlice
}

// ErrorUnion returns the union array of slice1 and slice2 without duplicates
func ErrorUnion(slice1, slice2 []error) []error {
	// Fast path
	if len(slice1) == 0 {
		return slice2
	}
	if len(slice2) == 0 {
		return slice1
	}

	newSlice := make([]error, len(slice1))
	copy(newSlice, slice1)

	slice1Map := make(map[error]struct{}, len(slice1))
	for _, s := range slice1 {
		slice1Map[s] = struct{}{}
	}
	for _, s := range slice2 {
		if _, ok := slice1Map[s]; !ok {
			newSlice = append(newSlice, s)
		}
	}
	return newSlice
}

// Float32Diff returns, given two sorted float32 slices a and b, a slice of the elements occurring in a and b only,
// respectively.
func Float32Diff(a, b []float32, lessFunc func(a, b float32) bool) (aOnly, bOnly []float32) {
	i, j := 0, 0
	for i < len(a) && j < len(b) {
		if lessFunc(a[i], b[j]) {
			aOnly = append(aOnly, a[i])
			i++
		} else if lessFunc(b[j], a[i]) {
			bOnly = append(bOnly, b[j])
			j++
		} else { // a[i] and b[j] are "equal"
			i++
			j++
		}
	}

	aOnly = append(aOnly, a[i:]...)
	bOnly = append(bOnly, b[j:]...)
	return
}

// Float32Clone clones a slice, creating a new slice
// and copying the contents of the underlying array.
// If `in` is a nil slice, a nil slice is returned.
// If `in` is an empty slice, an empty slice is returned.
func Float32Clone(in []float32) []float32 {
	if in == nil {
		return nil
	}
	if len(in) == 0 {
		return []float32{}
	}
	out := make([]float32, len(in))
	copy(out, in)
	return out
}

// Float32Find returns, given a slice and an element, the first index of elem in the slice, or -1 if the slice does
// not contain elem.
func Float32Find(slice []float32, elem float32) int {
	for i, sliceElem := range slice {
		if sliceElem == elem {
			return i
		}
	}
	return -1
}

// ConcatFloat32Slices concatenates slices, returning a slice with newly allocated backing storage of the exact
// size.
func ConcatFloat32Slices(slices ...[]float32) []float32 {
	length := 0
	for _, slice := range slices {
		length += len(slice)
	}
	result := make([]float32, length)
	i := 0
	for _, slice := range slices {
		nextI := i + len(slice)
		copy(result[i:nextI], slice)
		i = nextI
	}
	return result
}

// Float32Unique returns a new slice that contains only the first occurrence of each element in slice.
func Float32Unique(slice []float32) []float32 {
	result := make([]float32, 0, len(slice))
	seen := make(map[float32]struct{}, len(slice))
	for _, elem := range slice {
		if _, ok := seen[elem]; !ok {
			result = append(result, elem)
			seen[elem] = struct{}{}
		}
	}
	return result
}

// Float32Difference returns the array of elements in the first slice that aren't in the second slice
func Float32Difference(slice1, slice2 []float32) []float32 {
	if len(slice1) == 0 || len(slice2) == 0 {
		return slice1
	}

	slice2Map := make(map[float32]struct{}, len(slice2))
	for _, s := range slice2 {
		slice2Map[s] = struct{}{}
	}
	var newSlice []float32
	for _, s := range slice1 {
		if _, ok := slice2Map[s]; !ok {
			newSlice = append(newSlice, s)
		}
	}
	return newSlice
}

// Float32Union returns the union array of slice1 and slice2 without duplicates
func Float32Union(slice1, slice2 []float32) []float32 {
	// Fast path
	if len(slice1) == 0 {
		return slice2
	}
	if len(slice2) == 0 {
		return slice1
	}

	newSlice := make([]float32, len(slice1))
	copy(newSlice, slice1)

	slice1Map := make(map[float32]struct{}, len(slice1))
	for _, s := range slice1 {
		slice1Map[s] = struct{}{}
	}
	for _, s := range slice2 {
		if _, ok := slice1Map[s]; !ok {
			newSlice = append(newSlice, s)
		}
	}
	return newSlice
}

// Float64Diff returns, given two sorted float64 slices a and b, a slice of the elements occurring in a and b only,
// respectively.
func Float64Diff(a, b []float64, lessFunc func(a, b float64) bool) (aOnly, bOnly []float64) {
	i, j := 0, 0
	for i < len(a) && j < len(b) {
		if lessFunc(a[i], b[j]) {
			aOnly = append(aOnly, a[i])
			i++
		} else if lessFunc(b[j], a[i]) {
			bOnly = append(bOnly, b[j])
			j++
		} else { // a[i] and b[j] are "equal"
			i++
			j++
		}
	}

	aOnly = append(aOnly, a[i:]...)
	bOnly = append(bOnly, b[j:]...)
	return
}

// Float64Clone clones a slice, creating a new slice
// and copying the contents of the underlying array.
// If `in` is a nil slice, a nil slice is returned.
// If `in` is an empty slice, an empty slice is returned.
func Float64Clone(in []float64) []float64 {
	if in == nil {
		return nil
	}
	if len(in) == 0 {
		return []float64{}
	}
	out := make([]float64, len(in))
	copy(out, in)
	return out
}

// Float64Find returns, given a slice and an element, the first index of elem in the slice, or -1 if the slice does
// not contain elem.
func Float64Find(slice []float64, elem float64) int {
	for i, sliceElem := range slice {
		if sliceElem == elem {
			return i
		}
	}
	return -1
}

// ConcatFloat64Slices concatenates slices, returning a slice with newly allocated backing storage of the exact
// size.
func ConcatFloat64Slices(slices ...[]float64) []float64 {
	length := 0
	for _, slice := range slices {
		length += len(slice)
	}
	result := make([]float64, length)
	i := 0
	for _, slice := range slices {
		nextI := i + len(slice)
		copy(result[i:nextI], slice)
		i = nextI
	}
	return result
}

// Float64Unique returns a new slice that contains only the first occurrence of each element in slice.
func Float64Unique(slice []float64) []float64 {
	result := make([]float64, 0, len(slice))
	seen := make(map[float64]struct{}, len(slice))
	for _, elem := range slice {
		if _, ok := seen[elem]; !ok {
			result = append(result, elem)
			seen[elem] = struct{}{}
		}
	}
	return result
}

// Float64Difference returns the array of elements in the first slice that aren't in the second slice
func Float64Difference(slice1, slice2 []float64) []float64 {
	if len(slice1) == 0 || len(slice2) == 0 {
		return slice1
	}

	slice2Map := make(map[float64]struct{}, len(slice2))
	for _, s := range slice2 {
		slice2Map[s] = struct{}{}
	}
	var newSlice []float64
	for _, s := range slice1 {
		if _, ok := slice2Map[s]; !ok {
			newSlice = append(newSlice, s)
		}
	}
	return newSlice
}

// Float64Union returns the union array of slice1 and slice2 without duplicates
func Float64Union(slice1, slice2 []float64) []float64 {
	// Fast path
	if len(slice1) == 0 {
		return slice2
	}
	if len(slice2) == 0 {
		return slice1
	}

	newSlice := make([]float64, len(slice1))
	copy(newSlice, slice1)

	slice1Map := make(map[float64]struct{}, len(slice1))
	for _, s := range slice1 {
		slice1Map[s] = struct{}{}
	}
	for _, s := range slice2 {
		if _, ok := slice1Map[s]; !ok {
			newSlice = append(newSlice, s)
		}
	}
	return newSlice
}

// IntDiff returns, given two sorted int slices a and b, a slice of the elements occurring in a and b only,
// respectively.
func IntDiff(a, b []int, lessFunc func(a, b int) bool) (aOnly, bOnly []int) {
	i, j := 0, 0
	for i < len(a) && j < len(b) {
		if lessFunc(a[i], b[j]) {
			aOnly = append(aOnly, a[i])
			i++
		} else if lessFunc(b[j], a[i]) {
			bOnly = append(bOnly, b[j])
			j++
		} else { // a[i] and b[j] are "equal"
			i++
			j++
		}
	}

	aOnly = append(aOnly, a[i:]...)
	bOnly = append(bOnly, b[j:]...)
	return
}

// IntClone clones a slice, creating a new slice
// and copying the contents of the underlying array.
// If `in` is a nil slice, a nil slice is returned.
// If `in` is an empty slice, an empty slice is returned.
func IntClone(in []int) []int {
	if in == nil {
		return nil
	}
	if len(in) == 0 {
		return []int{}
	}
	out := make([]int, len(in))
	copy(out, in)
	return out
}

// IntFind returns, given a slice and an element, the first index of elem in the slice, or -1 if the slice does
// not contain elem.
func IntFind(slice []int, elem int) int {
	for i, sliceElem := range slice {
		if sliceElem == elem {
			return i
		}
	}
	return -1
}

// ConcatIntSlices concatenates slices, returning a slice with newly allocated backing storage of the exact
// size.
func ConcatIntSlices(slices ...[]int) []int {
	length := 0
	for _, slice := range slices {
		length += len(slice)
	}
	result := make([]int, length)
	i := 0
	for _, slice := range slices {
		nextI := i + len(slice)
		copy(result[i:nextI], slice)
		i = nextI
	}
	return result
}

// IntUnique returns a new slice that contains only the first occurrence of each element in slice.
func IntUnique(slice []int) []int {
	result := make([]int, 0, len(slice))
	seen := make(map[int]struct{}, len(slice))
	for _, elem := range slice {
		if _, ok := seen[elem]; !ok {
			result = append(result, elem)
			seen[elem] = struct{}{}
		}
	}
	return result
}

// IntDifference returns the array of elements in the first slice that aren't in the second slice
func IntDifference(slice1, slice2 []int) []int {
	if len(slice1) == 0 || len(slice2) == 0 {
		return slice1
	}

	slice2Map := make(map[int]struct{}, len(slice2))
	for _, s := range slice2 {
		slice2Map[s] = struct{}{}
	}
	var newSlice []int
	for _, s := range slice1 {
		if _, ok := slice2Map[s]; !ok {
			newSlice = append(newSlice, s)
		}
	}
	return newSlice
}

// IntUnion returns the union array of slice1 and slice2 without duplicates
func IntUnion(slice1, slice2 []int) []int {
	// Fast path
	if len(slice1) == 0 {
		return slice2
	}
	if len(slice2) == 0 {
		return slice1
	}

	newSlice := make([]int, len(slice1))
	copy(newSlice, slice1)

	slice1Map := make(map[int]struct{}, len(slice1))
	for _, s := range slice1 {
		slice1Map[s] = struct{}{}
	}
	for _, s := range slice2 {
		if _, ok := slice1Map[s]; !ok {
			newSlice = append(newSlice, s)
		}
	}
	return newSlice
}

// Int16Diff returns, given two sorted int16 slices a and b, a slice of the elements occurring in a and b only,
// respectively.
func Int16Diff(a, b []int16, lessFunc func(a, b int16) bool) (aOnly, bOnly []int16) {
	i, j := 0, 0
	for i < len(a) && j < len(b) {
		if lessFunc(a[i], b[j]) {
			aOnly = append(aOnly, a[i])
			i++
		} else if lessFunc(b[j], a[i]) {
			bOnly = append(bOnly, b[j])
			j++
		} else { // a[i] and b[j] are "equal"
			i++
			j++
		}
	}

	aOnly = append(aOnly, a[i:]...)
	bOnly = append(bOnly, b[j:]...)
	return
}

// Int16Clone clones a slice, creating a new slice
// and copying the contents of the underlying array.
// If `in` is a nil slice, a nil slice is returned.
// If `in` is an empty slice, an empty slice is returned.
func Int16Clone(in []int16) []int16 {
	if in == nil {
		return nil
	}
	if len(in) == 0 {
		return []int16{}
	}
	out := make([]int16, len(in))
	copy(out, in)
	return out
}

// Int16Find returns, given a slice and an element, the first index of elem in the slice, or -1 if the slice does
// not contain elem.
func Int16Find(slice []int16, elem int16) int {
	for i, sliceElem := range slice {
		if sliceElem == elem {
			return i
		}
	}
	return -1
}

// ConcatInt16Slices concatenates slices, returning a slice with newly allocated backing storage of the exact
// size.
func ConcatInt16Slices(slices ...[]int16) []int16 {
	length := 0
	for _, slice := range slices {
		length += len(slice)
	}
	result := make([]int16, length)
	i := 0
	for _, slice := range slices {
		nextI := i + len(slice)
		copy(result[i:nextI], slice)
		i = nextI
	}
	return result
}

// Int16Unique returns a new slice that contains only the first occurrence of each element in slice.
func Int16Unique(slice []int16) []int16 {
	result := make([]int16, 0, len(slice))
	seen := make(map[int16]struct{}, len(slice))
	for _, elem := range slice {
		if _, ok := seen[elem]; !ok {
			result = append(result, elem)
			seen[elem] = struct{}{}
		}
	}
	return result
}

// Int16Difference returns the array of elements in the first slice that aren't in the second slice
func Int16Difference(slice1, slice2 []int16) []int16 {
	if len(slice1) == 0 || len(slice2) == 0 {
		return slice1
	}

	slice2Map := make(map[int16]struct{}, len(slice2))
	for _, s := range slice2 {
		slice2Map[s] = struct{}{}
	}
	var newSlice []int16
	for _, s := range slice1 {
		if _, ok := slice2Map[s]; !ok {
			newSlice = append(newSlice, s)
		}
	}
	return newSlice
}

// Int16Union returns the union array of slice1 and slice2 without duplicates
func Int16Union(slice1, slice2 []int16) []int16 {
	// Fast path
	if len(slice1) == 0 {
		return slice2
	}
	if len(slice2) == 0 {
		return slice1
	}

	newSlice := make([]int16, len(slice1))
	copy(newSlice, slice1)

	slice1Map := make(map[int16]struct{}, len(slice1))
	for _, s := range slice1 {
		slice1Map[s] = struct{}{}
	}
	for _, s := range slice2 {
		if _, ok := slice1Map[s]; !ok {
			newSlice = append(newSlice, s)
		}
	}
	return newSlice
}

// Int32Diff returns, given two sorted int32 slices a and b, a slice of the elements occurring in a and b only,
// respectively.
func Int32Diff(a, b []int32, lessFunc func(a, b int32) bool) (aOnly, bOnly []int32) {
	i, j := 0, 0
	for i < len(a) && j < len(b) {
		if lessFunc(a[i], b[j]) {
			aOnly = append(aOnly, a[i])
			i++
		} else if lessFunc(b[j], a[i]) {
			bOnly = append(bOnly, b[j])
			j++
		} else { // a[i] and b[j] are "equal"
			i++
			j++
		}
	}

	aOnly = append(aOnly, a[i:]...)
	bOnly = append(bOnly, b[j:]...)
	return
}

// Int32Clone clones a slice, creating a new slice
// and copying the contents of the underlying array.
// If `in` is a nil slice, a nil slice is returned.
// If `in` is an empty slice, an empty slice is returned.
func Int32Clone(in []int32) []int32 {
	if in == nil {
		return nil
	}
	if len(in) == 0 {
		return []int32{}
	}
	out := make([]int32, len(in))
	copy(out, in)
	return out
}

// Int32Find returns, given a slice and an element, the first index of elem in the slice, or -1 if the slice does
// not contain elem.
func Int32Find(slice []int32, elem int32) int {
	for i, sliceElem := range slice {
		if sliceElem == elem {
			return i
		}
	}
	return -1
}

// ConcatInt32Slices concatenates slices, returning a slice with newly allocated backing storage of the exact
// size.
func ConcatInt32Slices(slices ...[]int32) []int32 {
	length := 0
	for _, slice := range slices {
		length += len(slice)
	}
	result := make([]int32, length)
	i := 0
	for _, slice := range slices {
		nextI := i + len(slice)
		copy(result[i:nextI], slice)
		i = nextI
	}
	return result
}

// Int32Unique returns a new slice that contains only the first occurrence of each element in slice.
func Int32Unique(slice []int32) []int32 {
	result := make([]int32, 0, len(slice))
	seen := make(map[int32]struct{}, len(slice))
	for _, elem := range slice {
		if _, ok := seen[elem]; !ok {
			result = append(result, elem)
			seen[elem] = struct{}{}
		}
	}
	return result
}

// Int32Difference returns the array of elements in the first slice that aren't in the second slice
func Int32Difference(slice1, slice2 []int32) []int32 {
	if len(slice1) == 0 || len(slice2) == 0 {
		return slice1
	}

	slice2Map := make(map[int32]struct{}, len(slice2))
	for _, s := range slice2 {
		slice2Map[s] = struct{}{}
	}
	var newSlice []int32
	for _, s := range slice1 {
		if _, ok := slice2Map[s]; !ok {
			newSlice = append(newSlice, s)
		}
	}
	return newSlice
}

// Int32Union returns the union array of slice1 and slice2 without duplicates
func Int32Union(slice1, slice2 []int32) []int32 {
	// Fast path
	if len(slice1) == 0 {
		return slice2
	}
	if len(slice2) == 0 {
		return slice1
	}

	newSlice := make([]int32, len(slice1))
	copy(newSlice, slice1)

	slice1Map := make(map[int32]struct{}, len(slice1))
	for _, s := range slice1 {
		slice1Map[s] = struct{}{}
	}
	for _, s := range slice2 {
		if _, ok := slice1Map[s]; !ok {
			newSlice = append(newSlice, s)
		}
	}
	return newSlice
}

// Int64Diff returns, given two sorted int64 slices a and b, a slice of the elements occurring in a and b only,
// respectively.
func Int64Diff(a, b []int64, lessFunc func(a, b int64) bool) (aOnly, bOnly []int64) {
	i, j := 0, 0
	for i < len(a) && j < len(b) {
		if lessFunc(a[i], b[j]) {
			aOnly = append(aOnly, a[i])
			i++
		} else if lessFunc(b[j], a[i]) {
			bOnly = append(bOnly, b[j])
			j++
		} else { // a[i] and b[j] are "equal"
			i++
			j++
		}
	}

	aOnly = append(aOnly, a[i:]...)
	bOnly = append(bOnly, b[j:]...)
	return
}

// Int64Clone clones a slice, creating a new slice
// and copying the contents of the underlying array.
// If `in` is a nil slice, a nil slice is returned.
// If `in` is an empty slice, an empty slice is returned.
func Int64Clone(in []int64) []int64 {
	if in == nil {
		return nil
	}
	if len(in) == 0 {
		return []int64{}
	}
	out := make([]int64, len(in))
	copy(out, in)
	return out
}

// Int64Find returns, given a slice and an element, the first index of elem in the slice, or -1 if the slice does
// not contain elem.
func Int64Find(slice []int64, elem int64) int {
	for i, sliceElem := range slice {
		if sliceElem == elem {
			return i
		}
	}
	return -1
}

// ConcatInt64Slices concatenates slices, returning a slice with newly allocated backing storage of the exact
// size.
func ConcatInt64Slices(slices ...[]int64) []int64 {
	length := 0
	for _, slice := range slices {
		length += len(slice)
	}
	result := make([]int64, length)
	i := 0
	for _, slice := range slices {
		nextI := i + len(slice)
		copy(result[i:nextI], slice)
		i = nextI
	}
	return result
}

// Int64Unique returns a new slice that contains only the first occurrence of each element in slice.
func Int64Unique(slice []int64) []int64 {
	result := make([]int64, 0, len(slice))
	seen := make(map[int64]struct{}, len(slice))
	for _, elem := range slice {
		if _, ok := seen[elem]; !ok {
			result = append(result, elem)
			seen[elem] = struct{}{}
		}
	}
	return result
}

// Int64Difference returns the array of elements in the first slice that aren't in the second slice
func Int64Difference(slice1, slice2 []int64) []int64 {
	if len(slice1) == 0 || len(slice2) == 0 {
		return slice1
	}

	slice2Map := make(map[int64]struct{}, len(slice2))
	for _, s := range slice2 {
		slice2Map[s] = struct{}{}
	}
	var newSlice []int64
	for _, s := range slice1 {
		if _, ok := slice2Map[s]; !ok {
			newSlice = append(newSlice, s)
		}
	}
	return newSlice
}

// Int64Union returns the union array of slice1 and slice2 without duplicates
func Int64Union(slice1, slice2 []int64) []int64 {
	// Fast path
	if len(slice1) == 0 {
		return slice2
	}
	if len(slice2) == 0 {
		return slice1
	}

	newSlice := make([]int64, len(slice1))
	copy(newSlice, slice1)

	slice1Map := make(map[int64]struct{}, len(slice1))
	for _, s := range slice1 {
		slice1Map[s] = struct{}{}
	}
	for _, s := range slice2 {
		if _, ok := slice1Map[s]; !ok {
			newSlice = append(newSlice, s)
		}
	}
	return newSlice
}

// Int8Diff returns, given two sorted int8 slices a and b, a slice of the elements occurring in a and b only,
// respectively.
func Int8Diff(a, b []int8, lessFunc func(a, b int8) bool) (aOnly, bOnly []int8) {
	i, j := 0, 0
	for i < len(a) && j < len(b) {
		if lessFunc(a[i], b[j]) {
			aOnly = append(aOnly, a[i])
			i++
		} else if lessFunc(b[j], a[i]) {
			bOnly = append(bOnly, b[j])
			j++
		} else { // a[i] and b[j] are "equal"
			i++
			j++
		}
	}

	aOnly = append(aOnly, a[i:]...)
	bOnly = append(bOnly, b[j:]...)
	return
}

// Int8Clone clones a slice, creating a new slice
// and copying the contents of the underlying array.
// If `in` is a nil slice, a nil slice is returned.
// If `in` is an empty slice, an empty slice is returned.
func Int8Clone(in []int8) []int8 {
	if in == nil {
		return nil
	}
	if len(in) == 0 {
		return []int8{}
	}
	out := make([]int8, len(in))
	copy(out, in)
	return out
}

// Int8Find returns, given a slice and an element, the first index of elem in the slice, or -1 if the slice does
// not contain elem.
func Int8Find(slice []int8, elem int8) int {
	for i, sliceElem := range slice {
		if sliceElem == elem {
			return i
		}
	}
	return -1
}

// ConcatInt8Slices concatenates slices, returning a slice with newly allocated backing storage of the exact
// size.
func ConcatInt8Slices(slices ...[]int8) []int8 {
	length := 0
	for _, slice := range slices {
		length += len(slice)
	}
	result := make([]int8, length)
	i := 0
	for _, slice := range slices {
		nextI := i + len(slice)
		copy(result[i:nextI], slice)
		i = nextI
	}
	return result
}

// Int8Unique returns a new slice that contains only the first occurrence of each element in slice.
func Int8Unique(slice []int8) []int8 {
	result := make([]int8, 0, len(slice))
	seen := make(map[int8]struct{}, len(slice))
	for _, elem := range slice {
		if _, ok := seen[elem]; !ok {
			result = append(result, elem)
			seen[elem] = struct{}{}
		}
	}
	return result
}

// Int8Difference returns the array of elements in the first slice that aren't in the second slice
func Int8Difference(slice1, slice2 []int8) []int8 {
	if len(slice1) == 0 || len(slice2) == 0 {
		return slice1
	}

	slice2Map := make(map[int8]struct{}, len(slice2))
	for _, s := range slice2 {
		slice2Map[s] = struct{}{}
	}
	var newSlice []int8
	for _, s := range slice1 {
		if _, ok := slice2Map[s]; !ok {
			newSlice = append(newSlice, s)
		}
	}
	return newSlice
}

// Int8Union returns the union array of slice1 and slice2 without duplicates
func Int8Union(slice1, slice2 []int8) []int8 {
	// Fast path
	if len(slice1) == 0 {
		return slice2
	}
	if len(slice2) == 0 {
		return slice1
	}

	newSlice := make([]int8, len(slice1))
	copy(newSlice, slice1)

	slice1Map := make(map[int8]struct{}, len(slice1))
	for _, s := range slice1 {
		slice1Map[s] = struct{}{}
	}
	for _, s := range slice2 {
		if _, ok := slice1Map[s]; !ok {
			newSlice = append(newSlice, s)
		}
	}
	return newSlice
}

// RuneDiff returns, given two sorted rune slices a and b, a slice of the elements occurring in a and b only,
// respectively.
func RuneDiff(a, b []rune, lessFunc func(a, b rune) bool) (aOnly, bOnly []rune) {
	i, j := 0, 0
	for i < len(a) && j < len(b) {
		if lessFunc(a[i], b[j]) {
			aOnly = append(aOnly, a[i])
			i++
		} else if lessFunc(b[j], a[i]) {
			bOnly = append(bOnly, b[j])
			j++
		} else { // a[i] and b[j] are "equal"
			i++
			j++
		}
	}

	aOnly = append(aOnly, a[i:]...)
	bOnly = append(bOnly, b[j:]...)
	return
}

// RuneClone clones a slice, creating a new slice
// and copying the contents of the underlying array.
// If `in` is a nil slice, a nil slice is returned.
// If `in` is an empty slice, an empty slice is returned.
func RuneClone(in []rune) []rune {
	if in == nil {
		return nil
	}
	if len(in) == 0 {
		return []rune{}
	}
	out := make([]rune, len(in))
	copy(out, in)
	return out
}

// RuneFind returns, given a slice and an element, the first index of elem in the slice, or -1 if the slice does
// not contain elem.
func RuneFind(slice []rune, elem rune) int {
	for i, sliceElem := range slice {
		if sliceElem == elem {
			return i
		}
	}
	return -1
}

// ConcatRuneSlices concatenates slices, returning a slice with newly allocated backing storage of the exact
// size.
func ConcatRuneSlices(slices ...[]rune) []rune {
	length := 0
	for _, slice := range slices {
		length += len(slice)
	}
	result := make([]rune, length)
	i := 0
	for _, slice := range slices {
		nextI := i + len(slice)
		copy(result[i:nextI], slice)
		i = nextI
	}
	return result
}

// RuneUnique returns a new slice that contains only the first occurrence of each element in slice.
func RuneUnique(slice []rune) []rune {
	result := make([]rune, 0, len(slice))
	seen := make(map[rune]struct{}, len(slice))
	for _, elem := range slice {
		if _, ok := seen[elem]; !ok {
			result = append(result, elem)
			seen[elem] = struct{}{}
		}
	}
	return result
}

// RuneDifference returns the array of elements in the first slice that aren't in the second slice
func RuneDifference(slice1, slice2 []rune) []rune {
	if len(slice1) == 0 || len(slice2) == 0 {
		return slice1
	}

	slice2Map := make(map[rune]struct{}, len(slice2))
	for _, s := range slice2 {
		slice2Map[s] = struct{}{}
	}
	var newSlice []rune
	for _, s := range slice1 {
		if _, ok := slice2Map[s]; !ok {
			newSlice = append(newSlice, s)
		}
	}
	return newSlice
}

// RuneUnion returns the union array of slice1 and slice2 without duplicates
func RuneUnion(slice1, slice2 []rune) []rune {
	// Fast path
	if len(slice1) == 0 {
		return slice2
	}
	if len(slice2) == 0 {
		return slice1
	}

	newSlice := make([]rune, len(slice1))
	copy(newSlice, slice1)

	slice1Map := make(map[rune]struct{}, len(slice1))
	for _, s := range slice1 {
		slice1Map[s] = struct{}{}
	}
	for _, s := range slice2 {
		if _, ok := slice1Map[s]; !ok {
			newSlice = append(newSlice, s)
		}
	}
	return newSlice
}

// StringDiff returns, given two sorted string slices a and b, a slice of the elements occurring in a and b only,
// respectively.
func StringDiff(a, b []string, lessFunc func(a, b string) bool) (aOnly, bOnly []string) {
	i, j := 0, 0
	for i < len(a) && j < len(b) {
		if lessFunc(a[i], b[j]) {
			aOnly = append(aOnly, a[i])
			i++
		} else if lessFunc(b[j], a[i]) {
			bOnly = append(bOnly, b[j])
			j++
		} else { // a[i] and b[j] are "equal"
			i++
			j++
		}
	}

	aOnly = append(aOnly, a[i:]...)
	bOnly = append(bOnly, b[j:]...)
	return
}

// StringClone clones a slice, creating a new slice
// and copying the contents of the underlying array.
// If `in` is a nil slice, a nil slice is returned.
// If `in` is an empty slice, an empty slice is returned.
func StringClone(in []string) []string {
	if in == nil {
		return nil
	}
	if len(in) == 0 {
		return []string{}
	}
	out := make([]string, len(in))
	copy(out, in)
	return out
}

// StringFind returns, given a slice and an element, the first index of elem in the slice, or -1 if the slice does
// not contain elem.
func StringFind(slice []string, elem string) int {
	for i, sliceElem := range slice {
		if sliceElem == elem {
			return i
		}
	}
	return -1
}

// ConcatStringSlices concatenates slices, returning a slice with newly allocated backing storage of the exact
// size.
func ConcatStringSlices(slices ...[]string) []string {
	length := 0
	for _, slice := range slices {
		length += len(slice)
	}
	result := make([]string, length)
	i := 0
	for _, slice := range slices {
		nextI := i + len(slice)
		copy(result[i:nextI], slice)
		i = nextI
	}
	return result
}

// StringUnique returns a new slice that contains only the first occurrence of each element in slice.
func StringUnique(slice []string) []string {
	result := make([]string, 0, len(slice))
	seen := make(map[string]struct{}, len(slice))
	for _, elem := range slice {
		if _, ok := seen[elem]; !ok {
			result = append(result, elem)
			seen[elem] = struct{}{}
		}
	}
	return result
}

// StringDifference returns the array of elements in the first slice that aren't in the second slice
func StringDifference(slice1, slice2 []string) []string {
	if len(slice1) == 0 || len(slice2) == 0 {
		return slice1
	}

	slice2Map := make(map[string]struct{}, len(slice2))
	for _, s := range slice2 {
		slice2Map[s] = struct{}{}
	}
	var newSlice []string
	for _, s := range slice1 {
		if _, ok := slice2Map[s]; !ok {
			newSlice = append(newSlice, s)
		}
	}
	return newSlice
}

// StringUnion returns the union array of slice1 and slice2 without duplicates
func StringUnion(slice1, slice2 []string) []string {
	// Fast path
	if len(slice1) == 0 {
		return slice2
	}
	if len(slice2) == 0 {
		return slice1
	}

	newSlice := make([]string, len(slice1))
	copy(newSlice, slice1)

	slice1Map := make(map[string]struct{}, len(slice1))
	for _, s := range slice1 {
		slice1Map[s] = struct{}{}
	}
	for _, s := range slice2 {
		if _, ok := slice1Map[s]; !ok {
			newSlice = append(newSlice, s)
		}
	}
	return newSlice
}

// UintDiff returns, given two sorted uint slices a and b, a slice of the elements occurring in a and b only,
// respectively.
func UintDiff(a, b []uint, lessFunc func(a, b uint) bool) (aOnly, bOnly []uint) {
	i, j := 0, 0
	for i < len(a) && j < len(b) {
		if lessFunc(a[i], b[j]) {
			aOnly = append(aOnly, a[i])
			i++
		} else if lessFunc(b[j], a[i]) {
			bOnly = append(bOnly, b[j])
			j++
		} else { // a[i] and b[j] are "equal"
			i++
			j++
		}
	}

	aOnly = append(aOnly, a[i:]...)
	bOnly = append(bOnly, b[j:]...)
	return
}

// UintClone clones a slice, creating a new slice
// and copying the contents of the underlying array.
// If `in` is a nil slice, a nil slice is returned.
// If `in` is an empty slice, an empty slice is returned.
func UintClone(in []uint) []uint {
	if in == nil {
		return nil
	}
	if len(in) == 0 {
		return []uint{}
	}
	out := make([]uint, len(in))
	copy(out, in)
	return out
}

// UintFind returns, given a slice and an element, the first index of elem in the slice, or -1 if the slice does
// not contain elem.
func UintFind(slice []uint, elem uint) int {
	for i, sliceElem := range slice {
		if sliceElem == elem {
			return i
		}
	}
	return -1
}

// ConcatUintSlices concatenates slices, returning a slice with newly allocated backing storage of the exact
// size.
func ConcatUintSlices(slices ...[]uint) []uint {
	length := 0
	for _, slice := range slices {
		length += len(slice)
	}
	result := make([]uint, length)
	i := 0
	for _, slice := range slices {
		nextI := i + len(slice)
		copy(result[i:nextI], slice)
		i = nextI
	}
	return result
}

// UintUnique returns a new slice that contains only the first occurrence of each element in slice.
func UintUnique(slice []uint) []uint {
	result := make([]uint, 0, len(slice))
	seen := make(map[uint]struct{}, len(slice))
	for _, elem := range slice {
		if _, ok := seen[elem]; !ok {
			result = append(result, elem)
			seen[elem] = struct{}{}
		}
	}
	return result
}

// UintDifference returns the array of elements in the first slice that aren't in the second slice
func UintDifference(slice1, slice2 []uint) []uint {
	if len(slice1) == 0 || len(slice2) == 0 {
		return slice1
	}

	slice2Map := make(map[uint]struct{}, len(slice2))
	for _, s := range slice2 {
		slice2Map[s] = struct{}{}
	}
	var newSlice []uint
	for _, s := range slice1 {
		if _, ok := slice2Map[s]; !ok {
			newSlice = append(newSlice, s)
		}
	}
	return newSlice
}

// UintUnion returns the union array of slice1 and slice2 without duplicates
func UintUnion(slice1, slice2 []uint) []uint {
	// Fast path
	if len(slice1) == 0 {
		return slice2
	}
	if len(slice2) == 0 {
		return slice1
	}

	newSlice := make([]uint, len(slice1))
	copy(newSlice, slice1)

	slice1Map := make(map[uint]struct{}, len(slice1))
	for _, s := range slice1 {
		slice1Map[s] = struct{}{}
	}
	for _, s := range slice2 {
		if _, ok := slice1Map[s]; !ok {
			newSlice = append(newSlice, s)
		}
	}
	return newSlice
}

// Uint16Diff returns, given two sorted uint16 slices a and b, a slice of the elements occurring in a and b only,
// respectively.
func Uint16Diff(a, b []uint16, lessFunc func(a, b uint16) bool) (aOnly, bOnly []uint16) {
	i, j := 0, 0
	for i < len(a) && j < len(b) {
		if lessFunc(a[i], b[j]) {
			aOnly = append(aOnly, a[i])
			i++
		} else if lessFunc(b[j], a[i]) {
			bOnly = append(bOnly, b[j])
			j++
		} else { // a[i] and b[j] are "equal"
			i++
			j++
		}
	}

	aOnly = append(aOnly, a[i:]...)
	bOnly = append(bOnly, b[j:]...)
	return
}

// Uint16Clone clones a slice, creating a new slice
// and copying the contents of the underlying array.
// If `in` is a nil slice, a nil slice is returned.
// If `in` is an empty slice, an empty slice is returned.
func Uint16Clone(in []uint16) []uint16 {
	if in == nil {
		return nil
	}
	if len(in) == 0 {
		return []uint16{}
	}
	out := make([]uint16, len(in))
	copy(out, in)
	return out
}

// Uint16Find returns, given a slice and an element, the first index of elem in the slice, or -1 if the slice does
// not contain elem.
func Uint16Find(slice []uint16, elem uint16) int {
	for i, sliceElem := range slice {
		if sliceElem == elem {
			return i
		}
	}
	return -1
}

// ConcatUint16Slices concatenates slices, returning a slice with newly allocated backing storage of the exact
// size.
func ConcatUint16Slices(slices ...[]uint16) []uint16 {
	length := 0
	for _, slice := range slices {
		length += len(slice)
	}
	result := make([]uint16, length)
	i := 0
	for _, slice := range slices {
		nextI := i + len(slice)
		copy(result[i:nextI], slice)
		i = nextI
	}
	return result
}

// Uint16Unique returns a new slice that contains only the first occurrence of each element in slice.
func Uint16Unique(slice []uint16) []uint16 {
	result := make([]uint16, 0, len(slice))
	seen := make(map[uint16]struct{}, len(slice))
	for _, elem := range slice {
		if _, ok := seen[elem]; !ok {
			result = append(result, elem)
			seen[elem] = struct{}{}
		}
	}
	return result
}

// Uint16Difference returns the array of elements in the first slice that aren't in the second slice
func Uint16Difference(slice1, slice2 []uint16) []uint16 {
	if len(slice1) == 0 || len(slice2) == 0 {
		return slice1
	}

	slice2Map := make(map[uint16]struct{}, len(slice2))
	for _, s := range slice2 {
		slice2Map[s] = struct{}{}
	}
	var newSlice []uint16
	for _, s := range slice1 {
		if _, ok := slice2Map[s]; !ok {
			newSlice = append(newSlice, s)
		}
	}
	return newSlice
}

// Uint16Union returns the union array of slice1 and slice2 without duplicates
func Uint16Union(slice1, slice2 []uint16) []uint16 {
	// Fast path
	if len(slice1) == 0 {
		return slice2
	}
	if len(slice2) == 0 {
		return slice1
	}

	newSlice := make([]uint16, len(slice1))
	copy(newSlice, slice1)

	slice1Map := make(map[uint16]struct{}, len(slice1))
	for _, s := range slice1 {
		slice1Map[s] = struct{}{}
	}
	for _, s := range slice2 {
		if _, ok := slice1Map[s]; !ok {
			newSlice = append(newSlice, s)
		}
	}
	return newSlice
}

// Uint32Diff returns, given two sorted uint32 slices a and b, a slice of the elements occurring in a and b only,
// respectively.
func Uint32Diff(a, b []uint32, lessFunc func(a, b uint32) bool) (aOnly, bOnly []uint32) {
	i, j := 0, 0
	for i < len(a) && j < len(b) {
		if lessFunc(a[i], b[j]) {
			aOnly = append(aOnly, a[i])
			i++
		} else if lessFunc(b[j], a[i]) {
			bOnly = append(bOnly, b[j])
			j++
		} else { // a[i] and b[j] are "equal"
			i++
			j++
		}
	}

	aOnly = append(aOnly, a[i:]...)
	bOnly = append(bOnly, b[j:]...)
	return
}

// Uint32Clone clones a slice, creating a new slice
// and copying the contents of the underlying array.
// If `in` is a nil slice, a nil slice is returned.
// If `in` is an empty slice, an empty slice is returned.
func Uint32Clone(in []uint32) []uint32 {
	if in == nil {
		return nil
	}
	if len(in) == 0 {
		return []uint32{}
	}
	out := make([]uint32, len(in))
	copy(out, in)
	return out
}

// Uint32Find returns, given a slice and an element, the first index of elem in the slice, or -1 if the slice does
// not contain elem.
func Uint32Find(slice []uint32, elem uint32) int {
	for i, sliceElem := range slice {
		if sliceElem == elem {
			return i
		}
	}
	return -1
}

// ConcatUint32Slices concatenates slices, returning a slice with newly allocated backing storage of the exact
// size.
func ConcatUint32Slices(slices ...[]uint32) []uint32 {
	length := 0
	for _, slice := range slices {
		length += len(slice)
	}
	result := make([]uint32, length)
	i := 0
	for _, slice := range slices {
		nextI := i + len(slice)
		copy(result[i:nextI], slice)
		i = nextI
	}
	return result
}

// Uint32Unique returns a new slice that contains only the first occurrence of each element in slice.
func Uint32Unique(slice []uint32) []uint32 {
	result := make([]uint32, 0, len(slice))
	seen := make(map[uint32]struct{}, len(slice))
	for _, elem := range slice {
		if _, ok := seen[elem]; !ok {
			result = append(result, elem)
			seen[elem] = struct{}{}
		}
	}
	return result
}

// Uint32Difference returns the array of elements in the first slice that aren't in the second slice
func Uint32Difference(slice1, slice2 []uint32) []uint32 {
	if len(slice1) == 0 || len(slice2) == 0 {
		return slice1
	}

	slice2Map := make(map[uint32]struct{}, len(slice2))
	for _, s := range slice2 {
		slice2Map[s] = struct{}{}
	}
	var newSlice []uint32
	for _, s := range slice1 {
		if _, ok := slice2Map[s]; !ok {
			newSlice = append(newSlice, s)
		}
	}
	return newSlice
}

// Uint32Union returns the union array of slice1 and slice2 without duplicates
func Uint32Union(slice1, slice2 []uint32) []uint32 {
	// Fast path
	if len(slice1) == 0 {
		return slice2
	}
	if len(slice2) == 0 {
		return slice1
	}

	newSlice := make([]uint32, len(slice1))
	copy(newSlice, slice1)

	slice1Map := make(map[uint32]struct{}, len(slice1))
	for _, s := range slice1 {
		slice1Map[s] = struct{}{}
	}
	for _, s := range slice2 {
		if _, ok := slice1Map[s]; !ok {
			newSlice = append(newSlice, s)
		}
	}
	return newSlice
}

// Uint64Diff returns, given two sorted uint64 slices a and b, a slice of the elements occurring in a and b only,
// respectively.
func Uint64Diff(a, b []uint64, lessFunc func(a, b uint64) bool) (aOnly, bOnly []uint64) {
	i, j := 0, 0
	for i < len(a) && j < len(b) {
		if lessFunc(a[i], b[j]) {
			aOnly = append(aOnly, a[i])
			i++
		} else if lessFunc(b[j], a[i]) {
			bOnly = append(bOnly, b[j])
			j++
		} else { // a[i] and b[j] are "equal"
			i++
			j++
		}
	}

	aOnly = append(aOnly, a[i:]...)
	bOnly = append(bOnly, b[j:]...)
	return
}

// Uint64Clone clones a slice, creating a new slice
// and copying the contents of the underlying array.
// If `in` is a nil slice, a nil slice is returned.
// If `in` is an empty slice, an empty slice is returned.
func Uint64Clone(in []uint64) []uint64 {
	if in == nil {
		return nil
	}
	if len(in) == 0 {
		return []uint64{}
	}
	out := make([]uint64, len(in))
	copy(out, in)
	return out
}

// Uint64Find returns, given a slice and an element, the first index of elem in the slice, or -1 if the slice does
// not contain elem.
func Uint64Find(slice []uint64, elem uint64) int {
	for i, sliceElem := range slice {
		if sliceElem == elem {
			return i
		}
	}
	return -1
}

// ConcatUint64Slices concatenates slices, returning a slice with newly allocated backing storage of the exact
// size.
func ConcatUint64Slices(slices ...[]uint64) []uint64 {
	length := 0
	for _, slice := range slices {
		length += len(slice)
	}
	result := make([]uint64, length)
	i := 0
	for _, slice := range slices {
		nextI := i + len(slice)
		copy(result[i:nextI], slice)
		i = nextI
	}
	return result
}

// Uint64Unique returns a new slice that contains only the first occurrence of each element in slice.
func Uint64Unique(slice []uint64) []uint64 {
	result := make([]uint64, 0, len(slice))
	seen := make(map[uint64]struct{}, len(slice))
	for _, elem := range slice {
		if _, ok := seen[elem]; !ok {
			result = append(result, elem)
			seen[elem] = struct{}{}
		}
	}
	return result
}

// Uint64Difference returns the array of elements in the first slice that aren't in the second slice
func Uint64Difference(slice1, slice2 []uint64) []uint64 {
	if len(slice1) == 0 || len(slice2) == 0 {
		return slice1
	}

	slice2Map := make(map[uint64]struct{}, len(slice2))
	for _, s := range slice2 {
		slice2Map[s] = struct{}{}
	}
	var newSlice []uint64
	for _, s := range slice1 {
		if _, ok := slice2Map[s]; !ok {
			newSlice = append(newSlice, s)
		}
	}
	return newSlice
}

// Uint64Union returns the union array of slice1 and slice2 without duplicates
func Uint64Union(slice1, slice2 []uint64) []uint64 {
	// Fast path
	if len(slice1) == 0 {
		return slice2
	}
	if len(slice2) == 0 {
		return slice1
	}

	newSlice := make([]uint64, len(slice1))
	copy(newSlice, slice1)

	slice1Map := make(map[uint64]struct{}, len(slice1))
	for _, s := range slice1 {
		slice1Map[s] = struct{}{}
	}
	for _, s := range slice2 {
		if _, ok := slice1Map[s]; !ok {
			newSlice = append(newSlice, s)
		}
	}
	return newSlice
}

// Uint8Diff returns, given two sorted uint8 slices a and b, a slice of the elements occurring in a and b only,
// respectively.
func Uint8Diff(a, b []uint8, lessFunc func(a, b uint8) bool) (aOnly, bOnly []uint8) {
	i, j := 0, 0
	for i < len(a) && j < len(b) {
		if lessFunc(a[i], b[j]) {
			aOnly = append(aOnly, a[i])
			i++
		} else if lessFunc(b[j], a[i]) {
			bOnly = append(bOnly, b[j])
			j++
		} else { // a[i] and b[j] are "equal"
			i++
			j++
		}
	}

	aOnly = append(aOnly, a[i:]...)
	bOnly = append(bOnly, b[j:]...)
	return
}

// Uint8Clone clones a slice, creating a new slice
// and copying the contents of the underlying array.
// If `in` is a nil slice, a nil slice is returned.
// If `in` is an empty slice, an empty slice is returned.
func Uint8Clone(in []uint8) []uint8 {
	if in == nil {
		return nil
	}
	if len(in) == 0 {
		return []uint8{}
	}
	out := make([]uint8, len(in))
	copy(out, in)
	return out
}

// Uint8Find returns, given a slice and an element, the first index of elem in the slice, or -1 if the slice does
// not contain elem.
func Uint8Find(slice []uint8, elem uint8) int {
	for i, sliceElem := range slice {
		if sliceElem == elem {
			return i
		}
	}
	return -1
}

// ConcatUint8Slices concatenates slices, returning a slice with newly allocated backing storage of the exact
// size.
func ConcatUint8Slices(slices ...[]uint8) []uint8 {
	length := 0
	for _, slice := range slices {
		length += len(slice)
	}
	result := make([]uint8, length)
	i := 0
	for _, slice := range slices {
		nextI := i + len(slice)
		copy(result[i:nextI], slice)
		i = nextI
	}
	return result
}

// Uint8Unique returns a new slice that contains only the first occurrence of each element in slice.
func Uint8Unique(slice []uint8) []uint8 {
	result := make([]uint8, 0, len(slice))
	seen := make(map[uint8]struct{}, len(slice))
	for _, elem := range slice {
		if _, ok := seen[elem]; !ok {
			result = append(result, elem)
			seen[elem] = struct{}{}
		}
	}
	return result
}

// Uint8Difference returns the array of elements in the first slice that aren't in the second slice
func Uint8Difference(slice1, slice2 []uint8) []uint8 {
	if len(slice1) == 0 || len(slice2) == 0 {
		return slice1
	}

	slice2Map := make(map[uint8]struct{}, len(slice2))
	for _, s := range slice2 {
		slice2Map[s] = struct{}{}
	}
	var newSlice []uint8
	for _, s := range slice1 {
		if _, ok := slice2Map[s]; !ok {
			newSlice = append(newSlice, s)
		}
	}
	return newSlice
}

// Uint8Union returns the union array of slice1 and slice2 without duplicates
func Uint8Union(slice1, slice2 []uint8) []uint8 {
	// Fast path
	if len(slice1) == 0 {
		return slice2
	}
	if len(slice2) == 0 {
		return slice1
	}

	newSlice := make([]uint8, len(slice1))
	copy(newSlice, slice1)

	slice1Map := make(map[uint8]struct{}, len(slice1))
	for _, s := range slice1 {
		slice1Map[s] = struct{}{}
	}
	for _, s := range slice2 {
		if _, ok := slice1Map[s]; !ok {
			newSlice = append(newSlice, s)
		}
	}
	return newSlice
}

// UintptrDiff returns, given two sorted uintptr slices a and b, a slice of the elements occurring in a and b only,
// respectively.
func UintptrDiff(a, b []uintptr, lessFunc func(a, b uintptr) bool) (aOnly, bOnly []uintptr) {
	i, j := 0, 0
	for i < len(a) && j < len(b) {
		if lessFunc(a[i], b[j]) {
			aOnly = append(aOnly, a[i])
			i++
		} else if lessFunc(b[j], a[i]) {
			bOnly = append(bOnly, b[j])
			j++
		} else { // a[i] and b[j] are "equal"
			i++
			j++
		}
	}

	aOnly = append(aOnly, a[i:]...)
	bOnly = append(bOnly, b[j:]...)
	return
}

// UintptrClone clones a slice, creating a new slice
// and copying the contents of the underlying array.
// If `in` is a nil slice, a nil slice is returned.
// If `in` is an empty slice, an empty slice is returned.
func UintptrClone(in []uintptr) []uintptr {
	if in == nil {
		return nil
	}
	if len(in) == 0 {
		return []uintptr{}
	}
	out := make([]uintptr, len(in))
	copy(out, in)
	return out
}

// UintptrFind returns, given a slice and an element, the first index of elem in the slice, or -1 if the slice does
// not contain elem.
func UintptrFind(slice []uintptr, elem uintptr) int {
	for i, sliceElem := range slice {
		if sliceElem == elem {
			return i
		}
	}
	return -1
}

// ConcatUintptrSlices concatenates slices, returning a slice with newly allocated backing storage of the exact
// size.
func ConcatUintptrSlices(slices ...[]uintptr) []uintptr {
	length := 0
	for _, slice := range slices {
		length += len(slice)
	}
	result := make([]uintptr, length)
	i := 0
	for _, slice := range slices {
		nextI := i + len(slice)
		copy(result[i:nextI], slice)
		i = nextI
	}
	return result
}

// UintptrUnique returns a new slice that contains only the first occurrence of each element in slice.
func UintptrUnique(slice []uintptr) []uintptr {
	result := make([]uintptr, 0, len(slice))
	seen := make(map[uintptr]struct{}, len(slice))
	for _, elem := range slice {
		if _, ok := seen[elem]; !ok {
			result = append(result, elem)
			seen[elem] = struct{}{}
		}
	}
	return result
}

// UintptrDifference returns the array of elements in the first slice that aren't in the second slice
func UintptrDifference(slice1, slice2 []uintptr) []uintptr {
	if len(slice1) == 0 || len(slice2) == 0 {
		return slice1
	}

	slice2Map := make(map[uintptr]struct{}, len(slice2))
	for _, s := range slice2 {
		slice2Map[s] = struct{}{}
	}
	var newSlice []uintptr
	for _, s := range slice1 {
		if _, ok := slice2Map[s]; !ok {
			newSlice = append(newSlice, s)
		}
	}
	return newSlice
}

// UintptrUnion returns the union array of slice1 and slice2 without duplicates
func UintptrUnion(slice1, slice2 []uintptr) []uintptr {
	// Fast path
	if len(slice1) == 0 {
		return slice2
	}
	if len(slice2) == 0 {
		return slice1
	}

	newSlice := make([]uintptr, len(slice1))
	copy(newSlice, slice1)

	slice1Map := make(map[uintptr]struct{}, len(slice1))
	for _, s := range slice1 {
		slice1Map[s] = struct{}{}
	}
	for _, s := range slice2 {
		if _, ok := slice1Map[s]; !ok {
			newSlice = append(newSlice, s)
		}
	}
	return newSlice
}
