## helm dependency update

update charts/ based on the contents of requirements.yaml

### Synopsis


Update the on-disk dependencies to mirror the requirements.yaml file.

This command verifies that the required charts, as expressed in 'requirements.yaml',
are present in 'charts/' and are at an acceptable version. It will pull down
the latest charts that satisfy the dependencies, and clean up old dependencies.

On successful update, this will generate a lock file that can be used to
rebuild the requirements to an exact version.

Dependencies are not required to be represented in 'requirements.yaml'. For that
reason, an update command will not remove charts unless they are (a) present
in the requirements.yaml file, but (b) at the wrong version.


```
helm dependency update [flags] CHART
```

### Options

```
  -h, --help             help for update
      --keyring string   keyring containing public keys (default "~/.gnupg/pubring.gpg")
      --skip-refresh     do not refresh the local repository cache
      --verify           verify the packages against signatures
```

### Options inherited from parent commands

```
      --debug                           enable verbose output
      --home string                     location of your Helm config. Overrides $HELM_HOME (default "~/.helm")
      --host string                     address of Tiller. Overrides $HELM_HOST
      --kube-context string             name of the kubeconfig context to use
      --kubeconfig string               absolute path to the kubeconfig file to use
      --tiller-connection-timeout int   the duration (in seconds) Helm will wait to establish a connection to tiller (default 300)
      --tiller-namespace string         namespace of Tiller (default "kube-system")
```

### SEE ALSO

* [helm dependency](helm_dependency.md)	 - manage a chart's dependencies

###### Auto generated by spf13/cobra on 1-Aug-2018
