# Vulnerability Report
A Vulnerability Report is a structure describing a specific manifest, its contents, and the vulnerabilities affecting its contents.

```go
// VulnerabilityReport provides a report of packages and their
// associated vulnerabilities.
type VulnerabilityReport struct {
	// the manifest hash this vulnerability report is describing
	Hash Digest `json:"manifest_hash"`
	// all discovered packages in this manifest keyed by package id
	Packages map[string]*Package `json:"packages"`
	// all discovered distributions in this manifest keyed by distribution id
	Distributions map[string]*Distribution `json:"distributions"`
	// all discovered repositories in this manifest keyed by repository id
	Repositories map[string]*Repository `json:"repository"`
	// a list of environment details a package was discovered in keyed by package id
	Environments map[string][]*Environment `json:"environments"`
	// all discovered vulnerabilities affecting this manifest
	Vulnerabilities map[string]*Vulnerability `json:"vulnerabilities"`
	// a lookup table associating package ids with 1 or more vulnerability ids. keyed by package id
	PackageVulnerabilities map[string][]string `json:"package_vulnerabilities"`
}
```

A Vulnerability Report is package focused.

Unpacking a report is done by mapping the keys in the PackageVulnerabilities field to the data structures in other lookup maps.

For example:

```go
for pkgID, vulnIDS := range report.PackageVulnerabilities {
    // get package data structure
	pkg := report.Packages[pkgID]
	// get the environments the package was discovered
	envs := report.Environments[pkgID]

	// print the locations the package was found in
	for _, env := range envs {
		dist := report.Distributions[env.DistributionID]
		introLayer := report.IntroducedIn.String()
		log.Printf("package %+v with dist %+v found in layer %+v", pkg, dist, introLayer)
	}

	for _, vulnID := range vulnIDS {
		vuln := report.Vulnerabilities[vulnID]
		log.Printf("package %+v affected by vuln %+v", pkg, vuln)
	}
}

```
