/*
Copyright 2019 Openstorage.org

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1

import (
	v1 "github.com/libopenstorage/operator/pkg/apis/core/v1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// StorageClusterLister helps list StorageClusters.
type StorageClusterLister interface {
	// List lists all StorageClusters in the indexer.
	List(selector labels.Selector) (ret []*v1.StorageCluster, err error)
	// StorageClusters returns an object that can list and get StorageClusters.
	StorageClusters(namespace string) StorageClusterNamespaceLister
	StorageClusterListerExpansion
}

// storageClusterLister implements the StorageClusterLister interface.
type storageClusterLister struct {
	indexer cache.Indexer
}

// NewStorageClusterLister returns a new StorageClusterLister.
func NewStorageClusterLister(indexer cache.Indexer) StorageClusterLister {
	return &storageClusterLister{indexer: indexer}
}

// List lists all StorageClusters in the indexer.
func (s *storageClusterLister) List(selector labels.Selector) (ret []*v1.StorageCluster, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.StorageCluster))
	})
	return ret, err
}

// StorageClusters returns an object that can list and get StorageClusters.
func (s *storageClusterLister) StorageClusters(namespace string) StorageClusterNamespaceLister {
	return storageClusterNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// StorageClusterNamespaceLister helps list and get StorageClusters.
type StorageClusterNamespaceLister interface {
	// List lists all StorageClusters in the indexer for a given namespace.
	List(selector labels.Selector) (ret []*v1.StorageCluster, err error)
	// Get retrieves the StorageCluster from the indexer for a given namespace and name.
	Get(name string) (*v1.StorageCluster, error)
	StorageClusterNamespaceListerExpansion
}

// storageClusterNamespaceLister implements the StorageClusterNamespaceLister
// interface.
type storageClusterNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all StorageClusters in the indexer for a given namespace.
func (s storageClusterNamespaceLister) List(selector labels.Selector) (ret []*v1.StorageCluster, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.StorageCluster))
	})
	return ret, err
}

// Get retrieves the StorageCluster from the indexer for a given namespace and name.
func (s storageClusterNamespaceLister) Get(name string) (*v1.StorageCluster, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1.Resource("storagecluster"), name)
	}
	return obj.(*v1.StorageCluster), nil
}
