package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AgreeInvite invokes the baas.AgreeInvite API synchronously
// api document: https://help.aliyun.com/api/baas/agreeinvite.html
func (client *Client) AgreeInvite(request *AgreeInviteRequest) (response *AgreeInviteResponse, err error) {
	response = CreateAgreeInviteResponse()
	err = client.DoAction(request, response)
	return
}

// AgreeInviteWithChan invokes the baas.AgreeInvite API asynchronously
// api document: https://help.aliyun.com/api/baas/agreeinvite.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AgreeInviteWithChan(request *AgreeInviteRequest) (<-chan *AgreeInviteResponse, <-chan error) {
	responseChan := make(chan *AgreeInviteResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AgreeInvite(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AgreeInviteWithCallback invokes the baas.AgreeInvite API asynchronously
// api document: https://help.aliyun.com/api/baas/agreeinvite.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AgreeInviteWithCallback(request *AgreeInviteRequest, callback func(response *AgreeInviteResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AgreeInviteResponse
		var err error
		defer close(result)
		response, err = client.AgreeInvite(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AgreeInviteRequest is the request struct for api AgreeInvite
type AgreeInviteRequest struct {
	*requests.RpcRequest
	Code string `position:"Body" name:"Code"`
}

// AgreeInviteResponse is the response struct for api AgreeInvite
type AgreeInviteResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    string `json:"Result" xml:"Result"`
}

// CreateAgreeInviteRequest creates a request to invoke AgreeInvite API
func CreateAgreeInviteRequest() (request *AgreeInviteRequest) {
	request = &AgreeInviteRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-07-31", "AgreeInvite", "", "")
	return
}

// CreateAgreeInviteResponse creates a response to parse from AgreeInvite response
func CreateAgreeInviteResponse() (response *AgreeInviteResponse) {
	response = &AgreeInviteResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
