package mts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BindOutputBucket invokes the mts.BindOutputBucket API synchronously
// api document: https://help.aliyun.com/api/mts/bindoutputbucket.html
func (client *Client) BindOutputBucket(request *BindOutputBucketRequest) (response *BindOutputBucketResponse, err error) {
	response = CreateBindOutputBucketResponse()
	err = client.DoAction(request, response)
	return
}

// BindOutputBucketWithChan invokes the mts.BindOutputBucket API asynchronously
// api document: https://help.aliyun.com/api/mts/bindoutputbucket.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) BindOutputBucketWithChan(request *BindOutputBucketRequest) (<-chan *BindOutputBucketResponse, <-chan error) {
	responseChan := make(chan *BindOutputBucketResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BindOutputBucket(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BindOutputBucketWithCallback invokes the mts.BindOutputBucket API asynchronously
// api document: https://help.aliyun.com/api/mts/bindoutputbucket.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) BindOutputBucketWithCallback(request *BindOutputBucketRequest, callback func(response *BindOutputBucketResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BindOutputBucketResponse
		var err error
		defer close(result)
		response, err = client.BindOutputBucket(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BindOutputBucketRequest is the request struct for api BindOutputBucket
type BindOutputBucketRequest struct {
	*requests.RpcRequest
	Bucket               string           `position:"Query" name:"Bucket"`
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	RoleArn              string           `position:"Query" name:"RoleArn"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// BindOutputBucketResponse is the response struct for api BindOutputBucket
type BindOutputBucketResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateBindOutputBucketRequest creates a request to invoke BindOutputBucket API
func CreateBindOutputBucketRequest() (request *BindOutputBucketRequest) {
	request = &BindOutputBucketRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Mts", "2014-06-18", "BindOutputBucket", "mts", "openAPI")
	return
}

// CreateBindOutputBucketResponse creates a response to parse from BindOutputBucket response
func CreateBindOutputBucketResponse() (response *BindOutputBucketResponse) {
	response = &BindOutputBucketResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
