/*
Copyright 2018 Openstorage.org

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"time"

	v1alpha1 "github.com/libopenstorage/stork/pkg/apis/stork/v1alpha1"
	scheme "github.com/libopenstorage/stork/pkg/client/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// MigrationSchedulesGetter has a method to return a MigrationScheduleInterface.
// A group's client should implement this interface.
type MigrationSchedulesGetter interface {
	MigrationSchedules(namespace string) MigrationScheduleInterface
}

// MigrationScheduleInterface has methods to work with MigrationSchedule resources.
type MigrationScheduleInterface interface {
	Create(*v1alpha1.MigrationSchedule) (*v1alpha1.MigrationSchedule, error)
	Update(*v1alpha1.MigrationSchedule) (*v1alpha1.MigrationSchedule, error)
	UpdateStatus(*v1alpha1.MigrationSchedule) (*v1alpha1.MigrationSchedule, error)
	Delete(name string, options *v1.DeleteOptions) error
	DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error
	Get(name string, options v1.GetOptions) (*v1alpha1.MigrationSchedule, error)
	List(opts v1.ListOptions) (*v1alpha1.MigrationScheduleList, error)
	Watch(opts v1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha1.MigrationSchedule, err error)
	MigrationScheduleExpansion
}

// migrationSchedules implements MigrationScheduleInterface
type migrationSchedules struct {
	client rest.Interface
	ns     string
}

// newMigrationSchedules returns a MigrationSchedules
func newMigrationSchedules(c *StorkV1alpha1Client, namespace string) *migrationSchedules {
	return &migrationSchedules{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the migrationSchedule, and returns the corresponding migrationSchedule object, and an error if there is any.
func (c *migrationSchedules) Get(name string, options v1.GetOptions) (result *v1alpha1.MigrationSchedule, err error) {
	result = &v1alpha1.MigrationSchedule{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("migrationschedules").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of MigrationSchedules that match those selectors.
func (c *migrationSchedules) List(opts v1.ListOptions) (result *v1alpha1.MigrationScheduleList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1alpha1.MigrationScheduleList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("migrationschedules").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do().
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested migrationSchedules.
func (c *migrationSchedules) Watch(opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("migrationschedules").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch()
}

// Create takes the representation of a migrationSchedule and creates it.  Returns the server's representation of the migrationSchedule, and an error, if there is any.
func (c *migrationSchedules) Create(migrationSchedule *v1alpha1.MigrationSchedule) (result *v1alpha1.MigrationSchedule, err error) {
	result = &v1alpha1.MigrationSchedule{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("migrationschedules").
		Body(migrationSchedule).
		Do().
		Into(result)
	return
}

// Update takes the representation of a migrationSchedule and updates it. Returns the server's representation of the migrationSchedule, and an error, if there is any.
func (c *migrationSchedules) Update(migrationSchedule *v1alpha1.MigrationSchedule) (result *v1alpha1.MigrationSchedule, err error) {
	result = &v1alpha1.MigrationSchedule{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("migrationschedules").
		Name(migrationSchedule.Name).
		Body(migrationSchedule).
		Do().
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().

func (c *migrationSchedules) UpdateStatus(migrationSchedule *v1alpha1.MigrationSchedule) (result *v1alpha1.MigrationSchedule, err error) {
	result = &v1alpha1.MigrationSchedule{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("migrationschedules").
		Name(migrationSchedule.Name).
		SubResource("status").
		Body(migrationSchedule).
		Do().
		Into(result)
	return
}

// Delete takes name of the migrationSchedule and deletes it. Returns an error if one occurs.
func (c *migrationSchedules) Delete(name string, options *v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("migrationschedules").
		Name(name).
		Body(options).
		Do().
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *migrationSchedules) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	var timeout time.Duration
	if listOptions.TimeoutSeconds != nil {
		timeout = time.Duration(*listOptions.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("migrationschedules").
		VersionedParams(&listOptions, scheme.ParameterCodec).
		Timeout(timeout).
		Body(options).
		Do().
		Error()
}

// Patch applies the patch and returns the patched migrationSchedule.
func (c *migrationSchedules) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha1.MigrationSchedule, err error) {
	result = &v1alpha1.MigrationSchedule{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("migrationschedules").
		SubResource(subresources...).
		Name(name).
		Body(data).
		Do().
		Into(result)
	return
}
