/*
Copyright 2018 Openstorage.org

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"time"

	v1alpha1 "github.com/libopenstorage/stork/pkg/apis/stork/v1alpha1"
	scheme "github.com/libopenstorage/stork/pkg/client/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// VolumeSnapshotSchedulesGetter has a method to return a VolumeSnapshotScheduleInterface.
// A group's client should implement this interface.
type VolumeSnapshotSchedulesGetter interface {
	VolumeSnapshotSchedules(namespace string) VolumeSnapshotScheduleInterface
}

// VolumeSnapshotScheduleInterface has methods to work with VolumeSnapshotSchedule resources.
type VolumeSnapshotScheduleInterface interface {
	Create(*v1alpha1.VolumeSnapshotSchedule) (*v1alpha1.VolumeSnapshotSchedule, error)
	Update(*v1alpha1.VolumeSnapshotSchedule) (*v1alpha1.VolumeSnapshotSchedule, error)
	UpdateStatus(*v1alpha1.VolumeSnapshotSchedule) (*v1alpha1.VolumeSnapshotSchedule, error)
	Delete(name string, options *v1.DeleteOptions) error
	DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error
	Get(name string, options v1.GetOptions) (*v1alpha1.VolumeSnapshotSchedule, error)
	List(opts v1.ListOptions) (*v1alpha1.VolumeSnapshotScheduleList, error)
	Watch(opts v1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha1.VolumeSnapshotSchedule, err error)
	VolumeSnapshotScheduleExpansion
}

// volumeSnapshotSchedules implements VolumeSnapshotScheduleInterface
type volumeSnapshotSchedules struct {
	client rest.Interface
	ns     string
}

// newVolumeSnapshotSchedules returns a VolumeSnapshotSchedules
func newVolumeSnapshotSchedules(c *StorkV1alpha1Client, namespace string) *volumeSnapshotSchedules {
	return &volumeSnapshotSchedules{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the volumeSnapshotSchedule, and returns the corresponding volumeSnapshotSchedule object, and an error if there is any.
func (c *volumeSnapshotSchedules) Get(name string, options v1.GetOptions) (result *v1alpha1.VolumeSnapshotSchedule, err error) {
	result = &v1alpha1.VolumeSnapshotSchedule{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("volumesnapshotschedules").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of VolumeSnapshotSchedules that match those selectors.
func (c *volumeSnapshotSchedules) List(opts v1.ListOptions) (result *v1alpha1.VolumeSnapshotScheduleList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1alpha1.VolumeSnapshotScheduleList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("volumesnapshotschedules").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do().
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested volumeSnapshotSchedules.
func (c *volumeSnapshotSchedules) Watch(opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("volumesnapshotschedules").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch()
}

// Create takes the representation of a volumeSnapshotSchedule and creates it.  Returns the server's representation of the volumeSnapshotSchedule, and an error, if there is any.
func (c *volumeSnapshotSchedules) Create(volumeSnapshotSchedule *v1alpha1.VolumeSnapshotSchedule) (result *v1alpha1.VolumeSnapshotSchedule, err error) {
	result = &v1alpha1.VolumeSnapshotSchedule{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("volumesnapshotschedules").
		Body(volumeSnapshotSchedule).
		Do().
		Into(result)
	return
}

// Update takes the representation of a volumeSnapshotSchedule and updates it. Returns the server's representation of the volumeSnapshotSchedule, and an error, if there is any.
func (c *volumeSnapshotSchedules) Update(volumeSnapshotSchedule *v1alpha1.VolumeSnapshotSchedule) (result *v1alpha1.VolumeSnapshotSchedule, err error) {
	result = &v1alpha1.VolumeSnapshotSchedule{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("volumesnapshotschedules").
		Name(volumeSnapshotSchedule.Name).
		Body(volumeSnapshotSchedule).
		Do().
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().

func (c *volumeSnapshotSchedules) UpdateStatus(volumeSnapshotSchedule *v1alpha1.VolumeSnapshotSchedule) (result *v1alpha1.VolumeSnapshotSchedule, err error) {
	result = &v1alpha1.VolumeSnapshotSchedule{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("volumesnapshotschedules").
		Name(volumeSnapshotSchedule.Name).
		SubResource("status").
		Body(volumeSnapshotSchedule).
		Do().
		Into(result)
	return
}

// Delete takes name of the volumeSnapshotSchedule and deletes it. Returns an error if one occurs.
func (c *volumeSnapshotSchedules) Delete(name string, options *v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("volumesnapshotschedules").
		Name(name).
		Body(options).
		Do().
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *volumeSnapshotSchedules) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	var timeout time.Duration
	if listOptions.TimeoutSeconds != nil {
		timeout = time.Duration(*listOptions.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("volumesnapshotschedules").
		VersionedParams(&listOptions, scheme.ParameterCodec).
		Timeout(timeout).
		Body(options).
		Do().
		Error()
}

// Patch applies the patch and returns the patched volumeSnapshotSchedule.
func (c *volumeSnapshotSchedules) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha1.VolumeSnapshotSchedule, err error) {
	result = &v1alpha1.VolumeSnapshotSchedule{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("volumesnapshotschedules").
		SubResource(subresources...).
		Name(name).
		Body(data).
		Do().
		Into(result)
	return
}
