/*
Copyright 2018 Openstorage.org

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"time"

	v1alpha1 "github.com/libopenstorage/stork/pkg/apis/stork/v1alpha1"
	scheme "github.com/libopenstorage/stork/pkg/client/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// ClusterDomainsStatusesGetter has a method to return a ClusterDomainsStatusInterface.
// A group's client should implement this interface.
type ClusterDomainsStatusesGetter interface {
	ClusterDomainsStatuses() ClusterDomainsStatusInterface
}

// ClusterDomainsStatusInterface has methods to work with ClusterDomainsStatus resources.
type ClusterDomainsStatusInterface interface {
	Create(*v1alpha1.ClusterDomainsStatus) (*v1alpha1.ClusterDomainsStatus, error)
	Update(*v1alpha1.ClusterDomainsStatus) (*v1alpha1.ClusterDomainsStatus, error)
	UpdateStatus(*v1alpha1.ClusterDomainsStatus) (*v1alpha1.ClusterDomainsStatus, error)
	Delete(name string, options *v1.DeleteOptions) error
	DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error
	Get(name string, options v1.GetOptions) (*v1alpha1.ClusterDomainsStatus, error)
	List(opts v1.ListOptions) (*v1alpha1.ClusterDomainsStatusList, error)
	Watch(opts v1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha1.ClusterDomainsStatus, err error)
	ClusterDomainsStatusExpansion
}

// clusterDomainsStatuses implements ClusterDomainsStatusInterface
type clusterDomainsStatuses struct {
	client rest.Interface
}

// newClusterDomainsStatuses returns a ClusterDomainsStatuses
func newClusterDomainsStatuses(c *StorkV1alpha1Client) *clusterDomainsStatuses {
	return &clusterDomainsStatuses{
		client: c.RESTClient(),
	}
}

// Get takes name of the clusterDomainsStatus, and returns the corresponding clusterDomainsStatus object, and an error if there is any.
func (c *clusterDomainsStatuses) Get(name string, options v1.GetOptions) (result *v1alpha1.ClusterDomainsStatus, err error) {
	result = &v1alpha1.ClusterDomainsStatus{}
	err = c.client.Get().
		Resource("clusterdomainsstatuses").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of ClusterDomainsStatuses that match those selectors.
func (c *clusterDomainsStatuses) List(opts v1.ListOptions) (result *v1alpha1.ClusterDomainsStatusList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1alpha1.ClusterDomainsStatusList{}
	err = c.client.Get().
		Resource("clusterdomainsstatuses").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do().
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested clusterDomainsStatuses.
func (c *clusterDomainsStatuses) Watch(opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Resource("clusterdomainsstatuses").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch()
}

// Create takes the representation of a clusterDomainsStatus and creates it.  Returns the server's representation of the clusterDomainsStatus, and an error, if there is any.
func (c *clusterDomainsStatuses) Create(clusterDomainsStatus *v1alpha1.ClusterDomainsStatus) (result *v1alpha1.ClusterDomainsStatus, err error) {
	result = &v1alpha1.ClusterDomainsStatus{}
	err = c.client.Post().
		Resource("clusterdomainsstatuses").
		Body(clusterDomainsStatus).
		Do().
		Into(result)
	return
}

// Update takes the representation of a clusterDomainsStatus and updates it. Returns the server's representation of the clusterDomainsStatus, and an error, if there is any.
func (c *clusterDomainsStatuses) Update(clusterDomainsStatus *v1alpha1.ClusterDomainsStatus) (result *v1alpha1.ClusterDomainsStatus, err error) {
	result = &v1alpha1.ClusterDomainsStatus{}
	err = c.client.Put().
		Resource("clusterdomainsstatuses").
		Name(clusterDomainsStatus.Name).
		Body(clusterDomainsStatus).
		Do().
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().

func (c *clusterDomainsStatuses) UpdateStatus(clusterDomainsStatus *v1alpha1.ClusterDomainsStatus) (result *v1alpha1.ClusterDomainsStatus, err error) {
	result = &v1alpha1.ClusterDomainsStatus{}
	err = c.client.Put().
		Resource("clusterdomainsstatuses").
		Name(clusterDomainsStatus.Name).
		SubResource("status").
		Body(clusterDomainsStatus).
		Do().
		Into(result)
	return
}

// Delete takes name of the clusterDomainsStatus and deletes it. Returns an error if one occurs.
func (c *clusterDomainsStatuses) Delete(name string, options *v1.DeleteOptions) error {
	return c.client.Delete().
		Resource("clusterdomainsstatuses").
		Name(name).
		Body(options).
		Do().
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *clusterDomainsStatuses) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	var timeout time.Duration
	if listOptions.TimeoutSeconds != nil {
		timeout = time.Duration(*listOptions.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Resource("clusterdomainsstatuses").
		VersionedParams(&listOptions, scheme.ParameterCodec).
		Timeout(timeout).
		Body(options).
		Do().
		Error()
}

// Patch applies the patch and returns the patched clusterDomainsStatus.
func (c *clusterDomainsStatuses) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha1.ClusterDomainsStatus, err error) {
	result = &v1alpha1.ClusterDomainsStatus{}
	err = c.client.Patch(pt).
		Resource("clusterdomainsstatuses").
		SubResource(subresources...).
		Name(name).
		Body(data).
		Do().
		Into(result)
	return
}
