/*
Copyright 2018 Openstorage.org

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	v1alpha1 "github.com/libopenstorage/stork/pkg/apis/stork/v1alpha1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeApplicationBackups implements ApplicationBackupInterface
type FakeApplicationBackups struct {
	Fake *FakeStorkV1alpha1
	ns   string
}

var applicationbackupsResource = schema.GroupVersionResource{Group: "stork.libopenstorage.org", Version: "v1alpha1", Resource: "applicationbackups"}

var applicationbackupsKind = schema.GroupVersionKind{Group: "stork.libopenstorage.org", Version: "v1alpha1", Kind: "ApplicationBackup"}

// Get takes name of the applicationBackup, and returns the corresponding applicationBackup object, and an error if there is any.
func (c *FakeApplicationBackups) Get(name string, options v1.GetOptions) (result *v1alpha1.ApplicationBackup, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(applicationbackupsResource, c.ns, name), &v1alpha1.ApplicationBackup{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.ApplicationBackup), err
}

// List takes label and field selectors, and returns the list of ApplicationBackups that match those selectors.
func (c *FakeApplicationBackups) List(opts v1.ListOptions) (result *v1alpha1.ApplicationBackupList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(applicationbackupsResource, applicationbackupsKind, c.ns, opts), &v1alpha1.ApplicationBackupList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1alpha1.ApplicationBackupList{ListMeta: obj.(*v1alpha1.ApplicationBackupList).ListMeta}
	for _, item := range obj.(*v1alpha1.ApplicationBackupList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested applicationBackups.
func (c *FakeApplicationBackups) Watch(opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(applicationbackupsResource, c.ns, opts))

}

// Create takes the representation of a applicationBackup and creates it.  Returns the server's representation of the applicationBackup, and an error, if there is any.
func (c *FakeApplicationBackups) Create(applicationBackup *v1alpha1.ApplicationBackup) (result *v1alpha1.ApplicationBackup, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(applicationbackupsResource, c.ns, applicationBackup), &v1alpha1.ApplicationBackup{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.ApplicationBackup), err
}

// Update takes the representation of a applicationBackup and updates it. Returns the server's representation of the applicationBackup, and an error, if there is any.
func (c *FakeApplicationBackups) Update(applicationBackup *v1alpha1.ApplicationBackup) (result *v1alpha1.ApplicationBackup, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(applicationbackupsResource, c.ns, applicationBackup), &v1alpha1.ApplicationBackup{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.ApplicationBackup), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeApplicationBackups) UpdateStatus(applicationBackup *v1alpha1.ApplicationBackup) (*v1alpha1.ApplicationBackup, error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateSubresourceAction(applicationbackupsResource, "status", c.ns, applicationBackup), &v1alpha1.ApplicationBackup{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.ApplicationBackup), err
}

// Delete takes name of the applicationBackup and deletes it. Returns an error if one occurs.
func (c *FakeApplicationBackups) Delete(name string, options *v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteAction(applicationbackupsResource, c.ns, name), &v1alpha1.ApplicationBackup{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeApplicationBackups) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(applicationbackupsResource, c.ns, listOptions)

	_, err := c.Fake.Invokes(action, &v1alpha1.ApplicationBackupList{})
	return err
}

// Patch applies the patch and returns the patched applicationBackup.
func (c *FakeApplicationBackups) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha1.ApplicationBackup, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(applicationbackupsResource, c.ns, name, pt, data, subresources...), &v1alpha1.ApplicationBackup{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.ApplicationBackup), err
}
