/*
Copyright 2018 Openstorage.org

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	v1alpha1 "github.com/libopenstorage/stork/pkg/apis/stork/v1alpha1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeApplicationClones implements ApplicationCloneInterface
type FakeApplicationClones struct {
	Fake *FakeStorkV1alpha1
	ns   string
}

var applicationclonesResource = schema.GroupVersionResource{Group: "stork.libopenstorage.org", Version: "v1alpha1", Resource: "applicationclones"}

var applicationclonesKind = schema.GroupVersionKind{Group: "stork.libopenstorage.org", Version: "v1alpha1", Kind: "ApplicationClone"}

// Get takes name of the applicationClone, and returns the corresponding applicationClone object, and an error if there is any.
func (c *FakeApplicationClones) Get(name string, options v1.GetOptions) (result *v1alpha1.ApplicationClone, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(applicationclonesResource, c.ns, name), &v1alpha1.ApplicationClone{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.ApplicationClone), err
}

// List takes label and field selectors, and returns the list of ApplicationClones that match those selectors.
func (c *FakeApplicationClones) List(opts v1.ListOptions) (result *v1alpha1.ApplicationCloneList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(applicationclonesResource, applicationclonesKind, c.ns, opts), &v1alpha1.ApplicationCloneList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1alpha1.ApplicationCloneList{ListMeta: obj.(*v1alpha1.ApplicationCloneList).ListMeta}
	for _, item := range obj.(*v1alpha1.ApplicationCloneList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested applicationClones.
func (c *FakeApplicationClones) Watch(opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(applicationclonesResource, c.ns, opts))

}

// Create takes the representation of a applicationClone and creates it.  Returns the server's representation of the applicationClone, and an error, if there is any.
func (c *FakeApplicationClones) Create(applicationClone *v1alpha1.ApplicationClone) (result *v1alpha1.ApplicationClone, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(applicationclonesResource, c.ns, applicationClone), &v1alpha1.ApplicationClone{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.ApplicationClone), err
}

// Update takes the representation of a applicationClone and updates it. Returns the server's representation of the applicationClone, and an error, if there is any.
func (c *FakeApplicationClones) Update(applicationClone *v1alpha1.ApplicationClone) (result *v1alpha1.ApplicationClone, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(applicationclonesResource, c.ns, applicationClone), &v1alpha1.ApplicationClone{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.ApplicationClone), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeApplicationClones) UpdateStatus(applicationClone *v1alpha1.ApplicationClone) (*v1alpha1.ApplicationClone, error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateSubresourceAction(applicationclonesResource, "status", c.ns, applicationClone), &v1alpha1.ApplicationClone{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.ApplicationClone), err
}

// Delete takes name of the applicationClone and deletes it. Returns an error if one occurs.
func (c *FakeApplicationClones) Delete(name string, options *v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteAction(applicationclonesResource, c.ns, name), &v1alpha1.ApplicationClone{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeApplicationClones) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(applicationclonesResource, c.ns, listOptions)

	_, err := c.Fake.Invokes(action, &v1alpha1.ApplicationCloneList{})
	return err
}

// Patch applies the patch and returns the patched applicationClone.
func (c *FakeApplicationClones) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha1.ApplicationClone, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(applicationclonesResource, c.ns, name, pt, data, subresources...), &v1alpha1.ApplicationClone{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.ApplicationClone), err
}
