/*
Copyright 2018 Openstorage.org

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	v1alpha1 "github.com/libopenstorage/stork/pkg/apis/stork/v1alpha1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeGroupVolumeSnapshots implements GroupVolumeSnapshotInterface
type FakeGroupVolumeSnapshots struct {
	Fake *FakeStorkV1alpha1
	ns   string
}

var groupvolumesnapshotsResource = schema.GroupVersionResource{Group: "stork.libopenstorage.org", Version: "v1alpha1", Resource: "groupvolumesnapshots"}

var groupvolumesnapshotsKind = schema.GroupVersionKind{Group: "stork.libopenstorage.org", Version: "v1alpha1", Kind: "GroupVolumeSnapshot"}

// Get takes name of the groupVolumeSnapshot, and returns the corresponding groupVolumeSnapshot object, and an error if there is any.
func (c *FakeGroupVolumeSnapshots) Get(name string, options v1.GetOptions) (result *v1alpha1.GroupVolumeSnapshot, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(groupvolumesnapshotsResource, c.ns, name), &v1alpha1.GroupVolumeSnapshot{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.GroupVolumeSnapshot), err
}

// List takes label and field selectors, and returns the list of GroupVolumeSnapshots that match those selectors.
func (c *FakeGroupVolumeSnapshots) List(opts v1.ListOptions) (result *v1alpha1.GroupVolumeSnapshotList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(groupvolumesnapshotsResource, groupvolumesnapshotsKind, c.ns, opts), &v1alpha1.GroupVolumeSnapshotList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1alpha1.GroupVolumeSnapshotList{ListMeta: obj.(*v1alpha1.GroupVolumeSnapshotList).ListMeta}
	for _, item := range obj.(*v1alpha1.GroupVolumeSnapshotList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested groupVolumeSnapshots.
func (c *FakeGroupVolumeSnapshots) Watch(opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(groupvolumesnapshotsResource, c.ns, opts))

}

// Create takes the representation of a groupVolumeSnapshot and creates it.  Returns the server's representation of the groupVolumeSnapshot, and an error, if there is any.
func (c *FakeGroupVolumeSnapshots) Create(groupVolumeSnapshot *v1alpha1.GroupVolumeSnapshot) (result *v1alpha1.GroupVolumeSnapshot, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(groupvolumesnapshotsResource, c.ns, groupVolumeSnapshot), &v1alpha1.GroupVolumeSnapshot{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.GroupVolumeSnapshot), err
}

// Update takes the representation of a groupVolumeSnapshot and updates it. Returns the server's representation of the groupVolumeSnapshot, and an error, if there is any.
func (c *FakeGroupVolumeSnapshots) Update(groupVolumeSnapshot *v1alpha1.GroupVolumeSnapshot) (result *v1alpha1.GroupVolumeSnapshot, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(groupvolumesnapshotsResource, c.ns, groupVolumeSnapshot), &v1alpha1.GroupVolumeSnapshot{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.GroupVolumeSnapshot), err
}

// Delete takes name of the groupVolumeSnapshot and deletes it. Returns an error if one occurs.
func (c *FakeGroupVolumeSnapshots) Delete(name string, options *v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteAction(groupvolumesnapshotsResource, c.ns, name), &v1alpha1.GroupVolumeSnapshot{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeGroupVolumeSnapshots) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(groupvolumesnapshotsResource, c.ns, listOptions)

	_, err := c.Fake.Invokes(action, &v1alpha1.GroupVolumeSnapshotList{})
	return err
}

// Patch applies the patch and returns the patched groupVolumeSnapshot.
func (c *FakeGroupVolumeSnapshots) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha1.GroupVolumeSnapshot, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(groupvolumesnapshotsResource, c.ns, name, pt, data, subresources...), &v1alpha1.GroupVolumeSnapshot{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.GroupVolumeSnapshot), err
}
