/*
Copyright 2019 Openstorage.org

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"time"

	v1alpha1 "github.com/libopenstorage/autopilot-api/pkg/apis/autopilot/v1alpha1"
	scheme "github.com/libopenstorage/autopilot-api/pkg/client/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// AutopilotRulesGetter has a method to return a AutopilotRuleInterface.
// A group's client should implement this interface.
type AutopilotRulesGetter interface {
	AutopilotRules() AutopilotRuleInterface
}

// AutopilotRuleInterface has methods to work with AutopilotRule resources.
type AutopilotRuleInterface interface {
	Create(*v1alpha1.AutopilotRule) (*v1alpha1.AutopilotRule, error)
	Update(*v1alpha1.AutopilotRule) (*v1alpha1.AutopilotRule, error)
	Delete(name string, options *v1.DeleteOptions) error
	DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error
	Get(name string, options v1.GetOptions) (*v1alpha1.AutopilotRule, error)
	List(opts v1.ListOptions) (*v1alpha1.AutopilotRuleList, error)
	Watch(opts v1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha1.AutopilotRule, err error)
	AutopilotRuleExpansion
}

// autopilotRules implements AutopilotRuleInterface
type autopilotRules struct {
	client rest.Interface
}

// newAutopilotRules returns a AutopilotRules
func newAutopilotRules(c *AutopilotV1alpha1Client) *autopilotRules {
	return &autopilotRules{
		client: c.RESTClient(),
	}
}

// Get takes name of the autopilotRule, and returns the corresponding autopilotRule object, and an error if there is any.
func (c *autopilotRules) Get(name string, options v1.GetOptions) (result *v1alpha1.AutopilotRule, err error) {
	result = &v1alpha1.AutopilotRule{}
	err = c.client.Get().
		Resource("autopilotrules").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of AutopilotRules that match those selectors.
func (c *autopilotRules) List(opts v1.ListOptions) (result *v1alpha1.AutopilotRuleList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1alpha1.AutopilotRuleList{}
	err = c.client.Get().
		Resource("autopilotrules").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do().
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested autopilotRules.
func (c *autopilotRules) Watch(opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Resource("autopilotrules").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch()
}

// Create takes the representation of a autopilotRule and creates it.  Returns the server's representation of the autopilotRule, and an error, if there is any.
func (c *autopilotRules) Create(autopilotRule *v1alpha1.AutopilotRule) (result *v1alpha1.AutopilotRule, err error) {
	result = &v1alpha1.AutopilotRule{}
	err = c.client.Post().
		Resource("autopilotrules").
		Body(autopilotRule).
		Do().
		Into(result)
	return
}

// Update takes the representation of a autopilotRule and updates it. Returns the server's representation of the autopilotRule, and an error, if there is any.
func (c *autopilotRules) Update(autopilotRule *v1alpha1.AutopilotRule) (result *v1alpha1.AutopilotRule, err error) {
	result = &v1alpha1.AutopilotRule{}
	err = c.client.Put().
		Resource("autopilotrules").
		Name(autopilotRule.Name).
		Body(autopilotRule).
		Do().
		Into(result)
	return
}

// Delete takes name of the autopilotRule and deletes it. Returns an error if one occurs.
func (c *autopilotRules) Delete(name string, options *v1.DeleteOptions) error {
	return c.client.Delete().
		Resource("autopilotrules").
		Name(name).
		Body(options).
		Do().
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *autopilotRules) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	var timeout time.Duration
	if listOptions.TimeoutSeconds != nil {
		timeout = time.Duration(*listOptions.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Resource("autopilotrules").
		VersionedParams(&listOptions, scheme.ParameterCodec).
		Timeout(timeout).
		Body(options).
		Do().
		Error()
}

// Patch applies the patch and returns the patched autopilotRule.
func (c *autopilotRules) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha1.AutopilotRule, err error) {
	result = &v1alpha1.AutopilotRule{}
	err = c.client.Patch(pt).
		Resource("autopilotrules").
		SubResource(subresources...).
		Name(name).
		Body(data).
		Do().
		Into(result)
	return
}
