/*
Copyright 2019 Red Hat Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"

	v1alpha1 "github.com/kube-object-storage/lib-bucket-provisioner/pkg/apis/objectbucket.io/v1alpha1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeObjectBuckets implements ObjectBucketInterface
type FakeObjectBuckets struct {
	Fake *FakeObjectbucketV1alpha1
}

var objectbucketsResource = schema.GroupVersionResource{Group: "objectbucket.io", Version: "v1alpha1", Resource: "objectbuckets"}

var objectbucketsKind = schema.GroupVersionKind{Group: "objectbucket.io", Version: "v1alpha1", Kind: "ObjectBucket"}

// Get takes name of the objectBucket, and returns the corresponding objectBucket object, and an error if there is any.
func (c *FakeObjectBuckets) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha1.ObjectBucket, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootGetAction(objectbucketsResource, name), &v1alpha1.ObjectBucket{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.ObjectBucket), err
}

// List takes label and field selectors, and returns the list of ObjectBuckets that match those selectors.
func (c *FakeObjectBuckets) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha1.ObjectBucketList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootListAction(objectbucketsResource, objectbucketsKind, opts), &v1alpha1.ObjectBucketList{})
	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1alpha1.ObjectBucketList{ListMeta: obj.(*v1alpha1.ObjectBucketList).ListMeta}
	for _, item := range obj.(*v1alpha1.ObjectBucketList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested objectBuckets.
func (c *FakeObjectBuckets) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewRootWatchAction(objectbucketsResource, opts))
}

// Create takes the representation of a objectBucket and creates it.  Returns the server's representation of the objectBucket, and an error, if there is any.
func (c *FakeObjectBuckets) Create(ctx context.Context, objectBucket *v1alpha1.ObjectBucket, opts v1.CreateOptions) (result *v1alpha1.ObjectBucket, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootCreateAction(objectbucketsResource, objectBucket), &v1alpha1.ObjectBucket{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.ObjectBucket), err
}

// Update takes the representation of a objectBucket and updates it. Returns the server's representation of the objectBucket, and an error, if there is any.
func (c *FakeObjectBuckets) Update(ctx context.Context, objectBucket *v1alpha1.ObjectBucket, opts v1.UpdateOptions) (result *v1alpha1.ObjectBucket, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootUpdateAction(objectbucketsResource, objectBucket), &v1alpha1.ObjectBucket{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.ObjectBucket), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeObjectBuckets) UpdateStatus(ctx context.Context, objectBucket *v1alpha1.ObjectBucket, opts v1.UpdateOptions) (*v1alpha1.ObjectBucket, error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootUpdateSubresourceAction(objectbucketsResource, "status", objectBucket), &v1alpha1.ObjectBucket{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.ObjectBucket), err
}

// Delete takes name of the objectBucket and deletes it. Returns an error if one occurs.
func (c *FakeObjectBuckets) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewRootDeleteAction(objectbucketsResource, name), &v1alpha1.ObjectBucket{})
	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeObjectBuckets) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	action := testing.NewRootDeleteCollectionAction(objectbucketsResource, listOpts)

	_, err := c.Fake.Invokes(action, &v1alpha1.ObjectBucketList{})
	return err
}

// Patch applies the patch and returns the patched objectBucket.
func (c *FakeObjectBuckets) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.ObjectBucket, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootPatchSubresourceAction(objectbucketsResource, name, pt, data, subresources...), &v1alpha1.ObjectBucket{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.ObjectBucket), err
}
