// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0
// 	protoc        v3.13.0
// source: google/actions/sdk/v2/actions_sdk.proto

package sdk

import (
	context "context"
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Streaming RPC request for WritePreview.
type WritePreviewRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource name in the format `projects/{project}`. The
	// `{project}` is the cloud project ID associated with the project.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Data source used to created the preview.
	//
	// Types that are assignable to Source:
	//	*WritePreviewRequest_Files
	//	*WritePreviewRequest_Draft
	//	*WritePreviewRequest_SubmittedVersion
	Source isWritePreviewRequest_Source `protobuf_oneof:"source"`
	// Required. The settings for updating the user's preview.
	PreviewSettings *WritePreviewRequest_PreviewSettings `protobuf:"bytes,4,opt,name=preview_settings,json=previewSettings,proto3" json:"preview_settings,omitempty"`
}

func (x *WritePreviewRequest) Reset() {
	*x = WritePreviewRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_actions_sdk_v2_actions_sdk_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WritePreviewRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WritePreviewRequest) ProtoMessage() {}

func (x *WritePreviewRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_actions_sdk_v2_actions_sdk_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WritePreviewRequest.ProtoReflect.Descriptor instead.
func (*WritePreviewRequest) Descriptor() ([]byte, []int) {
	return file_google_actions_sdk_v2_actions_sdk_proto_rawDescGZIP(), []int{0}
}

func (x *WritePreviewRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (m *WritePreviewRequest) GetSource() isWritePreviewRequest_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *WritePreviewRequest) GetFiles() *Files {
	if x, ok := x.GetSource().(*WritePreviewRequest_Files); ok {
		return x.Files
	}
	return nil
}

func (x *WritePreviewRequest) GetDraft() *WritePreviewRequest_ContentFromDraft {
	if x, ok := x.GetSource().(*WritePreviewRequest_Draft); ok {
		return x.Draft
	}
	return nil
}

func (x *WritePreviewRequest) GetSubmittedVersion() *WritePreviewRequest_ContentFromSubmittedVersion {
	if x, ok := x.GetSource().(*WritePreviewRequest_SubmittedVersion); ok {
		return x.SubmittedVersion
	}
	return nil
}

func (x *WritePreviewRequest) GetPreviewSettings() *WritePreviewRequest_PreviewSettings {
	if x != nil {
		return x.PreviewSettings
	}
	return nil
}

type isWritePreviewRequest_Source interface {
	isWritePreviewRequest_Source()
}

type WritePreviewRequest_Files struct {
	// List of files sent to the server at a time. This is a list of config
	// files or data files.
	// 1. The first request must be a ConfigFiles.
	// 2. The first request must have a ConfigFile with 'settings'.
	// 3. The first request must have a ConfigFile with 'manifest'.
	Files *Files `protobuf:"bytes,5,opt,name=files,proto3,oneof"`
}

type WritePreviewRequest_Draft struct {
	// Content sourced from the project draft.
	Draft *WritePreviewRequest_ContentFromDraft `protobuf:"bytes,6,opt,name=draft,proto3,oneof"`
}

type WritePreviewRequest_SubmittedVersion struct {
	// Content sourced from the an exiting version.
	SubmittedVersion *WritePreviewRequest_ContentFromSubmittedVersion `protobuf:"bytes,7,opt,name=submitted_version,json=submittedVersion,proto3,oneof"`
}

func (*WritePreviewRequest_Files) isWritePreviewRequest_Source() {}

func (*WritePreviewRequest_Draft) isWritePreviewRequest_Source() {}

func (*WritePreviewRequest_SubmittedVersion) isWritePreviewRequest_Source() {}

// Definition of preview resource.
type Preview struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique identifier of the preview.
	// Format: `projects/{project}/preview`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Validation results associated with the user project preview content.
	ValidationResults *ValidationResults `protobuf:"bytes,2,opt,name=validation_results,json=validationResults,proto3" json:"validation_results,omitempty"`
	// The simulator URL to test the user preview.
	SimulatorUrl string `protobuf:"bytes,3,opt,name=simulator_url,json=simulatorUrl,proto3" json:"simulator_url,omitempty"`
}

func (x *Preview) Reset() {
	*x = Preview{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_actions_sdk_v2_actions_sdk_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Preview) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Preview) ProtoMessage() {}

func (x *Preview) ProtoReflect() protoreflect.Message {
	mi := &file_google_actions_sdk_v2_actions_sdk_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Preview.ProtoReflect.Descriptor instead.
func (*Preview) Descriptor() ([]byte, []int) {
	return file_google_actions_sdk_v2_actions_sdk_proto_rawDescGZIP(), []int{1}
}

func (x *Preview) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Preview) GetValidationResults() *ValidationResults {
	if x != nil {
		return x.ValidationResults
	}
	return nil
}

func (x *Preview) GetSimulatorUrl() string {
	if x != nil {
		return x.SimulatorUrl
	}
	return ""
}

// Indicates the preview content will be coming from the Draft.
type WritePreviewRequest_ContentFromDraft struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *WritePreviewRequest_ContentFromDraft) Reset() {
	*x = WritePreviewRequest_ContentFromDraft{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_actions_sdk_v2_actions_sdk_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WritePreviewRequest_ContentFromDraft) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WritePreviewRequest_ContentFromDraft) ProtoMessage() {}

func (x *WritePreviewRequest_ContentFromDraft) ProtoReflect() protoreflect.Message {
	mi := &file_google_actions_sdk_v2_actions_sdk_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WritePreviewRequest_ContentFromDraft.ProtoReflect.Descriptor instead.
func (*WritePreviewRequest_ContentFromDraft) Descriptor() ([]byte, []int) {
	return file_google_actions_sdk_v2_actions_sdk_proto_rawDescGZIP(), []int{0, 0}
}

// Indicates the preview content will be coming from an exiting version.
type WritePreviewRequest_ContentFromSubmittedVersion struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Submitted version of the project to be used to create a preview.
	// Format: `projects/{project}/versions/{version}`
	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *WritePreviewRequest_ContentFromSubmittedVersion) Reset() {
	*x = WritePreviewRequest_ContentFromSubmittedVersion{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_actions_sdk_v2_actions_sdk_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WritePreviewRequest_ContentFromSubmittedVersion) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WritePreviewRequest_ContentFromSubmittedVersion) ProtoMessage() {}

func (x *WritePreviewRequest_ContentFromSubmittedVersion) ProtoReflect() protoreflect.Message {
	mi := &file_google_actions_sdk_v2_actions_sdk_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WritePreviewRequest_ContentFromSubmittedVersion.ProtoReflect.Descriptor instead.
func (*WritePreviewRequest_ContentFromSubmittedVersion) Descriptor() ([]byte, []int) {
	return file_google_actions_sdk_v2_actions_sdk_proto_rawDescGZIP(), []int{0, 1}
}

func (x *WritePreviewRequest_ContentFromSubmittedVersion) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

// Settings for updating the preview.
type WritePreviewRequest_PreviewSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Indicates whether or not to run certain operations, such as transactions,
	// in sandbox mode. By default, preview requests run these operations in
	// sandbox mode. In other words, the default value for `sandbox` is `true`.
	Sandbox *wrapperspb.BoolValue `protobuf:"bytes,1,opt,name=sandbox,proto3" json:"sandbox,omitempty"`
}

func (x *WritePreviewRequest_PreviewSettings) Reset() {
	*x = WritePreviewRequest_PreviewSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_actions_sdk_v2_actions_sdk_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WritePreviewRequest_PreviewSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WritePreviewRequest_PreviewSettings) ProtoMessage() {}

func (x *WritePreviewRequest_PreviewSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_actions_sdk_v2_actions_sdk_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WritePreviewRequest_PreviewSettings.ProtoReflect.Descriptor instead.
func (*WritePreviewRequest_PreviewSettings) Descriptor() ([]byte, []int) {
	return file_google_actions_sdk_v2_actions_sdk_proto_rawDescGZIP(), []int{0, 2}
}

func (x *WritePreviewRequest_PreviewSettings) GetSandbox() *wrapperspb.BoolValue {
	if x != nil {
		return x.Sandbox
	}
	return nil
}

var File_google_actions_sdk_v2_actions_sdk_proto protoreflect.FileDescriptor

var file_google_actions_sdk_v2_actions_sdk_proto_rawDesc = []byte{
	0x0a, 0x27, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x73, 0x64, 0x6b, 0x2f, 0x76, 0x32, 0x2f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x5f,
	0x73, 0x64, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x76, 0x32,
	0x1a, 0x32, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x73, 0x64, 0x6b, 0x2f, 0x76, 0x32, 0x2f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f,
	0x6c, 0x69, 0x6e, 0x6b, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x21, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x73, 0x64, 0x6b, 0x2f, 0x76, 0x32, 0x2f, 0x66, 0x69, 0x6c, 0x65,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x73, 0x64, 0x6b, 0x2f, 0x76, 0x32, 0x2f, 0x76,
	0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64,
	0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x77, 0x72, 0x61, 0x70,
	0x70, 0x65, 0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x8b, 0x05, 0x0a, 0x13, 0x57,
	0x72, 0x69, 0x74, 0x65, 0x50, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x3e, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20, 0x12, 0x1e, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x34, 0x0a, 0x05, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x48,
	0x00, 0x52, 0x05, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x12, 0x53, 0x0a, 0x05, 0x64, 0x72, 0x61, 0x66,
	0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x76, 0x32, 0x2e,
	0x57, 0x72, 0x69, 0x74, 0x65, 0x50, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x46, 0x72, 0x6f, 0x6d, 0x44,
	0x72, 0x61, 0x66, 0x74, 0x48, 0x00, 0x52, 0x05, 0x64, 0x72, 0x61, 0x66, 0x74, 0x12, 0x75, 0x0a,
	0x11, 0x73, 0x75, 0x62, 0x6d, 0x69, 0x74, 0x74, 0x65, 0x64, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x76, 0x32,
	0x2e, 0x57, 0x72, 0x69, 0x74, 0x65, 0x50, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x46, 0x72, 0x6f, 0x6d,
	0x53, 0x75, 0x62, 0x6d, 0x69, 0x74, 0x74, 0x65, 0x64, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x48, 0x00, 0x52, 0x10, 0x73, 0x75, 0x62, 0x6d, 0x69, 0x74, 0x74, 0x65, 0x64, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x12, 0x6a, 0x0a, 0x10, 0x70, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x5f,
	0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x73, 0x64, 0x6b, 0x2e, 0x76, 0x32, 0x2e, 0x57, 0x72, 0x69, 0x74, 0x65, 0x50, 0x72, 0x65, 0x76,
	0x69, 0x65, 0x77, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x50, 0x72, 0x65, 0x76, 0x69,
	0x65, 0x77, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x0f, 0x70, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x1a, 0x12, 0x0a, 0x10, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x46, 0x72, 0x6f, 0x6d, 0x44,
	0x72, 0x61, 0x66, 0x74, 0x1a, 0x5f, 0x0a, 0x1b, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x46,
	0x72, 0x6f, 0x6d, 0x53, 0x75, 0x62, 0x6d, 0x69, 0x74, 0x74, 0x65, 0x64, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x12, 0x40, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x1a, 0x47, 0x0a, 0x0f, 0x50, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x34, 0x0a, 0x07, 0x73, 0x61, 0x6e, 0x64,
	0x62, 0x6f, 0x78, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x07, 0x73, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x42, 0x08,
	0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0xe7, 0x01, 0x0a, 0x07, 0x50, 0x72, 0x65,
	0x76, 0x69, 0x65, 0x77, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x57, 0x0a, 0x12, 0x76, 0x61, 0x6c, 0x69,
	0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x76, 0x32, 0x2e, 0x56, 0x61, 0x6c,
	0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x52, 0x11,
	0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x73, 0x12, 0x23, 0x0a, 0x0d, 0x73, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x6f, 0x72, 0x5f, 0x75,
	0x72, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x73, 0x69, 0x6d, 0x75, 0x6c, 0x61,
	0x74, 0x6f, 0x72, 0x55, 0x72, 0x6c, 0x3a, 0x4a, 0xea, 0x41, 0x47, 0x0a, 0x1e, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x12, 0x25, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f,
	0x70, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x65, 0x76, 0x69, 0x65,
	0x77, 0x7d, 0x32, 0xb8, 0x01, 0x0a, 0x0a, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x53, 0x64,
	0x6b, 0x12, 0x8e, 0x01, 0x0a, 0x0c, 0x57, 0x72, 0x69, 0x74, 0x65, 0x50, 0x72, 0x65, 0x76, 0x69,
	0x65, 0x77, 0x12, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x76, 0x32, 0x2e, 0x57, 0x72, 0x69, 0x74, 0x65,
	0x50, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x73, 0x64, 0x6b, 0x2e, 0x76, 0x32, 0x2e, 0x50, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x22, 0x30,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2a, 0x22, 0x25, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x70, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x3a, 0x77, 0x72, 0x69, 0x74, 0x65, 0x3a, 0x01, 0x2a,
	0x28, 0x01, 0x1a, 0x19, 0xca, 0x41, 0x16, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x42, 0x68, 0x0a,
	0x19, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x76, 0x32, 0x42, 0x0f, 0x41, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x53, 0x64, 0x6b, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x38, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67,
	0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x73, 0x64, 0x6b,
	0x2f, 0x76, 0x32, 0x3b, 0x73, 0x64, 0x6b, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_actions_sdk_v2_actions_sdk_proto_rawDescOnce sync.Once
	file_google_actions_sdk_v2_actions_sdk_proto_rawDescData = file_google_actions_sdk_v2_actions_sdk_proto_rawDesc
)

func file_google_actions_sdk_v2_actions_sdk_proto_rawDescGZIP() []byte {
	file_google_actions_sdk_v2_actions_sdk_proto_rawDescOnce.Do(func() {
		file_google_actions_sdk_v2_actions_sdk_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_actions_sdk_v2_actions_sdk_proto_rawDescData)
	})
	return file_google_actions_sdk_v2_actions_sdk_proto_rawDescData
}

var file_google_actions_sdk_v2_actions_sdk_proto_msgTypes = make([]protoimpl.MessageInfo, 5)
var file_google_actions_sdk_v2_actions_sdk_proto_goTypes = []interface{}{
	(*WritePreviewRequest)(nil),                             // 0: google.actions.sdk.v2.WritePreviewRequest
	(*Preview)(nil),                                         // 1: google.actions.sdk.v2.Preview
	(*WritePreviewRequest_ContentFromDraft)(nil),            // 2: google.actions.sdk.v2.WritePreviewRequest.ContentFromDraft
	(*WritePreviewRequest_ContentFromSubmittedVersion)(nil), // 3: google.actions.sdk.v2.WritePreviewRequest.ContentFromSubmittedVersion
	(*WritePreviewRequest_PreviewSettings)(nil),             // 4: google.actions.sdk.v2.WritePreviewRequest.PreviewSettings
	(*Files)(nil),                // 5: google.actions.sdk.v2.Files
	(*ValidationResults)(nil),    // 6: google.actions.sdk.v2.ValidationResults
	(*wrapperspb.BoolValue)(nil), // 7: google.protobuf.BoolValue
}
var file_google_actions_sdk_v2_actions_sdk_proto_depIdxs = []int32{
	5, // 0: google.actions.sdk.v2.WritePreviewRequest.files:type_name -> google.actions.sdk.v2.Files
	2, // 1: google.actions.sdk.v2.WritePreviewRequest.draft:type_name -> google.actions.sdk.v2.WritePreviewRequest.ContentFromDraft
	3, // 2: google.actions.sdk.v2.WritePreviewRequest.submitted_version:type_name -> google.actions.sdk.v2.WritePreviewRequest.ContentFromSubmittedVersion
	4, // 3: google.actions.sdk.v2.WritePreviewRequest.preview_settings:type_name -> google.actions.sdk.v2.WritePreviewRequest.PreviewSettings
	6, // 4: google.actions.sdk.v2.Preview.validation_results:type_name -> google.actions.sdk.v2.ValidationResults
	7, // 5: google.actions.sdk.v2.WritePreviewRequest.PreviewSettings.sandbox:type_name -> google.protobuf.BoolValue
	0, // 6: google.actions.sdk.v2.ActionsSdk.WritePreview:input_type -> google.actions.sdk.v2.WritePreviewRequest
	1, // 7: google.actions.sdk.v2.ActionsSdk.WritePreview:output_type -> google.actions.sdk.v2.Preview
	7, // [7:8] is the sub-list for method output_type
	6, // [6:7] is the sub-list for method input_type
	6, // [6:6] is the sub-list for extension type_name
	6, // [6:6] is the sub-list for extension extendee
	0, // [0:6] is the sub-list for field type_name
}

func init() { file_google_actions_sdk_v2_actions_sdk_proto_init() }
func file_google_actions_sdk_v2_actions_sdk_proto_init() {
	if File_google_actions_sdk_v2_actions_sdk_proto != nil {
		return
	}
	file_google_actions_sdk_v2_account_linking_secret_proto_init()
	file_google_actions_sdk_v2_files_proto_init()
	file_google_actions_sdk_v2_validation_results_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_actions_sdk_v2_actions_sdk_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WritePreviewRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_actions_sdk_v2_actions_sdk_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Preview); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_actions_sdk_v2_actions_sdk_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WritePreviewRequest_ContentFromDraft); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_actions_sdk_v2_actions_sdk_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WritePreviewRequest_ContentFromSubmittedVersion); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_actions_sdk_v2_actions_sdk_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WritePreviewRequest_PreviewSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_actions_sdk_v2_actions_sdk_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*WritePreviewRequest_Files)(nil),
		(*WritePreviewRequest_Draft)(nil),
		(*WritePreviewRequest_SubmittedVersion)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_actions_sdk_v2_actions_sdk_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   5,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_actions_sdk_v2_actions_sdk_proto_goTypes,
		DependencyIndexes: file_google_actions_sdk_v2_actions_sdk_proto_depIdxs,
		MessageInfos:      file_google_actions_sdk_v2_actions_sdk_proto_msgTypes,
	}.Build()
	File_google_actions_sdk_v2_actions_sdk_proto = out.File
	file_google_actions_sdk_v2_actions_sdk_proto_rawDesc = nil
	file_google_actions_sdk_v2_actions_sdk_proto_goTypes = nil
	file_google_actions_sdk_v2_actions_sdk_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ActionsSdkClient is the client API for ActionsSdk service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ActionsSdkClient interface {
	// Updates the user's project preview based on the model.
	WritePreview(ctx context.Context, opts ...grpc.CallOption) (ActionsSdk_WritePreviewClient, error)
}

type actionsSdkClient struct {
	cc grpc.ClientConnInterface
}

func NewActionsSdkClient(cc grpc.ClientConnInterface) ActionsSdkClient {
	return &actionsSdkClient{cc}
}

func (c *actionsSdkClient) WritePreview(ctx context.Context, opts ...grpc.CallOption) (ActionsSdk_WritePreviewClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ActionsSdk_serviceDesc.Streams[0], "/google.actions.sdk.v2.ActionsSdk/WritePreview", opts...)
	if err != nil {
		return nil, err
	}
	x := &actionsSdkWritePreviewClient{stream}
	return x, nil
}

type ActionsSdk_WritePreviewClient interface {
	Send(*WritePreviewRequest) error
	CloseAndRecv() (*Preview, error)
	grpc.ClientStream
}

type actionsSdkWritePreviewClient struct {
	grpc.ClientStream
}

func (x *actionsSdkWritePreviewClient) Send(m *WritePreviewRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *actionsSdkWritePreviewClient) CloseAndRecv() (*Preview, error) {
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	m := new(Preview)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// ActionsSdkServer is the server API for ActionsSdk service.
type ActionsSdkServer interface {
	// Updates the user's project preview based on the model.
	WritePreview(ActionsSdk_WritePreviewServer) error
}

// UnimplementedActionsSdkServer can be embedded to have forward compatible implementations.
type UnimplementedActionsSdkServer struct {
}

func (*UnimplementedActionsSdkServer) WritePreview(ActionsSdk_WritePreviewServer) error {
	return status.Errorf(codes.Unimplemented, "method WritePreview not implemented")
}

func RegisterActionsSdkServer(s *grpc.Server, srv ActionsSdkServer) {
	s.RegisterService(&_ActionsSdk_serviceDesc, srv)
}

func _ActionsSdk_WritePreview_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(ActionsSdkServer).WritePreview(&actionsSdkWritePreviewServer{stream})
}

type ActionsSdk_WritePreviewServer interface {
	SendAndClose(*Preview) error
	Recv() (*WritePreviewRequest, error)
	grpc.ServerStream
}

type actionsSdkWritePreviewServer struct {
	grpc.ServerStream
}

func (x *actionsSdkWritePreviewServer) SendAndClose(m *Preview) error {
	return x.ServerStream.SendMsg(m)
}

func (x *actionsSdkWritePreviewServer) Recv() (*WritePreviewRequest, error) {
	m := new(WritePreviewRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

var _ActionsSdk_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.actions.sdk.v2.ActionsSdk",
	HandlerType: (*ActionsSdkServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "WritePreview",
			Handler:       _ActionsSdk_WritePreview_Handler,
			ClientStreams: true,
		},
	},
	Metadata: "google/actions/sdk/v2/actions_sdk.proto",
}
