// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: rules/rulespb/rpc.proto

package rulespb

import (
	context "context"
	encoding_binary "encoding/binary"
	fmt "fmt"

	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	github_com_gogo_protobuf_types "github.com/gogo/protobuf/types"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"

	io "io"
	math "math"
	math_bits "math/bits"
	time "time"

	labelpb "github.com/thanos-io/thanos/pkg/store/labelpb"
	storepb "github.com/thanos-io/thanos/pkg/store/storepb"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf
var _ = time.Kitchen

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

/// AlertState represents state of the alert. Has to match 1:1 Prometheus AlertState:
//
// StateInactive is the state of an alert that is neither firing nor pending.
//StateInactive AlertState = iota
// StatePending is the state of an alert that has been active for less than
// the configured threshold duration.
//StatePending
// StateFiring is the state of an alert that has been active for longer than
// the configured threshold duration.
//StateFiring
type AlertState int32

const (
	AlertState_INACTIVE AlertState = 0
	AlertState_PENDING  AlertState = 1
	AlertState_FIRING   AlertState = 2
)

var AlertState_name = map[int32]string{
	0: "INACTIVE",
	1: "PENDING",
	2: "FIRING",
}

var AlertState_value = map[string]int32{
	"INACTIVE": 0,
	"PENDING":  1,
	"FIRING":   2,
}

func (x AlertState) String() string {
	return proto.EnumName(AlertState_name, int32(x))
}

func (AlertState) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_91b1d28f30eb5efb, []int{0}
}

type RulesRequest_Type int32

const (
	RulesRequest_ALL RulesRequest_Type = 0
	/// This will make sure strings.ToLower(.String()) will match 'alert' and 'record' values for
	/// Prometheus HTTP API.
	/// NOTE: The implementation has to return empty rule groups as well.
	RulesRequest_ALERT  RulesRequest_Type = 1
	RulesRequest_RECORD RulesRequest_Type = 2
)

var RulesRequest_Type_name = map[int32]string{
	0: "ALL",
	1: "ALERT",
	2: "RECORD",
}

var RulesRequest_Type_value = map[string]int32{
	"ALL":    0,
	"ALERT":  1,
	"RECORD": 2,
}

func (x RulesRequest_Type) String() string {
	return proto.EnumName(RulesRequest_Type_name, int32(x))
}

func (RulesRequest_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_91b1d28f30eb5efb, []int{0, 0}
}

type RulesRequest struct {
	Type                    RulesRequest_Type               `protobuf:"varint,1,opt,name=type,proto3,enum=thanos.RulesRequest_Type" json:"type,omitempty"`
	PartialResponseStrategy storepb.PartialResponseStrategy `protobuf:"varint,2,opt,name=partial_response_strategy,json=partialResponseStrategy,proto3,enum=thanos.PartialResponseStrategy" json:"partial_response_strategy,omitempty"`
}

func (m *RulesRequest) Reset()         { *m = RulesRequest{} }
func (m *RulesRequest) String() string { return proto.CompactTextString(m) }
func (*RulesRequest) ProtoMessage()    {}
func (*RulesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_91b1d28f30eb5efb, []int{0}
}
func (m *RulesRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RulesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RulesRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RulesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RulesRequest.Merge(m, src)
}
func (m *RulesRequest) XXX_Size() int {
	return m.Size()
}
func (m *RulesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RulesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RulesRequest proto.InternalMessageInfo

type RulesResponse struct {
	// Types that are valid to be assigned to Result:
	//	*RulesResponse_Group
	//	*RulesResponse_Warning
	Result isRulesResponse_Result `protobuf_oneof:"result"`
}

func (m *RulesResponse) Reset()         { *m = RulesResponse{} }
func (m *RulesResponse) String() string { return proto.CompactTextString(m) }
func (*RulesResponse) ProtoMessage()    {}
func (*RulesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_91b1d28f30eb5efb, []int{1}
}
func (m *RulesResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RulesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RulesResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RulesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RulesResponse.Merge(m, src)
}
func (m *RulesResponse) XXX_Size() int {
	return m.Size()
}
func (m *RulesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_RulesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_RulesResponse proto.InternalMessageInfo

type isRulesResponse_Result interface {
	isRulesResponse_Result()
	MarshalTo([]byte) (int, error)
	Size() int
}

type RulesResponse_Group struct {
	Group *RuleGroup `protobuf:"bytes,1,opt,name=group,proto3,oneof" json:"group,omitempty"`
}
type RulesResponse_Warning struct {
	Warning string `protobuf:"bytes,2,opt,name=warning,proto3,oneof" json:"warning,omitempty"`
}

func (*RulesResponse_Group) isRulesResponse_Result()   {}
func (*RulesResponse_Warning) isRulesResponse_Result() {}

func (m *RulesResponse) GetResult() isRulesResponse_Result {
	if m != nil {
		return m.Result
	}
	return nil
}

func (m *RulesResponse) GetGroup() *RuleGroup {
	if x, ok := m.GetResult().(*RulesResponse_Group); ok {
		return x.Group
	}
	return nil
}

func (m *RulesResponse) GetWarning() string {
	if x, ok := m.GetResult().(*RulesResponse_Warning); ok {
		return x.Warning
	}
	return ""
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*RulesResponse) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*RulesResponse_Group)(nil),
		(*RulesResponse_Warning)(nil),
	}
}

/// RuleGroups is set of rule groups.
/// This and below APIs are meant to be used for unmarshaling and marshsaling rules from/to Prometheus API.
/// That's why json tag has to be customized and matching https://github.com/prometheus/prometheus/blob/c530b4b456cc5f9ec249f771dff187eb7715dc9b/web/api/v1/api.go#L955
/// NOTE: See rules_custom_test.go for compatibility tests.
///
/// For rule parsing from YAML configuration other struct is used: https://github.com/prometheus/prometheus/blob/20b1f596f6fb16107ef0c244d240b0ad6da36829/pkg/rulefmt/rulefmt.go#L105
type RuleGroups struct {
	Groups []*RuleGroup `protobuf:"bytes,1,rep,name=groups,proto3" json:"groups"`
}

func (m *RuleGroups) Reset()         { *m = RuleGroups{} }
func (m *RuleGroups) String() string { return proto.CompactTextString(m) }
func (*RuleGroups) ProtoMessage()    {}
func (*RuleGroups) Descriptor() ([]byte, []int) {
	return fileDescriptor_91b1d28f30eb5efb, []int{2}
}
func (m *RuleGroups) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RuleGroups) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RuleGroups.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RuleGroups) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RuleGroups.Merge(m, src)
}
func (m *RuleGroups) XXX_Size() int {
	return m.Size()
}
func (m *RuleGroups) XXX_DiscardUnknown() {
	xxx_messageInfo_RuleGroups.DiscardUnknown(m)
}

var xxx_messageInfo_RuleGroups proto.InternalMessageInfo

/// RuleGroup has info for rules which are part of a group.
type RuleGroup struct {
	Name                      string    `protobuf:"bytes,1,opt,name=name,proto3" json:"name"`
	File                      string    `protobuf:"bytes,2,opt,name=file,proto3" json:"file"`
	Rules                     []*Rule   `protobuf:"bytes,3,rep,name=rules,proto3" json:"rules"`
	Interval                  float64   `protobuf:"fixed64,4,opt,name=interval,proto3" json:"interval"`
	EvaluationDurationSeconds float64   `protobuf:"fixed64,5,opt,name=evaluation_duration_seconds,json=evaluationDurationSeconds,proto3" json:"evaluationTime"`
	LastEvaluation            time.Time `protobuf:"bytes,6,opt,name=last_evaluation,json=lastEvaluation,proto3,stdtime" json:"lastEvaluation"`
	// Thanos specific.
	PartialResponseStrategy storepb.PartialResponseStrategy `protobuf:"varint,8,opt,name=PartialResponseStrategy,proto3,enum=thanos.PartialResponseStrategy" json:"partialResponseStrategy"`
}

func (m *RuleGroup) Reset()         { *m = RuleGroup{} }
func (m *RuleGroup) String() string { return proto.CompactTextString(m) }
func (*RuleGroup) ProtoMessage()    {}
func (*RuleGroup) Descriptor() ([]byte, []int) {
	return fileDescriptor_91b1d28f30eb5efb, []int{3}
}
func (m *RuleGroup) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RuleGroup) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RuleGroup.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RuleGroup) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RuleGroup.Merge(m, src)
}
func (m *RuleGroup) XXX_Size() int {
	return m.Size()
}
func (m *RuleGroup) XXX_DiscardUnknown() {
	xxx_messageInfo_RuleGroup.DiscardUnknown(m)
}

var xxx_messageInfo_RuleGroup proto.InternalMessageInfo

type Rule struct {
	// Types that are valid to be assigned to Result:
	//	*Rule_Recording
	//	*Rule_Alert
	Result isRule_Result `protobuf_oneof:"result"`
}

func (m *Rule) Reset()         { *m = Rule{} }
func (m *Rule) String() string { return proto.CompactTextString(m) }
func (*Rule) ProtoMessage()    {}
func (*Rule) Descriptor() ([]byte, []int) {
	return fileDescriptor_91b1d28f30eb5efb, []int{4}
}
func (m *Rule) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Rule) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Rule.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Rule) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Rule.Merge(m, src)
}
func (m *Rule) XXX_Size() int {
	return m.Size()
}
func (m *Rule) XXX_DiscardUnknown() {
	xxx_messageInfo_Rule.DiscardUnknown(m)
}

var xxx_messageInfo_Rule proto.InternalMessageInfo

type isRule_Result interface {
	isRule_Result()
	MarshalTo([]byte) (int, error)
	Size() int
}

type Rule_Recording struct {
	Recording *RecordingRule `protobuf:"bytes,1,opt,name=recording,proto3,oneof" json:"recording,omitempty"`
}
type Rule_Alert struct {
	Alert *Alert `protobuf:"bytes,2,opt,name=alert,proto3,oneof" json:"alert,omitempty"`
}

func (*Rule_Recording) isRule_Result() {}
func (*Rule_Alert) isRule_Result()     {}

func (m *Rule) GetResult() isRule_Result {
	if m != nil {
		return m.Result
	}
	return nil
}

func (m *Rule) GetRecording() *RecordingRule {
	if x, ok := m.GetResult().(*Rule_Recording); ok {
		return x.Recording
	}
	return nil
}

func (m *Rule) GetAlert() *Alert {
	if x, ok := m.GetResult().(*Rule_Alert); ok {
		return x.Alert
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Rule) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Rule_Recording)(nil),
		(*Rule_Alert)(nil),
	}
}

type AlertInstance struct {
	Labels      labelpb.LabelSet `protobuf:"bytes,1,opt,name=labels,proto3" json:"labels"`
	Annotations labelpb.LabelSet `protobuf:"bytes,2,opt,name=annotations,proto3" json:"annotations"`
	State       AlertState       `protobuf:"varint,3,opt,name=state,proto3,enum=thanos.AlertState" json:"state"`
	ActiveAt    *time.Time       `protobuf:"bytes,4,opt,name=active_at,json=activeAt,proto3,stdtime" json:"activeAt,omitempty"`
	Value       string           `protobuf:"bytes,5,opt,name=value,proto3" json:"value"`
	// Thanos specific. Used mainly for alert API purposes.
	PartialResponseStrategy storepb.PartialResponseStrategy `protobuf:"varint,6,opt,name=PartialResponseStrategy,proto3,enum=thanos.PartialResponseStrategy" json:"partialResponseStrategy"`
}

func (m *AlertInstance) Reset()         { *m = AlertInstance{} }
func (m *AlertInstance) String() string { return proto.CompactTextString(m) }
func (*AlertInstance) ProtoMessage()    {}
func (*AlertInstance) Descriptor() ([]byte, []int) {
	return fileDescriptor_91b1d28f30eb5efb, []int{5}
}
func (m *AlertInstance) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AlertInstance) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AlertInstance.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AlertInstance) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AlertInstance.Merge(m, src)
}
func (m *AlertInstance) XXX_Size() int {
	return m.Size()
}
func (m *AlertInstance) XXX_DiscardUnknown() {
	xxx_messageInfo_AlertInstance.DiscardUnknown(m)
}

var xxx_messageInfo_AlertInstance proto.InternalMessageInfo

type Alert struct {
	/// state returns the maximum state of alert instances for this rule.
	State                     AlertState       `protobuf:"varint,1,opt,name=state,proto3,enum=thanos.AlertState" json:"state"`
	Name                      string           `protobuf:"bytes,2,opt,name=name,proto3" json:"name"`
	Query                     string           `protobuf:"bytes,3,opt,name=query,proto3" json:"query"`
	DurationSeconds           float64          `protobuf:"fixed64,4,opt,name=duration_seconds,json=durationSeconds,proto3" json:"duration"`
	Labels                    labelpb.LabelSet `protobuf:"bytes,5,opt,name=labels,proto3" json:"labels"`
	Annotations               labelpb.LabelSet `protobuf:"bytes,6,opt,name=annotations,proto3" json:"annotations"`
	Alerts                    []*AlertInstance `protobuf:"bytes,7,rep,name=alerts,proto3" json:"alerts"`
	Health                    string           `protobuf:"bytes,8,opt,name=health,proto3" json:"health"`
	LastError                 string           `protobuf:"bytes,9,opt,name=last_error,json=lastError,proto3" json:"lastError,omitempty"`
	EvaluationDurationSeconds float64          `protobuf:"fixed64,10,opt,name=evaluation_duration_seconds,json=evaluationDurationSeconds,proto3" json:"evaluationTime"`
	LastEvaluation            time.Time        `protobuf:"bytes,11,opt,name=last_evaluation,json=lastEvaluation,proto3,stdtime" json:"lastEvaluation"`
}

func (m *Alert) Reset()         { *m = Alert{} }
func (m *Alert) String() string { return proto.CompactTextString(m) }
func (*Alert) ProtoMessage()    {}
func (*Alert) Descriptor() ([]byte, []int) {
	return fileDescriptor_91b1d28f30eb5efb, []int{6}
}
func (m *Alert) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Alert) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Alert.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Alert) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Alert.Merge(m, src)
}
func (m *Alert) XXX_Size() int {
	return m.Size()
}
func (m *Alert) XXX_DiscardUnknown() {
	xxx_messageInfo_Alert.DiscardUnknown(m)
}

var xxx_messageInfo_Alert proto.InternalMessageInfo

type RecordingRule struct {
	Name                      string           `protobuf:"bytes,1,opt,name=name,proto3" json:"name"`
	Query                     string           `protobuf:"bytes,2,opt,name=query,proto3" json:"query"`
	Labels                    labelpb.LabelSet `protobuf:"bytes,3,opt,name=labels,proto3" json:"labels"`
	Health                    string           `protobuf:"bytes,4,opt,name=health,proto3" json:"health"`
	LastError                 string           `protobuf:"bytes,5,opt,name=last_error,json=lastError,proto3" json:"lastError,omitempty"`
	EvaluationDurationSeconds float64          `protobuf:"fixed64,6,opt,name=evaluation_duration_seconds,json=evaluationDurationSeconds,proto3" json:"evaluationTime"`
	LastEvaluation            time.Time        `protobuf:"bytes,7,opt,name=last_evaluation,json=lastEvaluation,proto3,stdtime" json:"lastEvaluation"`
}

func (m *RecordingRule) Reset()         { *m = RecordingRule{} }
func (m *RecordingRule) String() string { return proto.CompactTextString(m) }
func (*RecordingRule) ProtoMessage()    {}
func (*RecordingRule) Descriptor() ([]byte, []int) {
	return fileDescriptor_91b1d28f30eb5efb, []int{7}
}
func (m *RecordingRule) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RecordingRule) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RecordingRule.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RecordingRule) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RecordingRule.Merge(m, src)
}
func (m *RecordingRule) XXX_Size() int {
	return m.Size()
}
func (m *RecordingRule) XXX_DiscardUnknown() {
	xxx_messageInfo_RecordingRule.DiscardUnknown(m)
}

var xxx_messageInfo_RecordingRule proto.InternalMessageInfo

func init() {
	proto.RegisterEnum("thanos.AlertState", AlertState_name, AlertState_value)
	proto.RegisterEnum("thanos.RulesRequest_Type", RulesRequest_Type_name, RulesRequest_Type_value)
	proto.RegisterType((*RulesRequest)(nil), "thanos.RulesRequest")
	proto.RegisterType((*RulesResponse)(nil), "thanos.RulesResponse")
	proto.RegisterType((*RuleGroups)(nil), "thanos.RuleGroups")
	proto.RegisterType((*RuleGroup)(nil), "thanos.RuleGroup")
	proto.RegisterType((*Rule)(nil), "thanos.Rule")
	proto.RegisterType((*AlertInstance)(nil), "thanos.AlertInstance")
	proto.RegisterType((*Alert)(nil), "thanos.Alert")
	proto.RegisterType((*RecordingRule)(nil), "thanos.RecordingRule")
}

func init() { proto.RegisterFile("rules/rulespb/rpc.proto", fileDescriptor_91b1d28f30eb5efb) }

var fileDescriptor_91b1d28f30eb5efb = []byte{
	// 983 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x56, 0x4f, 0x6f, 0xe3, 0x44,
	0x14, 0xb7, 0x9b, 0xd8, 0x89, 0x5f, 0xda, 0x6e, 0x98, 0xdd, 0xaa, 0x6e, 0x16, 0xc5, 0x55, 0xa4,
	0x45, 0x05, 0xb1, 0x09, 0x6a, 0xb5, 0x0b, 0x9c, 0x50, 0xd2, 0x86, 0x36, 0x52, 0x55, 0x56, 0x93,
	0x88, 0x03, 0x1c, 0xc2, 0x24, 0x9d, 0x4d, 0x23, 0x39, 0xb6, 0x77, 0x66, 0x52, 0x94, 0x33, 0x5f,
	0x60, 0xaf, 0x7c, 0x10, 0xbe, 0x00, 0xa7, 0x5e, 0x90, 0xf6, 0xc8, 0x29, 0x40, 0x7b, 0xcb, 0xa7,
	0x40, 0x33, 0x63, 0xc7, 0x69, 0xb7, 0xa5, 0xbb, 0x10, 0x2e, 0x7e, 0x33, 0xef, 0xfd, 0xde, 0xfc,
	0x79, 0xef, 0xe7, 0x9f, 0x0d, 0x9b, 0x6c, 0xec, 0x53, 0x5e, 0x53, 0xcf, 0xa8, 0x57, 0x63, 0x51,
	0xbf, 0x1a, 0xb1, 0x50, 0x84, 0xc8, 0x16, 0x67, 0x24, 0x08, 0x79, 0x69, 0x8b, 0x8b, 0x90, 0xd1,
	0x9a, 0x7a, 0x46, 0xbd, 0x9a, 0x98, 0x44, 0x94, 0x6b, 0x48, 0x12, 0xf2, 0x49, 0x8f, 0xfa, 0x37,
	0x42, 0x8f, 0x06, 0xe1, 0x20, 0x54, 0xc3, 0x9a, 0x1c, 0xc5, 0x5e, 0x6f, 0x10, 0x86, 0x03, 0x9f,
	0xd6, 0xd4, 0xac, 0x37, 0x7e, 0x59, 0x13, 0xc3, 0x11, 0xe5, 0x82, 0x8c, 0x22, 0x0d, 0xa8, 0xfc,
	0x6a, 0xc2, 0x2a, 0x96, 0x47, 0xc1, 0xf4, 0xd5, 0x98, 0x72, 0x81, 0x9e, 0x42, 0x56, 0x2e, 0xeb,
	0x9a, 0xdb, 0xe6, 0xce, 0xfa, 0xee, 0x56, 0x55, 0x1f, 0xaa, 0xba, 0x88, 0xa9, 0x76, 0x26, 0x11,
	0xc5, 0x0a, 0x86, 0xbe, 0x87, 0xad, 0x88, 0x30, 0x31, 0x24, 0x7e, 0x97, 0x51, 0x1e, 0x85, 0x01,
	0xa7, 0x5d, 0x2e, 0x18, 0x11, 0x74, 0x30, 0x71, 0x57, 0xd4, 0x1a, 0x5e, 0xb2, 0xc6, 0x0b, 0x0d,
	0xc4, 0x31, 0xae, 0x1d, 0xc3, 0xf0, 0x66, 0x74, 0x7b, 0xa0, 0xf2, 0x11, 0x64, 0xe5, 0x56, 0x28,
	0x07, 0x99, 0xfa, 0xf1, 0x71, 0xd1, 0x40, 0x0e, 0x58, 0xf5, 0xe3, 0x26, 0xee, 0x14, 0x4d, 0x04,
	0x60, 0xe3, 0xe6, 0xfe, 0x37, 0xf8, 0xa0, 0xb8, 0x52, 0xf9, 0x01, 0xd6, 0xe2, 0xf3, 0xe9, 0x05,
	0xd0, 0xc7, 0x60, 0x0d, 0x58, 0x38, 0x8e, 0xd4, 0x2d, 0x0a, 0xbb, 0x1f, 0x2c, 0xde, 0xe2, 0x50,
	0x06, 0x8e, 0x0c, 0xac, 0x11, 0xa8, 0x04, 0xb9, 0x1f, 0x09, 0x0b, 0x86, 0xc1, 0x40, 0x1d, 0xd7,
	0x39, 0x32, 0x70, 0xe2, 0x68, 0xe4, 0xc1, 0x66, 0x94, 0x8f, 0x7d, 0x51, 0xd9, 0x07, 0x98, 0xe7,
	0x72, 0xf4, 0x0c, 0x6c, 0x95, 0xcc, 0x5d, 0x73, 0x3b, 0x73, 0xeb, 0xfa, 0x0d, 0x98, 0x4d, 0xbd,
	0x18, 0x84, 0x63, 0x5b, 0xf9, 0x2d, 0x03, 0xce, 0x1c, 0x81, 0x3e, 0x84, 0x6c, 0x40, 0x46, 0xba,
	0xd0, 0x4e, 0x23, 0x3f, 0x9b, 0x7a, 0x6a, 0x8e, 0xd5, 0x53, 0x46, 0x5f, 0x0e, 0x7d, 0xaa, 0xcf,
	0xa4, 0xa3, 0x72, 0x8e, 0xd5, 0x13, 0x3d, 0x05, 0x4b, 0xf1, 0xc7, 0xcd, 0xa8, 0xfd, 0x57, 0x17,
	0xf7, 0x6f, 0x38, 0xb3, 0xa9, 0xa7, 0xc3, 0x58, 0x1b, 0xb4, 0x03, 0xf9, 0x61, 0x20, 0x28, 0x3b,
	0x27, 0xbe, 0x9b, 0xdd, 0x36, 0x77, 0xcc, 0xc6, 0xea, 0x6c, 0xea, 0xcd, 0x7d, 0x78, 0x3e, 0x42,
	0x18, 0x1e, 0xd3, 0x73, 0xe2, 0x8f, 0x89, 0x18, 0x86, 0x41, 0xf7, 0x74, 0xcc, 0xf4, 0x80, 0xd3,
	0x7e, 0x18, 0x9c, 0x72, 0xd7, 0x52, 0xc9, 0x68, 0x36, 0xf5, 0xd6, 0x53, 0x58, 0x67, 0x38, 0xa2,
	0x78, 0x2b, 0x9d, 0x1f, 0xc4, 0x59, 0x6d, 0x9d, 0x84, 0xba, 0xf0, 0xc0, 0x27, 0x5c, 0x74, 0x53,
	0x84, 0x6b, 0xab, 0xb6, 0x94, 0xaa, 0x9a, 0x9d, 0xd5, 0x84, 0x9d, 0xd5, 0x4e, 0xc2, 0xce, 0x46,
	0xe9, 0x62, 0xea, 0x19, 0x72, 0x1f, 0x99, 0xda, 0x9c, 0x67, 0xbe, 0xfe, 0xc3, 0x33, 0xf1, 0x0d,
	0x1f, 0x3a, 0x87, 0xcd, 0x3b, 0xa8, 0xe5, 0xe6, 0xdf, 0x89, 0x81, 0x8d, 0xc7, 0xb3, 0xa9, 0x77,
	0x17, 0x0b, 0xf1, 0x5d, 0x8b, 0x57, 0x02, 0xc8, 0xca, 0x82, 0xa3, 0x67, 0xe0, 0x30, 0xda, 0x0f,
	0xd9, 0xa9, 0x24, 0x91, 0x66, 0xdc, 0xc6, 0xbc, 0x23, 0x49, 0x40, 0x22, 0x8f, 0x0c, 0x9c, 0x22,
	0xd1, 0x13, 0xb0, 0x88, 0x4f, 0x99, 0x50, 0x3d, 0x2e, 0xec, 0xae, 0x25, 0x29, 0x75, 0xe9, 0x94,
	0x04, 0x55, 0xd1, 0x05, 0x12, 0xfe, 0x92, 0x81, 0x35, 0x15, 0x6c, 0x05, 0x5c, 0x90, 0xa0, 0x4f,
	0xd1, 0x17, 0x60, 0x2b, 0x2d, 0xe0, 0xf1, 0xb6, 0xc5, 0x64, 0x8d, 0x63, 0xe9, 0x6d, 0x53, 0xd1,
	0x58, 0x8f, 0xeb, 0x18, 0xe3, 0x70, 0x6c, 0xd1, 0x21, 0x14, 0x48, 0x10, 0x84, 0x42, 0x55, 0x90,
	0xc7, 0x47, 0x78, 0x3b, 0xfd, 0x61, 0x9c, 0xbe, 0x08, 0xc6, 0x8b, 0x13, 0xb4, 0x07, 0x16, 0x17,
	0x44, 0x50, 0x37, 0xa3, 0x4a, 0x8d, 0xae, 0xdd, 0xa2, 0x2d, 0x23, 0x9a, 0x90, 0x0a, 0x84, 0xb5,
	0x41, 0x6d, 0x70, 0x48, 0x5f, 0x0c, 0xcf, 0x69, 0x97, 0x08, 0xc5, 0xc8, 0x7b, 0xc8, 0x30, 0x9b,
	0x7a, 0x48, 0x27, 0xd4, 0xc5, 0xa7, 0xe1, 0x68, 0x28, 0xe8, 0x28, 0x12, 0x13, 0x45, 0x86, 0x7c,
	0xe2, 0x47, 0x1e, 0x58, 0x92, 0x13, 0x54, 0xb1, 0xd4, 0xd1, 0xbb, 0x2a, 0x07, 0xd6, 0xe6, 0x9f,
	0x78, 0x62, 0xff, 0x9f, 0x3c, 0xf9, 0xc9, 0x02, 0x4b, 0x95, 0x23, 0x2d, 0x96, 0xf9, 0x1e, 0xc5,
	0x4a, 0x84, 0x62, 0xe5, 0x56, 0xa1, 0xf0, 0xc0, 0x7a, 0x35, 0xa6, 0x6c, 0xa2, 0xea, 0x1f, 0xdf,
	0x5a, 0x39, 0xb0, 0x36, 0xe8, 0x73, 0x28, 0xbe, 0xf5, 0x1e, 0x2f, 0x88, 0x40, 0x12, 0xc3, 0x0f,
	0x4e, 0x6f, 0xbc, 0xb7, 0x29, 0xb9, 0xac, 0xff, 0x46, 0x2e, 0xfb, 0x5f, 0x93, 0xeb, 0x4b, 0xb0,
	0xd5, 0x4b, 0xc0, 0xdd, 0x9c, 0x12, 0xba, 0x8d, 0x6b, 0x05, 0x4b, 0x5e, 0x03, 0x2d, 0xb6, 0x1a,
	0x88, 0x63, 0x8b, 0x2a, 0x60, 0x9f, 0x51, 0xe2, 0x8b, 0x33, 0xa5, 0x01, 0x8e, 0xc6, 0x68, 0x0f,
	0x8e, 0x2d, 0x7a, 0x0e, 0xa0, 0x95, 0x89, 0xb1, 0x90, 0xb9, 0x8e, 0xc2, 0x6d, 0xce, 0xa6, 0xde,
	0x43, 0x25, 0x30, 0xd2, 0x99, 0x92, 0x0d, 0x3b, 0x73, 0xe7, 0x7d, 0x2a, 0x09, 0x4b, 0x52, 0xc9,
	0xc2, 0x32, 0x55, 0xb2, 0xf2, 0x73, 0x06, 0xd6, 0xae, 0xa9, 0xd1, 0x3d, 0x5f, 0xa0, 0x39, 0xb1,
	0x56, 0xee, 0x20, 0x56, 0xca, 0x8f, 0xcc, 0x7b, 0xf2, 0x23, 0xed, 0x4d, 0xf6, 0x1d, 0x7b, 0x63,
	0x2d, 0xab, 0x37, 0xf6, 0x92, 0x7a, 0x93, 0x5b, 0x66, 0x6f, 0x3e, 0xd9, 0x03, 0x48, 0x25, 0x00,
	0xad, 0x42, 0xbe, 0x75, 0x52, 0xdf, 0xef, 0xb4, 0xbe, 0x6d, 0x16, 0x0d, 0x54, 0x80, 0xdc, 0x8b,
	0xe6, 0xc9, 0x41, 0xeb, 0xe4, 0x50, 0xff, 0xf5, 0x7c, 0xdd, 0xc2, 0x72, 0xbc, 0xb2, 0xfb, 0x15,
	0x58, 0xea, 0xaf, 0x07, 0x3d, 0x4f, 0x06, 0x8f, 0x6e, 0xfb, 0x5b, 0x2b, 0x6d, 0xdc, 0xf0, 0x6a,
	0x75, 0xfa, 0xcc, 0x6c, 0x3c, 0xb9, 0xf8, 0xab, 0x6c, 0x5c, 0x5c, 0x96, 0xcd, 0x37, 0x97, 0x65,
	0xf3, 0xcf, 0xcb, 0xb2, 0xf9, 0xfa, 0xaa, 0x6c, 0xbc, 0xb9, 0x2a, 0x1b, 0xbf, 0x5f, 0x95, 0x8d,
	0xef, 0x72, 0xf1, 0x1f, 0x6a, 0xcf, 0x56, 0x97, 0xdb, 0xfb, 0x3b, 0x00, 0x00, 0xff, 0xff, 0x6d,
	0xf1, 0x63, 0x71, 0xb9, 0x0a, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// RulesClient is the client API for Rules service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type RulesClient interface {
	/// Rules has info for all rules.
	/// Returned rules are expected to include external labels.
	Rules(ctx context.Context, in *RulesRequest, opts ...grpc.CallOption) (Rules_RulesClient, error)
}

type rulesClient struct {
	cc *grpc.ClientConn
}

func NewRulesClient(cc *grpc.ClientConn) RulesClient {
	return &rulesClient{cc}
}

func (c *rulesClient) Rules(ctx context.Context, in *RulesRequest, opts ...grpc.CallOption) (Rules_RulesClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Rules_serviceDesc.Streams[0], "/thanos.Rules/Rules", opts...)
	if err != nil {
		return nil, err
	}
	x := &rulesRulesClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Rules_RulesClient interface {
	Recv() (*RulesResponse, error)
	grpc.ClientStream
}

type rulesRulesClient struct {
	grpc.ClientStream
}

func (x *rulesRulesClient) Recv() (*RulesResponse, error) {
	m := new(RulesResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// RulesServer is the server API for Rules service.
type RulesServer interface {
	/// Rules has info for all rules.
	/// Returned rules are expected to include external labels.
	Rules(*RulesRequest, Rules_RulesServer) error
}

// UnimplementedRulesServer can be embedded to have forward compatible implementations.
type UnimplementedRulesServer struct {
}

func (*UnimplementedRulesServer) Rules(req *RulesRequest, srv Rules_RulesServer) error {
	return status.Errorf(codes.Unimplemented, "method Rules not implemented")
}

func RegisterRulesServer(s *grpc.Server, srv RulesServer) {
	s.RegisterService(&_Rules_serviceDesc, srv)
}

func _Rules_Rules_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(RulesRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(RulesServer).Rules(m, &rulesRulesServer{stream})
}

type Rules_RulesServer interface {
	Send(*RulesResponse) error
	grpc.ServerStream
}

type rulesRulesServer struct {
	grpc.ServerStream
}

func (x *rulesRulesServer) Send(m *RulesResponse) error {
	return x.ServerStream.SendMsg(m)
}

var _Rules_serviceDesc = grpc.ServiceDesc{
	ServiceName: "thanos.Rules",
	HandlerType: (*RulesServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Rules",
			Handler:       _Rules_Rules_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "rules/rulespb/rpc.proto",
}

func (m *RulesRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RulesRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RulesRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.PartialResponseStrategy != 0 {
		i = encodeVarintRpc(dAtA, i, uint64(m.PartialResponseStrategy))
		i--
		dAtA[i] = 0x10
	}
	if m.Type != 0 {
		i = encodeVarintRpc(dAtA, i, uint64(m.Type))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *RulesResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RulesResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RulesResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Result != nil {
		{
			size := m.Result.Size()
			i -= size
			if _, err := m.Result.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	return len(dAtA) - i, nil
}

func (m *RulesResponse_Group) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RulesResponse_Group) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Group != nil {
		{
			size, err := m.Group.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRpc(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}
func (m *RulesResponse_Warning) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RulesResponse_Warning) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i -= len(m.Warning)
	copy(dAtA[i:], m.Warning)
	i = encodeVarintRpc(dAtA, i, uint64(len(m.Warning)))
	i--
	dAtA[i] = 0x12
	return len(dAtA) - i, nil
}
func (m *RuleGroups) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RuleGroups) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RuleGroups) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Groups) > 0 {
		for iNdEx := len(m.Groups) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Groups[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintRpc(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *RuleGroup) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RuleGroup) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RuleGroup) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.PartialResponseStrategy != 0 {
		i = encodeVarintRpc(dAtA, i, uint64(m.PartialResponseStrategy))
		i--
		dAtA[i] = 0x40
	}
	n2, err2 := github_com_gogo_protobuf_types.StdTimeMarshalTo(m.LastEvaluation, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(m.LastEvaluation):])
	if err2 != nil {
		return 0, err2
	}
	i -= n2
	i = encodeVarintRpc(dAtA, i, uint64(n2))
	i--
	dAtA[i] = 0x32
	if m.EvaluationDurationSeconds != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.EvaluationDurationSeconds))))
		i--
		dAtA[i] = 0x29
	}
	if m.Interval != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.Interval))))
		i--
		dAtA[i] = 0x21
	}
	if len(m.Rules) > 0 {
		for iNdEx := len(m.Rules) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Rules[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintRpc(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.File) > 0 {
		i -= len(m.File)
		copy(dAtA[i:], m.File)
		i = encodeVarintRpc(dAtA, i, uint64(len(m.File)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintRpc(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Rule) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Rule) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Rule) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Result != nil {
		{
			size := m.Result.Size()
			i -= size
			if _, err := m.Result.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	return len(dAtA) - i, nil
}

func (m *Rule_Recording) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Rule_Recording) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Recording != nil {
		{
			size, err := m.Recording.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRpc(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}
func (m *Rule_Alert) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Rule_Alert) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Alert != nil {
		{
			size, err := m.Alert.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRpc(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	return len(dAtA) - i, nil
}
func (m *AlertInstance) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AlertInstance) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AlertInstance) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.PartialResponseStrategy != 0 {
		i = encodeVarintRpc(dAtA, i, uint64(m.PartialResponseStrategy))
		i--
		dAtA[i] = 0x30
	}
	if len(m.Value) > 0 {
		i -= len(m.Value)
		copy(dAtA[i:], m.Value)
		i = encodeVarintRpc(dAtA, i, uint64(len(m.Value)))
		i--
		dAtA[i] = 0x2a
	}
	if m.ActiveAt != nil {
		n5, err5 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.ActiveAt, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.ActiveAt):])
		if err5 != nil {
			return 0, err5
		}
		i -= n5
		i = encodeVarintRpc(dAtA, i, uint64(n5))
		i--
		dAtA[i] = 0x22
	}
	if m.State != 0 {
		i = encodeVarintRpc(dAtA, i, uint64(m.State))
		i--
		dAtA[i] = 0x18
	}
	{
		size, err := m.Annotations.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintRpc(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x12
	{
		size, err := m.Labels.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintRpc(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *Alert) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Alert) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Alert) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	n8, err8 := github_com_gogo_protobuf_types.StdTimeMarshalTo(m.LastEvaluation, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(m.LastEvaluation):])
	if err8 != nil {
		return 0, err8
	}
	i -= n8
	i = encodeVarintRpc(dAtA, i, uint64(n8))
	i--
	dAtA[i] = 0x5a
	if m.EvaluationDurationSeconds != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.EvaluationDurationSeconds))))
		i--
		dAtA[i] = 0x51
	}
	if len(m.LastError) > 0 {
		i -= len(m.LastError)
		copy(dAtA[i:], m.LastError)
		i = encodeVarintRpc(dAtA, i, uint64(len(m.LastError)))
		i--
		dAtA[i] = 0x4a
	}
	if len(m.Health) > 0 {
		i -= len(m.Health)
		copy(dAtA[i:], m.Health)
		i = encodeVarintRpc(dAtA, i, uint64(len(m.Health)))
		i--
		dAtA[i] = 0x42
	}
	if len(m.Alerts) > 0 {
		for iNdEx := len(m.Alerts) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Alerts[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintRpc(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x3a
		}
	}
	{
		size, err := m.Annotations.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintRpc(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x32
	{
		size, err := m.Labels.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintRpc(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x2a
	if m.DurationSeconds != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.DurationSeconds))))
		i--
		dAtA[i] = 0x21
	}
	if len(m.Query) > 0 {
		i -= len(m.Query)
		copy(dAtA[i:], m.Query)
		i = encodeVarintRpc(dAtA, i, uint64(len(m.Query)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintRpc(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x12
	}
	if m.State != 0 {
		i = encodeVarintRpc(dAtA, i, uint64(m.State))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *RecordingRule) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RecordingRule) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RecordingRule) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	n11, err11 := github_com_gogo_protobuf_types.StdTimeMarshalTo(m.LastEvaluation, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(m.LastEvaluation):])
	if err11 != nil {
		return 0, err11
	}
	i -= n11
	i = encodeVarintRpc(dAtA, i, uint64(n11))
	i--
	dAtA[i] = 0x3a
	if m.EvaluationDurationSeconds != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.EvaluationDurationSeconds))))
		i--
		dAtA[i] = 0x31
	}
	if len(m.LastError) > 0 {
		i -= len(m.LastError)
		copy(dAtA[i:], m.LastError)
		i = encodeVarintRpc(dAtA, i, uint64(len(m.LastError)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.Health) > 0 {
		i -= len(m.Health)
		copy(dAtA[i:], m.Health)
		i = encodeVarintRpc(dAtA, i, uint64(len(m.Health)))
		i--
		dAtA[i] = 0x22
	}
	{
		size, err := m.Labels.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintRpc(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x1a
	if len(m.Query) > 0 {
		i -= len(m.Query)
		copy(dAtA[i:], m.Query)
		i = encodeVarintRpc(dAtA, i, uint64(len(m.Query)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintRpc(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintRpc(dAtA []byte, offset int, v uint64) int {
	offset -= sovRpc(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *RulesRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Type != 0 {
		n += 1 + sovRpc(uint64(m.Type))
	}
	if m.PartialResponseStrategy != 0 {
		n += 1 + sovRpc(uint64(m.PartialResponseStrategy))
	}
	return n
}

func (m *RulesResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Result != nil {
		n += m.Result.Size()
	}
	return n
}

func (m *RulesResponse_Group) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Group != nil {
		l = m.Group.Size()
		n += 1 + l + sovRpc(uint64(l))
	}
	return n
}
func (m *RulesResponse_Warning) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Warning)
	n += 1 + l + sovRpc(uint64(l))
	return n
}
func (m *RuleGroups) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Groups) > 0 {
		for _, e := range m.Groups {
			l = e.Size()
			n += 1 + l + sovRpc(uint64(l))
		}
	}
	return n
}

func (m *RuleGroup) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovRpc(uint64(l))
	}
	l = len(m.File)
	if l > 0 {
		n += 1 + l + sovRpc(uint64(l))
	}
	if len(m.Rules) > 0 {
		for _, e := range m.Rules {
			l = e.Size()
			n += 1 + l + sovRpc(uint64(l))
		}
	}
	if m.Interval != 0 {
		n += 9
	}
	if m.EvaluationDurationSeconds != 0 {
		n += 9
	}
	l = github_com_gogo_protobuf_types.SizeOfStdTime(m.LastEvaluation)
	n += 1 + l + sovRpc(uint64(l))
	if m.PartialResponseStrategy != 0 {
		n += 1 + sovRpc(uint64(m.PartialResponseStrategy))
	}
	return n
}

func (m *Rule) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Result != nil {
		n += m.Result.Size()
	}
	return n
}

func (m *Rule_Recording) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Recording != nil {
		l = m.Recording.Size()
		n += 1 + l + sovRpc(uint64(l))
	}
	return n
}
func (m *Rule_Alert) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Alert != nil {
		l = m.Alert.Size()
		n += 1 + l + sovRpc(uint64(l))
	}
	return n
}
func (m *AlertInstance) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.Labels.Size()
	n += 1 + l + sovRpc(uint64(l))
	l = m.Annotations.Size()
	n += 1 + l + sovRpc(uint64(l))
	if m.State != 0 {
		n += 1 + sovRpc(uint64(m.State))
	}
	if m.ActiveAt != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.ActiveAt)
		n += 1 + l + sovRpc(uint64(l))
	}
	l = len(m.Value)
	if l > 0 {
		n += 1 + l + sovRpc(uint64(l))
	}
	if m.PartialResponseStrategy != 0 {
		n += 1 + sovRpc(uint64(m.PartialResponseStrategy))
	}
	return n
}

func (m *Alert) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.State != 0 {
		n += 1 + sovRpc(uint64(m.State))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovRpc(uint64(l))
	}
	l = len(m.Query)
	if l > 0 {
		n += 1 + l + sovRpc(uint64(l))
	}
	if m.DurationSeconds != 0 {
		n += 9
	}
	l = m.Labels.Size()
	n += 1 + l + sovRpc(uint64(l))
	l = m.Annotations.Size()
	n += 1 + l + sovRpc(uint64(l))
	if len(m.Alerts) > 0 {
		for _, e := range m.Alerts {
			l = e.Size()
			n += 1 + l + sovRpc(uint64(l))
		}
	}
	l = len(m.Health)
	if l > 0 {
		n += 1 + l + sovRpc(uint64(l))
	}
	l = len(m.LastError)
	if l > 0 {
		n += 1 + l + sovRpc(uint64(l))
	}
	if m.EvaluationDurationSeconds != 0 {
		n += 9
	}
	l = github_com_gogo_protobuf_types.SizeOfStdTime(m.LastEvaluation)
	n += 1 + l + sovRpc(uint64(l))
	return n
}

func (m *RecordingRule) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovRpc(uint64(l))
	}
	l = len(m.Query)
	if l > 0 {
		n += 1 + l + sovRpc(uint64(l))
	}
	l = m.Labels.Size()
	n += 1 + l + sovRpc(uint64(l))
	l = len(m.Health)
	if l > 0 {
		n += 1 + l + sovRpc(uint64(l))
	}
	l = len(m.LastError)
	if l > 0 {
		n += 1 + l + sovRpc(uint64(l))
	}
	if m.EvaluationDurationSeconds != 0 {
		n += 9
	}
	l = github_com_gogo_protobuf_types.SizeOfStdTime(m.LastEvaluation)
	n += 1 + l + sovRpc(uint64(l))
	return n
}

func sovRpc(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozRpc(x uint64) (n int) {
	return sovRpc(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *RulesRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRpc
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RulesRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RulesRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= RulesRequest_Type(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PartialResponseStrategy", wireType)
			}
			m.PartialResponseStrategy = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.PartialResponseStrategy |= storepb.PartialResponseStrategy(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipRpc(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRpc
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRpc
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RulesResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRpc
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RulesResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RulesResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Group", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &RuleGroup{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Result = &RulesResponse_Group{v}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Warning", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Result = &RulesResponse_Warning{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRpc(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRpc
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRpc
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RuleGroups) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRpc
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RuleGroups: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RuleGroups: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Groups", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Groups = append(m.Groups, &RuleGroup{})
			if err := m.Groups[len(m.Groups)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRpc(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRpc
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRpc
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RuleGroup) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRpc
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RuleGroup: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RuleGroup: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field File", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.File = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Rules", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Rules = append(m.Rules, &Rule{})
			if err := m.Rules[len(m.Rules)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field Interval", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.Interval = float64(math.Float64frombits(v))
		case 5:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field EvaluationDurationSeconds", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.EvaluationDurationSeconds = float64(math.Float64frombits(v))
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastEvaluation", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(&m.LastEvaluation, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PartialResponseStrategy", wireType)
			}
			m.PartialResponseStrategy = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.PartialResponseStrategy |= storepb.PartialResponseStrategy(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipRpc(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRpc
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRpc
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Rule) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRpc
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Rule: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Rule: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Recording", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &RecordingRule{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Result = &Rule_Recording{v}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Alert", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Alert{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Result = &Rule_Alert{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRpc(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRpc
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRpc
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AlertInstance) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRpc
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AlertInstance: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AlertInstance: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Labels", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Labels.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Annotations", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Annotations.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field State", wireType)
			}
			m.State = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.State |= AlertState(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ActiveAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ActiveAt == nil {
				m.ActiveAt = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.ActiveAt, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PartialResponseStrategy", wireType)
			}
			m.PartialResponseStrategy = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.PartialResponseStrategy |= storepb.PartialResponseStrategy(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipRpc(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRpc
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRpc
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Alert) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRpc
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Alert: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Alert: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field State", wireType)
			}
			m.State = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.State |= AlertState(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Query", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Query = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field DurationSeconds", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.DurationSeconds = float64(math.Float64frombits(v))
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Labels", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Labels.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Annotations", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Annotations.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Alerts", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Alerts = append(m.Alerts, &AlertInstance{})
			if err := m.Alerts[len(m.Alerts)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Health", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Health = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastError", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.LastError = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 10:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field EvaluationDurationSeconds", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.EvaluationDurationSeconds = float64(math.Float64frombits(v))
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastEvaluation", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(&m.LastEvaluation, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRpc(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRpc
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRpc
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RecordingRule) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRpc
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RecordingRule: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RecordingRule: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Query", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Query = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Labels", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Labels.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Health", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Health = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastError", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.LastError = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field EvaluationDurationSeconds", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.EvaluationDurationSeconds = float64(math.Float64frombits(v))
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastEvaluation", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(&m.LastEvaluation, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRpc(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRpc
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRpc
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipRpc(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowRpc
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthRpc
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupRpc
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthRpc
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthRpc        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowRpc          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupRpc = fmt.Errorf("proto: unexpected end of group")
)
