/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Copyright 2019 Red Hat, Inc.
 *
 */
// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"time"

	v1alpha1 "github.com/openshift/machine-api-operator/pkg/apis/healthchecking/v1alpha1"
	scheme "github.com/openshift/machine-api-operator/pkg/generated/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// MachineDisruptionBudgetsGetter has a method to return a MachineDisruptionBudgetInterface.
// A group's client should implement this interface.
type MachineDisruptionBudgetsGetter interface {
	MachineDisruptionBudgets(namespace string) MachineDisruptionBudgetInterface
}

// MachineDisruptionBudgetInterface has methods to work with MachineDisruptionBudget resources.
type MachineDisruptionBudgetInterface interface {
	Create(*v1alpha1.MachineDisruptionBudget) (*v1alpha1.MachineDisruptionBudget, error)
	Update(*v1alpha1.MachineDisruptionBudget) (*v1alpha1.MachineDisruptionBudget, error)
	UpdateStatus(*v1alpha1.MachineDisruptionBudget) (*v1alpha1.MachineDisruptionBudget, error)
	Delete(name string, options *v1.DeleteOptions) error
	DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error
	Get(name string, options v1.GetOptions) (*v1alpha1.MachineDisruptionBudget, error)
	List(opts v1.ListOptions) (*v1alpha1.MachineDisruptionBudgetList, error)
	Watch(opts v1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha1.MachineDisruptionBudget, err error)
	MachineDisruptionBudgetExpansion
}

// machineDisruptionBudgets implements MachineDisruptionBudgetInterface
type machineDisruptionBudgets struct {
	client rest.Interface
	ns     string
}

// newMachineDisruptionBudgets returns a MachineDisruptionBudgets
func newMachineDisruptionBudgets(c *HealthcheckingV1alpha1Client, namespace string) *machineDisruptionBudgets {
	return &machineDisruptionBudgets{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the machineDisruptionBudget, and returns the corresponding machineDisruptionBudget object, and an error if there is any.
func (c *machineDisruptionBudgets) Get(name string, options v1.GetOptions) (result *v1alpha1.MachineDisruptionBudget, err error) {
	result = &v1alpha1.MachineDisruptionBudget{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("machinedisruptionbudgets").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of MachineDisruptionBudgets that match those selectors.
func (c *machineDisruptionBudgets) List(opts v1.ListOptions) (result *v1alpha1.MachineDisruptionBudgetList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1alpha1.MachineDisruptionBudgetList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("machinedisruptionbudgets").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do().
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested machineDisruptionBudgets.
func (c *machineDisruptionBudgets) Watch(opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("machinedisruptionbudgets").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch()
}

// Create takes the representation of a machineDisruptionBudget and creates it.  Returns the server's representation of the machineDisruptionBudget, and an error, if there is any.
func (c *machineDisruptionBudgets) Create(machineDisruptionBudget *v1alpha1.MachineDisruptionBudget) (result *v1alpha1.MachineDisruptionBudget, err error) {
	result = &v1alpha1.MachineDisruptionBudget{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("machinedisruptionbudgets").
		Body(machineDisruptionBudget).
		Do().
		Into(result)
	return
}

// Update takes the representation of a machineDisruptionBudget and updates it. Returns the server's representation of the machineDisruptionBudget, and an error, if there is any.
func (c *machineDisruptionBudgets) Update(machineDisruptionBudget *v1alpha1.MachineDisruptionBudget) (result *v1alpha1.MachineDisruptionBudget, err error) {
	result = &v1alpha1.MachineDisruptionBudget{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("machinedisruptionbudgets").
		Name(machineDisruptionBudget.Name).
		Body(machineDisruptionBudget).
		Do().
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().

func (c *machineDisruptionBudgets) UpdateStatus(machineDisruptionBudget *v1alpha1.MachineDisruptionBudget) (result *v1alpha1.MachineDisruptionBudget, err error) {
	result = &v1alpha1.MachineDisruptionBudget{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("machinedisruptionbudgets").
		Name(machineDisruptionBudget.Name).
		SubResource("status").
		Body(machineDisruptionBudget).
		Do().
		Into(result)
	return
}

// Delete takes name of the machineDisruptionBudget and deletes it. Returns an error if one occurs.
func (c *machineDisruptionBudgets) Delete(name string, options *v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("machinedisruptionbudgets").
		Name(name).
		Body(options).
		Do().
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *machineDisruptionBudgets) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	var timeout time.Duration
	if listOptions.TimeoutSeconds != nil {
		timeout = time.Duration(*listOptions.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("machinedisruptionbudgets").
		VersionedParams(&listOptions, scheme.ParameterCodec).
		Timeout(timeout).
		Body(options).
		Do().
		Error()
}

// Patch applies the patch and returns the patched machineDisruptionBudget.
func (c *machineDisruptionBudgets) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha1.MachineDisruptionBudget, err error) {
	result = &v1alpha1.MachineDisruptionBudget{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("machinedisruptionbudgets").
		SubResource(subresources...).
		Name(name).
		Body(data).
		Do().
		Into(result)
	return
}
