// Generated by CoffeeScript 1.12.7
(function() {
  var abstract_mapper, adapter_to_name, fs, get_version, glob, indx, match_version_to_adapter, name_to_adapter, path, resolve, resolve_engine_path, semver, supports;

  path = require('path');

  fs = require('fs');

  glob = require('glob');

  indx = require('indx');

  resolve = require('resolve');

  semver = require('semver');

  exports.supports = supports = function(name) {
    name = adapter_to_name(name);
    return !!glob.sync("" + (path.join(__dirname, 'adapters', name))).length;
  };

  exports.load = function(name, custom_path, engine_name) {
    var adapter_name, engine_path, version;
    name = adapter_to_name(name);
    engine_path = resolve_engine_path(name, custom_path);
    version = get_version(engine_path);
    adapter_name = match_version_to_adapter(name, version);
    if (!adapter_name) {
      throw new Error(name + " version " + version + " is not currently supported");
    }
    return new (require(adapter_name))(engine_name, engine_path);
  };

  exports.all = function() {
    return indx(path.join(__dirname, 'adapters'));
  };

  exports.abstract_mapper = abstract_mapper = function(name, direction) {
    var name_maps, res;
    name_maps = [['markdown', 'marked'], ['minify-js', 'uglify-js'], ['minify-css', 'clean-css'], ['minify-html', 'html-minifier'], ['mustache', 'hogan.js'], ['scss', 'node-sass'], ['haml', 'hamljs'], ['escape-html', 'he'], ['jsx', 'react-tools'], ['cjsx', 'coffee-react-transform'], ['babel', 'babel-core'], ['typescript', 'typescript-compiler']];
    res = null;
    name_maps.forEach(function(n) {
      if (direction === 'left' && n[0] === name) {
        res = n[1];
      }
      if (direction === 'right' && n[1] === name) {
        return res = n[0];
      }
    });
    return res || name;
  };

  exports.adapter_to_name = adapter_to_name = function(name) {
    return abstract_mapper(name, 'right');
  };

  exports.name_to_adapter = name_to_adapter = function(name) {
    return abstract_mapper(name, 'left');
  };

  resolve_engine_path = function(name, custom_path) {
    var filepath;
    filepath = custom_path != null ? resolve.sync(name_to_adapter(name), {
      basedir: custom_path
    }) : require.resolve(name_to_adapter(name));
    while (true) {
      if (filepath === '/') {
        throw new Error("cannot resolve root of node module " + name);
      }
      filepath = path.dirname(filepath);
      if (fs.existsSync(path.join(filepath, 'package.json'))) {
        return filepath;
      }
    }
  };

  get_version = function(engine_path) {
    var err;
    try {
      return require(engine_path + '/package.json').version;
    } catch (error) {
      err = error;
    }
  };

  match_version_to_adapter = function(name, version) {
    var adapter, adapters, i, len;
    adapters = fs.readdirSync(path.join(__dirname, 'adapters', name));
    for (i = 0, len = adapters.length; i < len; i++) {
      adapter = adapters[i];
      adapter = adapter.replace(/\.(?:js|coffee)$/, '');
      if (semver.satisfies(version, adapter)) {
        return path.join(__dirname, 'adapters', name, adapter);
      }
    }
  };

}).call(this);
