"use strict";
// Copyright 2020 Google LLC
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.pubsublite_v1 = void 0;
/* eslint-disable @typescript-eslint/no-explicit-any */
/* eslint-disable @typescript-eslint/class-name-casing */
/* eslint-disable @typescript-eslint/no-unused-vars */
/* eslint-disable @typescript-eslint/no-empty-interface */
/* eslint-disable @typescript-eslint/no-namespace */
/* eslint-disable no-irregular-whitespace */
const googleapis_common_1 = require("googleapis-common");
var pubsublite_v1;
(function (pubsublite_v1) {
    /**
     * Pub/Sub Lite API
     *
     *
     *
     * @example
     * ```js
     * const {google} = require('googleapis');
     * const pubsublite = google.pubsublite('v1');
     * ```
     */
    class Pubsublite {
        constructor(options, google) {
            this.context = {
                _options: options || {},
                google,
            };
            this.admin = new Resource$Admin(this.context);
            this.cursor = new Resource$Cursor(this.context);
            this.topicStats = new Resource$Topicstats(this.context);
        }
    }
    pubsublite_v1.Pubsublite = Pubsublite;
    class Resource$Admin {
        constructor(context) {
            this.context = context;
            this.projects = new Resource$Admin$Projects(this.context);
        }
    }
    pubsublite_v1.Resource$Admin = Resource$Admin;
    class Resource$Admin$Projects {
        constructor(context) {
            this.context = context;
            this.locations = new Resource$Admin$Projects$Locations(this.context);
        }
    }
    pubsublite_v1.Resource$Admin$Projects = Resource$Admin$Projects;
    class Resource$Admin$Projects$Locations {
        constructor(context) {
            this.context = context;
            this.subscriptions = new Resource$Admin$Projects$Locations$Subscriptions(this.context);
            this.topics = new Resource$Admin$Projects$Locations$Topics(this.context);
        }
    }
    pubsublite_v1.Resource$Admin$Projects$Locations = Resource$Admin$Projects$Locations;
    class Resource$Admin$Projects$Locations$Subscriptions {
        constructor(context) {
            this.context = context;
        }
        create(paramsOrCallback, optionsOrCallback, callback) {
            let params = (paramsOrCallback ||
                {});
            let options = (optionsOrCallback || {});
            if (typeof paramsOrCallback === 'function') {
                callback = paramsOrCallback;
                params =
                    {};
                options = {};
            }
            if (typeof optionsOrCallback === 'function') {
                callback = optionsOrCallback;
                options = {};
            }
            const rootUrl = options.rootUrl || 'https://pubsublite.googleapis.com/';
            const parameters = {
                options: Object.assign({
                    url: (rootUrl + '/v1/admin/{+parent}/subscriptions').replace(/([^:]\/)\/+/g, '$1'),
                    method: 'POST',
                }, options),
                params,
                requiredParams: ['parent'],
                pathParams: ['parent'],
                context: this.context,
            };
            if (callback) {
                googleapis_common_1.createAPIRequest(parameters, callback);
            }
            else {
                return googleapis_common_1.createAPIRequest(parameters);
            }
        }
        delete(paramsOrCallback, optionsOrCallback, callback) {
            let params = (paramsOrCallback ||
                {});
            let options = (optionsOrCallback || {});
            if (typeof paramsOrCallback === 'function') {
                callback = paramsOrCallback;
                params =
                    {};
                options = {};
            }
            if (typeof optionsOrCallback === 'function') {
                callback = optionsOrCallback;
                options = {};
            }
            const rootUrl = options.rootUrl || 'https://pubsublite.googleapis.com/';
            const parameters = {
                options: Object.assign({
                    url: (rootUrl + '/v1/admin/{+name}').replace(/([^:]\/)\/+/g, '$1'),
                    method: 'DELETE',
                }, options),
                params,
                requiredParams: ['name'],
                pathParams: ['name'],
                context: this.context,
            };
            if (callback) {
                googleapis_common_1.createAPIRequest(parameters, callback);
            }
            else {
                return googleapis_common_1.createAPIRequest(parameters);
            }
        }
        get(paramsOrCallback, optionsOrCallback, callback) {
            let params = (paramsOrCallback ||
                {});
            let options = (optionsOrCallback || {});
            if (typeof paramsOrCallback === 'function') {
                callback = paramsOrCallback;
                params =
                    {};
                options = {};
            }
            if (typeof optionsOrCallback === 'function') {
                callback = optionsOrCallback;
                options = {};
            }
            const rootUrl = options.rootUrl || 'https://pubsublite.googleapis.com/';
            const parameters = {
                options: Object.assign({
                    url: (rootUrl + '/v1/admin/{+name}').replace(/([^:]\/)\/+/g, '$1'),
                    method: 'GET',
                }, options),
                params,
                requiredParams: ['name'],
                pathParams: ['name'],
                context: this.context,
            };
            if (callback) {
                googleapis_common_1.createAPIRequest(parameters, callback);
            }
            else {
                return googleapis_common_1.createAPIRequest(parameters);
            }
        }
        list(paramsOrCallback, optionsOrCallback, callback) {
            let params = (paramsOrCallback ||
                {});
            let options = (optionsOrCallback || {});
            if (typeof paramsOrCallback === 'function') {
                callback = paramsOrCallback;
                params =
                    {};
                options = {};
            }
            if (typeof optionsOrCallback === 'function') {
                callback = optionsOrCallback;
                options = {};
            }
            const rootUrl = options.rootUrl || 'https://pubsublite.googleapis.com/';
            const parameters = {
                options: Object.assign({
                    url: (rootUrl + '/v1/admin/{+parent}/subscriptions').replace(/([^:]\/)\/+/g, '$1'),
                    method: 'GET',
                }, options),
                params,
                requiredParams: ['parent'],
                pathParams: ['parent'],
                context: this.context,
            };
            if (callback) {
                googleapis_common_1.createAPIRequest(parameters, callback);
            }
            else {
                return googleapis_common_1.createAPIRequest(parameters);
            }
        }
        patch(paramsOrCallback, optionsOrCallback, callback) {
            let params = (paramsOrCallback ||
                {});
            let options = (optionsOrCallback || {});
            if (typeof paramsOrCallback === 'function') {
                callback = paramsOrCallback;
                params =
                    {};
                options = {};
            }
            if (typeof optionsOrCallback === 'function') {
                callback = optionsOrCallback;
                options = {};
            }
            const rootUrl = options.rootUrl || 'https://pubsublite.googleapis.com/';
            const parameters = {
                options: Object.assign({
                    url: (rootUrl + '/v1/admin/{+name}').replace(/([^:]\/)\/+/g, '$1'),
                    method: 'PATCH',
                }, options),
                params,
                requiredParams: ['name'],
                pathParams: ['name'],
                context: this.context,
            };
            if (callback) {
                googleapis_common_1.createAPIRequest(parameters, callback);
            }
            else {
                return googleapis_common_1.createAPIRequest(parameters);
            }
        }
    }
    pubsublite_v1.Resource$Admin$Projects$Locations$Subscriptions = Resource$Admin$Projects$Locations$Subscriptions;
    class Resource$Admin$Projects$Locations$Topics {
        constructor(context) {
            this.context = context;
            this.subscriptions =
                new Resource$Admin$Projects$Locations$Topics$Subscriptions(this.context);
        }
        create(paramsOrCallback, optionsOrCallback, callback) {
            let params = (paramsOrCallback ||
                {});
            let options = (optionsOrCallback || {});
            if (typeof paramsOrCallback === 'function') {
                callback = paramsOrCallback;
                params = {};
                options = {};
            }
            if (typeof optionsOrCallback === 'function') {
                callback = optionsOrCallback;
                options = {};
            }
            const rootUrl = options.rootUrl || 'https://pubsublite.googleapis.com/';
            const parameters = {
                options: Object.assign({
                    url: (rootUrl + '/v1/admin/{+parent}/topics').replace(/([^:]\/)\/+/g, '$1'),
                    method: 'POST',
                }, options),
                params,
                requiredParams: ['parent'],
                pathParams: ['parent'],
                context: this.context,
            };
            if (callback) {
                googleapis_common_1.createAPIRequest(parameters, callback);
            }
            else {
                return googleapis_common_1.createAPIRequest(parameters);
            }
        }
        delete(paramsOrCallback, optionsOrCallback, callback) {
            let params = (paramsOrCallback ||
                {});
            let options = (optionsOrCallback || {});
            if (typeof paramsOrCallback === 'function') {
                callback = paramsOrCallback;
                params = {};
                options = {};
            }
            if (typeof optionsOrCallback === 'function') {
                callback = optionsOrCallback;
                options = {};
            }
            const rootUrl = options.rootUrl || 'https://pubsublite.googleapis.com/';
            const parameters = {
                options: Object.assign({
                    url: (rootUrl + '/v1/admin/{+name}').replace(/([^:]\/)\/+/g, '$1'),
                    method: 'DELETE',
                }, options),
                params,
                requiredParams: ['name'],
                pathParams: ['name'],
                context: this.context,
            };
            if (callback) {
                googleapis_common_1.createAPIRequest(parameters, callback);
            }
            else {
                return googleapis_common_1.createAPIRequest(parameters);
            }
        }
        get(paramsOrCallback, optionsOrCallback, callback) {
            let params = (paramsOrCallback ||
                {});
            let options = (optionsOrCallback || {});
            if (typeof paramsOrCallback === 'function') {
                callback = paramsOrCallback;
                params = {};
                options = {};
            }
            if (typeof optionsOrCallback === 'function') {
                callback = optionsOrCallback;
                options = {};
            }
            const rootUrl = options.rootUrl || 'https://pubsublite.googleapis.com/';
            const parameters = {
                options: Object.assign({
                    url: (rootUrl + '/v1/admin/{+name}').replace(/([^:]\/)\/+/g, '$1'),
                    method: 'GET',
                }, options),
                params,
                requiredParams: ['name'],
                pathParams: ['name'],
                context: this.context,
            };
            if (callback) {
                googleapis_common_1.createAPIRequest(parameters, callback);
            }
            else {
                return googleapis_common_1.createAPIRequest(parameters);
            }
        }
        getPartitions(paramsOrCallback, optionsOrCallback, callback) {
            let params = (paramsOrCallback ||
                {});
            let options = (optionsOrCallback || {});
            if (typeof paramsOrCallback === 'function') {
                callback = paramsOrCallback;
                params =
                    {};
                options = {};
            }
            if (typeof optionsOrCallback === 'function') {
                callback = optionsOrCallback;
                options = {};
            }
            const rootUrl = options.rootUrl || 'https://pubsublite.googleapis.com/';
            const parameters = {
                options: Object.assign({
                    url: (rootUrl + '/v1/admin/{+name}/partitions').replace(/([^:]\/)\/+/g, '$1'),
                    method: 'GET',
                }, options),
                params,
                requiredParams: ['name'],
                pathParams: ['name'],
                context: this.context,
            };
            if (callback) {
                googleapis_common_1.createAPIRequest(parameters, callback);
            }
            else {
                return googleapis_common_1.createAPIRequest(parameters);
            }
        }
        list(paramsOrCallback, optionsOrCallback, callback) {
            let params = (paramsOrCallback ||
                {});
            let options = (optionsOrCallback || {});
            if (typeof paramsOrCallback === 'function') {
                callback = paramsOrCallback;
                params = {};
                options = {};
            }
            if (typeof optionsOrCallback === 'function') {
                callback = optionsOrCallback;
                options = {};
            }
            const rootUrl = options.rootUrl || 'https://pubsublite.googleapis.com/';
            const parameters = {
                options: Object.assign({
                    url: (rootUrl + '/v1/admin/{+parent}/topics').replace(/([^:]\/)\/+/g, '$1'),
                    method: 'GET',
                }, options),
                params,
                requiredParams: ['parent'],
                pathParams: ['parent'],
                context: this.context,
            };
            if (callback) {
                googleapis_common_1.createAPIRequest(parameters, callback);
            }
            else {
                return googleapis_common_1.createAPIRequest(parameters);
            }
        }
        patch(paramsOrCallback, optionsOrCallback, callback) {
            let params = (paramsOrCallback ||
                {});
            let options = (optionsOrCallback || {});
            if (typeof paramsOrCallback === 'function') {
                callback = paramsOrCallback;
                params = {};
                options = {};
            }
            if (typeof optionsOrCallback === 'function') {
                callback = optionsOrCallback;
                options = {};
            }
            const rootUrl = options.rootUrl || 'https://pubsublite.googleapis.com/';
            const parameters = {
                options: Object.assign({
                    url: (rootUrl + '/v1/admin/{+name}').replace(/([^:]\/)\/+/g, '$1'),
                    method: 'PATCH',
                }, options),
                params,
                requiredParams: ['name'],
                pathParams: ['name'],
                context: this.context,
            };
            if (callback) {
                googleapis_common_1.createAPIRequest(parameters, callback);
            }
            else {
                return googleapis_common_1.createAPIRequest(parameters);
            }
        }
    }
    pubsublite_v1.Resource$Admin$Projects$Locations$Topics = Resource$Admin$Projects$Locations$Topics;
    class Resource$Admin$Projects$Locations$Topics$Subscriptions {
        constructor(context) {
            this.context = context;
        }
        list(paramsOrCallback, optionsOrCallback, callback) {
            let params = (paramsOrCallback ||
                {});
            let options = (optionsOrCallback || {});
            if (typeof paramsOrCallback === 'function') {
                callback = paramsOrCallback;
                params =
                    {};
                options = {};
            }
            if (typeof optionsOrCallback === 'function') {
                callback = optionsOrCallback;
                options = {};
            }
            const rootUrl = options.rootUrl || 'https://pubsublite.googleapis.com/';
            const parameters = {
                options: Object.assign({
                    url: (rootUrl + '/v1/admin/{+name}/subscriptions').replace(/([^:]\/)\/+/g, '$1'),
                    method: 'GET',
                }, options),
                params,
                requiredParams: ['name'],
                pathParams: ['name'],
                context: this.context,
            };
            if (callback) {
                googleapis_common_1.createAPIRequest(parameters, callback);
            }
            else {
                return googleapis_common_1.createAPIRequest(parameters);
            }
        }
    }
    pubsublite_v1.Resource$Admin$Projects$Locations$Topics$Subscriptions = Resource$Admin$Projects$Locations$Topics$Subscriptions;
    class Resource$Cursor {
        constructor(context) {
            this.context = context;
            this.projects = new Resource$Cursor$Projects(this.context);
        }
    }
    pubsublite_v1.Resource$Cursor = Resource$Cursor;
    class Resource$Cursor$Projects {
        constructor(context) {
            this.context = context;
            this.locations = new Resource$Cursor$Projects$Locations(this.context);
        }
    }
    pubsublite_v1.Resource$Cursor$Projects = Resource$Cursor$Projects;
    class Resource$Cursor$Projects$Locations {
        constructor(context) {
            this.context = context;
            this.subscriptions = new Resource$Cursor$Projects$Locations$Subscriptions(this.context);
        }
    }
    pubsublite_v1.Resource$Cursor$Projects$Locations = Resource$Cursor$Projects$Locations;
    class Resource$Cursor$Projects$Locations$Subscriptions {
        constructor(context) {
            this.context = context;
            this.cursors =
                new Resource$Cursor$Projects$Locations$Subscriptions$Cursors(this.context);
        }
        commitCursor(paramsOrCallback, optionsOrCallback, callback) {
            let params = (paramsOrCallback ||
                {});
            let options = (optionsOrCallback || {});
            if (typeof paramsOrCallback === 'function') {
                callback = paramsOrCallback;
                params =
                    {};
                options = {};
            }
            if (typeof optionsOrCallback === 'function') {
                callback = optionsOrCallback;
                options = {};
            }
            const rootUrl = options.rootUrl || 'https://pubsublite.googleapis.com/';
            const parameters = {
                options: Object.assign({
                    url: (rootUrl + '/v1/cursor/{+subscription}:commitCursor').replace(/([^:]\/)\/+/g, '$1'),
                    method: 'POST',
                }, options),
                params,
                requiredParams: ['subscription'],
                pathParams: ['subscription'],
                context: this.context,
            };
            if (callback) {
                googleapis_common_1.createAPIRequest(parameters, callback);
            }
            else {
                return googleapis_common_1.createAPIRequest(parameters);
            }
        }
    }
    pubsublite_v1.Resource$Cursor$Projects$Locations$Subscriptions = Resource$Cursor$Projects$Locations$Subscriptions;
    class Resource$Cursor$Projects$Locations$Subscriptions$Cursors {
        constructor(context) {
            this.context = context;
        }
        list(paramsOrCallback, optionsOrCallback, callback) {
            let params = (paramsOrCallback ||
                {});
            let options = (optionsOrCallback || {});
            if (typeof paramsOrCallback === 'function') {
                callback = paramsOrCallback;
                params =
                    {};
                options = {};
            }
            if (typeof optionsOrCallback === 'function') {
                callback = optionsOrCallback;
                options = {};
            }
            const rootUrl = options.rootUrl || 'https://pubsublite.googleapis.com/';
            const parameters = {
                options: Object.assign({
                    url: (rootUrl + '/v1/cursor/{+parent}/cursors').replace(/([^:]\/)\/+/g, '$1'),
                    method: 'GET',
                }, options),
                params,
                requiredParams: ['parent'],
                pathParams: ['parent'],
                context: this.context,
            };
            if (callback) {
                googleapis_common_1.createAPIRequest(parameters, callback);
            }
            else {
                return googleapis_common_1.createAPIRequest(parameters);
            }
        }
    }
    pubsublite_v1.Resource$Cursor$Projects$Locations$Subscriptions$Cursors = Resource$Cursor$Projects$Locations$Subscriptions$Cursors;
    class Resource$Topicstats {
        constructor(context) {
            this.context = context;
            this.projects = new Resource$Topicstats$Projects(this.context);
        }
    }
    pubsublite_v1.Resource$Topicstats = Resource$Topicstats;
    class Resource$Topicstats$Projects {
        constructor(context) {
            this.context = context;
            this.locations = new Resource$Topicstats$Projects$Locations(this.context);
        }
    }
    pubsublite_v1.Resource$Topicstats$Projects = Resource$Topicstats$Projects;
    class Resource$Topicstats$Projects$Locations {
        constructor(context) {
            this.context = context;
            this.topics = new Resource$Topicstats$Projects$Locations$Topics(this.context);
        }
    }
    pubsublite_v1.Resource$Topicstats$Projects$Locations = Resource$Topicstats$Projects$Locations;
    class Resource$Topicstats$Projects$Locations$Topics {
        constructor(context) {
            this.context = context;
        }
        computeHeadCursor(paramsOrCallback, optionsOrCallback, callback) {
            let params = (paramsOrCallback ||
                {});
            let options = (optionsOrCallback || {});
            if (typeof paramsOrCallback === 'function') {
                callback = paramsOrCallback;
                params =
                    {};
                options = {};
            }
            if (typeof optionsOrCallback === 'function') {
                callback = optionsOrCallback;
                options = {};
            }
            const rootUrl = options.rootUrl || 'https://pubsublite.googleapis.com/';
            const parameters = {
                options: Object.assign({
                    url: (rootUrl + '/v1/topicStats/{+topic}:computeHeadCursor').replace(/([^:]\/)\/+/g, '$1'),
                    method: 'POST',
                }, options),
                params,
                requiredParams: ['topic'],
                pathParams: ['topic'],
                context: this.context,
            };
            if (callback) {
                googleapis_common_1.createAPIRequest(parameters, callback);
            }
            else {
                return googleapis_common_1.createAPIRequest(parameters);
            }
        }
        computeMessageStats(paramsOrCallback, optionsOrCallback, callback) {
            let params = (paramsOrCallback ||
                {});
            let options = (optionsOrCallback || {});
            if (typeof paramsOrCallback === 'function') {
                callback = paramsOrCallback;
                params =
                    {};
                options = {};
            }
            if (typeof optionsOrCallback === 'function') {
                callback = optionsOrCallback;
                options = {};
            }
            const rootUrl = options.rootUrl || 'https://pubsublite.googleapis.com/';
            const parameters = {
                options: Object.assign({
                    url: (rootUrl + '/v1/topicStats/{+topic}:computeMessageStats').replace(/([^:]\/)\/+/g, '$1'),
                    method: 'POST',
                }, options),
                params,
                requiredParams: ['topic'],
                pathParams: ['topic'],
                context: this.context,
            };
            if (callback) {
                googleapis_common_1.createAPIRequest(parameters, callback);
            }
            else {
                return googleapis_common_1.createAPIRequest(parameters);
            }
        }
        computeTimeCursor(paramsOrCallback, optionsOrCallback, callback) {
            let params = (paramsOrCallback ||
                {});
            let options = (optionsOrCallback || {});
            if (typeof paramsOrCallback === 'function') {
                callback = paramsOrCallback;
                params =
                    {};
                options = {};
            }
            if (typeof optionsOrCallback === 'function') {
                callback = optionsOrCallback;
                options = {};
            }
            const rootUrl = options.rootUrl || 'https://pubsublite.googleapis.com/';
            const parameters = {
                options: Object.assign({
                    url: (rootUrl + '/v1/topicStats/{+topic}:computeTimeCursor').replace(/([^:]\/)\/+/g, '$1'),
                    method: 'POST',
                }, options),
                params,
                requiredParams: ['topic'],
                pathParams: ['topic'],
                context: this.context,
            };
            if (callback) {
                googleapis_common_1.createAPIRequest(parameters, callback);
            }
            else {
                return googleapis_common_1.createAPIRequest(parameters);
            }
        }
    }
    pubsublite_v1.Resource$Topicstats$Projects$Locations$Topics = Resource$Topicstats$Projects$Locations$Topics;
})(pubsublite_v1 = exports.pubsublite_v1 || (exports.pubsublite_v1 = {}));
