var calcMultiplier = require('../calcMultiplier')

// generated by v0.1.3
var multipliers = {
    kib: 1,
    mib: 0.0009765625,
    gib: 9.5367431640625e-7,
    tib: 9.313225746154785e-10,
    pib: 9.094947017729282e-13,
    eib: 8.881784197001252e-16,
    zib: 8.673617379884035e-19,
    yib: 8.470329472543003e-22,
    kb: 1.024,
    mb: 0.001024,
    gb: 0.000001024,
    tb: 1.024e-9,
    pb: 1.024e-12,
    eb: 1.024e-15,
    zb: 1.024e-18,
    yb: 1.0240000000000001e-21,
}

Object.keys(multipliers).forEach(function(prefixMultiplier) {
    it("should return multiplier for '" + prefixMultiplier + "'", function() {
        expect(calcMultiplier(prefixMultiplier)).toBe(multipliers[prefixMultiplier])
    })
})
