/*
Copyright 2019 Openstorage.org

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	corev1 "github.com/libopenstorage/operator/pkg/apis/core/v1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeStorageNodes implements StorageNodeInterface
type FakeStorageNodes struct {
	Fake *FakeCoreV1
	ns   string
}

var storagenodesResource = schema.GroupVersionResource{Group: "core.libopenstorage.org", Version: "v1", Resource: "storagenodes"}

var storagenodesKind = schema.GroupVersionKind{Group: "core.libopenstorage.org", Version: "v1", Kind: "StorageNode"}

// Get takes name of the storageNode, and returns the corresponding storageNode object, and an error if there is any.
func (c *FakeStorageNodes) Get(name string, options v1.GetOptions) (result *corev1.StorageNode, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(storagenodesResource, c.ns, name), &corev1.StorageNode{})

	if obj == nil {
		return nil, err
	}
	return obj.(*corev1.StorageNode), err
}

// List takes label and field selectors, and returns the list of StorageNodes that match those selectors.
func (c *FakeStorageNodes) List(opts v1.ListOptions) (result *corev1.StorageNodeList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(storagenodesResource, storagenodesKind, c.ns, opts), &corev1.StorageNodeList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &corev1.StorageNodeList{ListMeta: obj.(*corev1.StorageNodeList).ListMeta}
	for _, item := range obj.(*corev1.StorageNodeList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested storageNodes.
func (c *FakeStorageNodes) Watch(opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(storagenodesResource, c.ns, opts))

}

// Create takes the representation of a storageNode and creates it.  Returns the server's representation of the storageNode, and an error, if there is any.
func (c *FakeStorageNodes) Create(storageNode *corev1.StorageNode) (result *corev1.StorageNode, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(storagenodesResource, c.ns, storageNode), &corev1.StorageNode{})

	if obj == nil {
		return nil, err
	}
	return obj.(*corev1.StorageNode), err
}

// Update takes the representation of a storageNode and updates it. Returns the server's representation of the storageNode, and an error, if there is any.
func (c *FakeStorageNodes) Update(storageNode *corev1.StorageNode) (result *corev1.StorageNode, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(storagenodesResource, c.ns, storageNode), &corev1.StorageNode{})

	if obj == nil {
		return nil, err
	}
	return obj.(*corev1.StorageNode), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeStorageNodes) UpdateStatus(storageNode *corev1.StorageNode) (*corev1.StorageNode, error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateSubresourceAction(storagenodesResource, "status", c.ns, storageNode), &corev1.StorageNode{})

	if obj == nil {
		return nil, err
	}
	return obj.(*corev1.StorageNode), err
}

// Delete takes name of the storageNode and deletes it. Returns an error if one occurs.
func (c *FakeStorageNodes) Delete(name string, options *v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteAction(storagenodesResource, c.ns, name), &corev1.StorageNode{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeStorageNodes) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(storagenodesResource, c.ns, listOptions)

	_, err := c.Fake.Invokes(action, &corev1.StorageNodeList{})
	return err
}

// Patch applies the patch and returns the patched storageNode.
func (c *FakeStorageNodes) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *corev1.StorageNode, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(storagenodesResource, c.ns, name, pt, data, subresources...), &corev1.StorageNode{})

	if obj == nil {
		return nil, err
	}
	return obj.(*corev1.StorageNode), err
}
