/*
Copyright 2019 Openstorage.org

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"time"

	v1 "github.com/libopenstorage/operator/pkg/apis/core/v1"
	scheme "github.com/libopenstorage/operator/pkg/client/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// StorageClustersGetter has a method to return a StorageClusterInterface.
// A group's client should implement this interface.
type StorageClustersGetter interface {
	StorageClusters(namespace string) StorageClusterInterface
}

// StorageClusterInterface has methods to work with StorageCluster resources.
type StorageClusterInterface interface {
	Create(*v1.StorageCluster) (*v1.StorageCluster, error)
	Update(*v1.StorageCluster) (*v1.StorageCluster, error)
	UpdateStatus(*v1.StorageCluster) (*v1.StorageCluster, error)
	Delete(name string, options *metav1.DeleteOptions) error
	DeleteCollection(options *metav1.DeleteOptions, listOptions metav1.ListOptions) error
	Get(name string, options metav1.GetOptions) (*v1.StorageCluster, error)
	List(opts metav1.ListOptions) (*v1.StorageClusterList, error)
	Watch(opts metav1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1.StorageCluster, err error)
	StorageClusterExpansion
}

// storageClusters implements StorageClusterInterface
type storageClusters struct {
	client rest.Interface
	ns     string
}

// newStorageClusters returns a StorageClusters
func newStorageClusters(c *CoreV1Client, namespace string) *storageClusters {
	return &storageClusters{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the storageCluster, and returns the corresponding storageCluster object, and an error if there is any.
func (c *storageClusters) Get(name string, options metav1.GetOptions) (result *v1.StorageCluster, err error) {
	result = &v1.StorageCluster{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("storageclusters").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of StorageClusters that match those selectors.
func (c *storageClusters) List(opts metav1.ListOptions) (result *v1.StorageClusterList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.StorageClusterList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("storageclusters").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do().
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested storageClusters.
func (c *storageClusters) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("storageclusters").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch()
}

// Create takes the representation of a storageCluster and creates it.  Returns the server's representation of the storageCluster, and an error, if there is any.
func (c *storageClusters) Create(storageCluster *v1.StorageCluster) (result *v1.StorageCluster, err error) {
	result = &v1.StorageCluster{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("storageclusters").
		Body(storageCluster).
		Do().
		Into(result)
	return
}

// Update takes the representation of a storageCluster and updates it. Returns the server's representation of the storageCluster, and an error, if there is any.
func (c *storageClusters) Update(storageCluster *v1.StorageCluster) (result *v1.StorageCluster, err error) {
	result = &v1.StorageCluster{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("storageclusters").
		Name(storageCluster.Name).
		Body(storageCluster).
		Do().
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().

func (c *storageClusters) UpdateStatus(storageCluster *v1.StorageCluster) (result *v1.StorageCluster, err error) {
	result = &v1.StorageCluster{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("storageclusters").
		Name(storageCluster.Name).
		SubResource("status").
		Body(storageCluster).
		Do().
		Into(result)
	return
}

// Delete takes name of the storageCluster and deletes it. Returns an error if one occurs.
func (c *storageClusters) Delete(name string, options *metav1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("storageclusters").
		Name(name).
		Body(options).
		Do().
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *storageClusters) DeleteCollection(options *metav1.DeleteOptions, listOptions metav1.ListOptions) error {
	var timeout time.Duration
	if listOptions.TimeoutSeconds != nil {
		timeout = time.Duration(*listOptions.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("storageclusters").
		VersionedParams(&listOptions, scheme.ParameterCodec).
		Timeout(timeout).
		Body(options).
		Do().
		Error()
}

// Patch applies the patch and returns the patched storageCluster.
func (c *storageClusters) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1.StorageCluster, err error) {
	result = &v1.StorageCluster{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("storageclusters").
		SubResource(subresources...).
		Name(name).
		Body(data).
		Do().
		Into(result)
	return
}
