// Code generated by protoc-gen-go. DO NOT EDIT.
// source: helper/identity/types.proto

package identity

import (
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	mfa "github.com/hashicorp/vault/helper/identity/mfa"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Group represents an identity group.
type Group struct {
	// ID is the unique identifier for this group
	ID string `sentinel:"" protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Name is the unique name for this group
	Name string `sentinel:"" protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Policies are the vault policies to be granted to members of this group
	Policies []string `sentinel:"" protobuf:"bytes,3,rep,name=policies,proto3" json:"policies,omitempty"`
	// ParentGroupIDs are the identifiers of those groups to which this group is a
	// member of. These will serve as references to the parent group in the
	// hierarchy.
	ParentGroupIDs []string `sentinel:"" protobuf:"bytes,4,rep,name=parent_group_ids,json=parentGroupIds,proto3" json:"parent_group_ids,omitempty"`
	// MemberEntityIDs are the identifiers of entities which are members of this
	// group
	MemberEntityIDs []string `sentinel:"" protobuf:"bytes,5,rep,name=member_entity_ids,json=memberEntityIDs,proto3" json:"member_entity_ids,omitempty"`
	// Metadata represents the custom data tied with this group
	Metadata map[string]string `sentinel:"" protobuf:"bytes,6,rep,name=metadata,proto3" json:"metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// CreationTime is the time at which this group was created
	CreationTime *timestamp.Timestamp `sentinel:"" protobuf:"bytes,7,opt,name=creation_time,json=creationTime,proto3" json:"creation_time,omitempty"`
	// LastUpdateTime is the time at which this group was last modified
	LastUpdateTime *timestamp.Timestamp `sentinel:"" protobuf:"bytes,8,opt,name=last_update_time,json=lastUpdateTime,proto3" json:"last_update_time,omitempty"`
	// ModifyIndex tracks the number of updates to the group. It is useful to detect
	// updates to the groups.
	ModifyIndex uint64 `sentinel:"" protobuf:"varint,9,opt,name=modify_index,json=modifyIndex,proto3" json:"modify_index,omitempty"`
	// BucketKey is the path of the storage packer key into which this group is
	// stored.
	BucketKey string `sentinel:"" protobuf:"bytes,10,opt,name=bucket_key,json=bucketKey,proto3" json:"bucket_key,omitempty"`
	// Alias is used to mark this group as an internal mapping of a group that
	// is external to the identity store. Alias can only be set if the 'type'
	// is set to 'external'.
	Alias *Alias `sentinel:"" protobuf:"bytes,11,opt,name=alias,proto3" json:"alias,omitempty"`
	// Type indicates if this group is an internal group or an external group.
	// Memberships of the internal groups can be managed over the API whereas
	// the memberships on the external group --for which a corresponding alias
	// will be set-- will be managed automatically.
	Type string `sentinel:"" protobuf:"bytes,12,opt,name=type,proto3" json:"type,omitempty"`
	// NamespaceID is the identifier of the namespace to which this group
	// belongs to. Do not return this value over the API when reading the
	// group.
	NamespaceID          string   `sentinel:"" protobuf:"bytes,13,opt,name=namespace_id,json=namespaceID,proto3" json:"namespace_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Group) Reset()         { *m = Group{} }
func (m *Group) String() string { return proto.CompactTextString(m) }
func (*Group) ProtoMessage()    {}
func (*Group) Descriptor() ([]byte, []int) {
	return fileDescriptor_319efdc71a5d7416, []int{0}
}

func (m *Group) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Group.Unmarshal(m, b)
}
func (m *Group) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Group.Marshal(b, m, deterministic)
}
func (m *Group) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Group.Merge(m, src)
}
func (m *Group) XXX_Size() int {
	return xxx_messageInfo_Group.Size(m)
}
func (m *Group) XXX_DiscardUnknown() {
	xxx_messageInfo_Group.DiscardUnknown(m)
}

var xxx_messageInfo_Group proto.InternalMessageInfo

func (m *Group) GetID() string {
	if m != nil {
		return m.ID
	}
	return ""
}

func (m *Group) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Group) GetPolicies() []string {
	if m != nil {
		return m.Policies
	}
	return nil
}

func (m *Group) GetParentGroupIDs() []string {
	if m != nil {
		return m.ParentGroupIDs
	}
	return nil
}

func (m *Group) GetMemberEntityIDs() []string {
	if m != nil {
		return m.MemberEntityIDs
	}
	return nil
}

func (m *Group) GetMetadata() map[string]string {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *Group) GetCreationTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreationTime
	}
	return nil
}

func (m *Group) GetLastUpdateTime() *timestamp.Timestamp {
	if m != nil {
		return m.LastUpdateTime
	}
	return nil
}

func (m *Group) GetModifyIndex() uint64 {
	if m != nil {
		return m.ModifyIndex
	}
	return 0
}

func (m *Group) GetBucketKey() string {
	if m != nil {
		return m.BucketKey
	}
	return ""
}

func (m *Group) GetAlias() *Alias {
	if m != nil {
		return m.Alias
	}
	return nil
}

func (m *Group) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *Group) GetNamespaceID() string {
	if m != nil {
		return m.NamespaceID
	}
	return ""
}

// Entity represents an entity that gets persisted and indexed.
// Entity is fundamentally composed of zero or many aliases.
type Entity struct {
	// Aliases are the identities that this entity is made of. This can be
	// empty as well to favor being able to create the entity first and then
	// incrementally adding aliases.
	Aliases []*Alias `sentinel:"" protobuf:"bytes,1,rep,name=aliases,proto3" json:"aliases,omitempty"`
	// ID is the unique identifier of the entity which always be a UUID. This
	// should never be allowed to be updated.
	ID string `sentinel:"" protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
	// Name is a unique identifier of the entity which is intended to be
	// human-friendly. The default name might not be human friendly since it
	// gets suffixed by a UUID, but it can optionally be updated, unlike the ID
	// field.
	Name string `sentinel:"" protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// Metadata represents the explicit metadata which is set by the
	// clients.  This is useful to tie any information pertaining to the
	// aliases. This is a non-unique field of entity, meaning multiple
	// entities can have the same metadata set. Entities will be indexed based
	// on this explicit metadata. This enables virtual groupings of entities
	// based on its metadata.
	Metadata map[string]string `sentinel:"" protobuf:"bytes,4,rep,name=metadata,proto3" json:"metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// CreationTime is the time at which this entity is first created.
	CreationTime *timestamp.Timestamp `sentinel:"" protobuf:"bytes,5,opt,name=creation_time,json=creationTime,proto3" json:"creation_time,omitempty"`
	// LastUpdateTime is the most recent time at which the properties of this
	// entity got modified. This is helpful in filtering out entities based on
	// its age and to take action on them, if desired.
	LastUpdateTime *timestamp.Timestamp `sentinel:"" protobuf:"bytes,6,opt,name=last_update_time,json=lastUpdateTime,proto3" json:"last_update_time,omitempty"`
	// MergedEntityIDs are the entities which got merged to this one. Entities
	// will be indexed based on all the entities that got merged into it. This
	// helps to apply the actions on this entity on the tokens that are merged
	// to the merged entities. Merged entities will be deleted entirely and
	// this is the only trackable trail of its earlier presence.
	MergedEntityIDs []string `sentinel:"" protobuf:"bytes,7,rep,name=merged_entity_ids,json=mergedEntityIDs,proto3" json:"merged_entity_ids,omitempty"`
	// Policies the entity is entitled to
	Policies []string `sentinel:"" protobuf:"bytes,8,rep,name=policies,proto3" json:"policies,omitempty"`
	// BucketKey is the path of the storage packer key into which this entity is
	// stored.
	BucketKey string `sentinel:"" protobuf:"bytes,9,opt,name=bucket_key,json=bucketKey,proto3" json:"bucket_key,omitempty"`
	// MFASecrets holds the MFA secrets indexed by the identifier of the MFA
	// method configuration.
	MFASecrets map[string]*mfa.Secret `sentinel:"" protobuf:"bytes,10,rep,name=mfa_secrets,json=mfaSecrets,proto3" json:"mfa_secrets,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Disabled indicates whether tokens associated with the account should not
	// be able to be used
	Disabled bool `sentinel:"" protobuf:"varint,11,opt,name=disabled,proto3" json:"disabled,omitempty"`
	// NamespaceID is the identifier of the namespace to which this entity
	// belongs to. Do not return this value over the API when reading the
	// entity.
	NamespaceID          string   `sentinel:"" protobuf:"bytes,12,opt,name=namespace_id,json=namespaceID,proto3" json:"namespace_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Entity) Reset()         { *m = Entity{} }
func (m *Entity) String() string { return proto.CompactTextString(m) }
func (*Entity) ProtoMessage()    {}
func (*Entity) Descriptor() ([]byte, []int) {
	return fileDescriptor_319efdc71a5d7416, []int{1}
}

func (m *Entity) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Entity.Unmarshal(m, b)
}
func (m *Entity) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Entity.Marshal(b, m, deterministic)
}
func (m *Entity) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Entity.Merge(m, src)
}
func (m *Entity) XXX_Size() int {
	return xxx_messageInfo_Entity.Size(m)
}
func (m *Entity) XXX_DiscardUnknown() {
	xxx_messageInfo_Entity.DiscardUnknown(m)
}

var xxx_messageInfo_Entity proto.InternalMessageInfo

func (m *Entity) GetAliases() []*Alias {
	if m != nil {
		return m.Aliases
	}
	return nil
}

func (m *Entity) GetID() string {
	if m != nil {
		return m.ID
	}
	return ""
}

func (m *Entity) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Entity) GetMetadata() map[string]string {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *Entity) GetCreationTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreationTime
	}
	return nil
}

func (m *Entity) GetLastUpdateTime() *timestamp.Timestamp {
	if m != nil {
		return m.LastUpdateTime
	}
	return nil
}

func (m *Entity) GetMergedEntityIDs() []string {
	if m != nil {
		return m.MergedEntityIDs
	}
	return nil
}

func (m *Entity) GetPolicies() []string {
	if m != nil {
		return m.Policies
	}
	return nil
}

func (m *Entity) GetBucketKey() string {
	if m != nil {
		return m.BucketKey
	}
	return ""
}

func (m *Entity) GetMFASecrets() map[string]*mfa.Secret {
	if m != nil {
		return m.MFASecrets
	}
	return nil
}

func (m *Entity) GetDisabled() bool {
	if m != nil {
		return m.Disabled
	}
	return false
}

func (m *Entity) GetNamespaceID() string {
	if m != nil {
		return m.NamespaceID
	}
	return ""
}

// Alias represents the alias that gets stored inside of the
// entity object in storage and also represents in an in-memory index of an
// alias object.
type Alias struct {
	// ID is the unique identifier that represents this alias
	ID string `sentinel:"" protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// CanonicalID is the entity identifier to which this alias belongs to
	CanonicalID string `sentinel:"" protobuf:"bytes,2,opt,name=canonical_id,json=canonicalId,proto3" json:"canonical_id,omitempty"`
	// MountType is the backend mount's type to which this alias belongs to.
	// This enables categorically querying aliases of specific backend types.
	MountType string `sentinel:"" protobuf:"bytes,3,opt,name=mount_type,json=mountType,proto3" json:"mount_type,omitempty"`
	// MountAccessor is the backend mount's accessor to which this alias
	// belongs to.
	MountAccessor string `sentinel:"" protobuf:"bytes,4,opt,name=mount_accessor,json=mountAccessor,proto3" json:"mount_accessor,omitempty"`
	// MountPath is the backend mount's path to which the Maccessor belongs to. This
	// field is not used for any operational purposes. This is only returned when
	// alias is read, only as a nicety.
	MountPath string `sentinel:"" protobuf:"bytes,5,opt,name=mount_path,json=mountPath,proto3" json:"mount_path,omitempty"`
	// Metadata is the explicit metadata that clients set against an entity
	// which enables virtual grouping of aliases. Aliases will be indexed
	// against their metadata.
	Metadata map[string]string `sentinel:"" protobuf:"bytes,6,rep,name=metadata,proto3" json:"metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Name is the identifier of this alias in its authentication source.
	// This does not uniquely identify an alias in Vault. This in conjunction
	// with MountAccessor form to be the factors that represent an alias in a
	// unique way. Aliases will be indexed based on this combined uniqueness
	// factor.
	Name string `sentinel:"" protobuf:"bytes,7,opt,name=name,proto3" json:"name,omitempty"`
	// CreationTime is the time at which this alias was first created
	CreationTime *timestamp.Timestamp `sentinel:"" protobuf:"bytes,8,opt,name=creation_time,json=creationTime,proto3" json:"creation_time,omitempty"`
	// LastUpdateTime is the most recent time at which the properties of this
	// alias got modified. This is helpful in filtering out aliases based
	// on its age and to take action on them, if desired.
	LastUpdateTime *timestamp.Timestamp `sentinel:"" protobuf:"bytes,9,opt,name=last_update_time,json=lastUpdateTime,proto3" json:"last_update_time,omitempty"`
	// MergedFromCanonicalIDs is the FIFO history of merging activity
	MergedFromCanonicalIDs []string `sentinel:"" protobuf:"bytes,10,rep,name=merged_from_canonical_ids,json=mergedFromCanonicalIds,proto3" json:"merged_from_canonical_ids,omitempty"`
	// NamespaceID is the identifier of the namespace to which this alias
	// belongs.
	NamespaceID          string   `sentinel:"" protobuf:"bytes,11,opt,name=namespace_id,json=namespaceID,proto3" json:"namespace_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Alias) Reset()         { *m = Alias{} }
func (m *Alias) String() string { return proto.CompactTextString(m) }
func (*Alias) ProtoMessage()    {}
func (*Alias) Descriptor() ([]byte, []int) {
	return fileDescriptor_319efdc71a5d7416, []int{2}
}

func (m *Alias) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Alias.Unmarshal(m, b)
}
func (m *Alias) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Alias.Marshal(b, m, deterministic)
}
func (m *Alias) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Alias.Merge(m, src)
}
func (m *Alias) XXX_Size() int {
	return xxx_messageInfo_Alias.Size(m)
}
func (m *Alias) XXX_DiscardUnknown() {
	xxx_messageInfo_Alias.DiscardUnknown(m)
}

var xxx_messageInfo_Alias proto.InternalMessageInfo

func (m *Alias) GetID() string {
	if m != nil {
		return m.ID
	}
	return ""
}

func (m *Alias) GetCanonicalID() string {
	if m != nil {
		return m.CanonicalID
	}
	return ""
}

func (m *Alias) GetMountType() string {
	if m != nil {
		return m.MountType
	}
	return ""
}

func (m *Alias) GetMountAccessor() string {
	if m != nil {
		return m.MountAccessor
	}
	return ""
}

func (m *Alias) GetMountPath() string {
	if m != nil {
		return m.MountPath
	}
	return ""
}

func (m *Alias) GetMetadata() map[string]string {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *Alias) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Alias) GetCreationTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreationTime
	}
	return nil
}

func (m *Alias) GetLastUpdateTime() *timestamp.Timestamp {
	if m != nil {
		return m.LastUpdateTime
	}
	return nil
}

func (m *Alias) GetMergedFromCanonicalIDs() []string {
	if m != nil {
		return m.MergedFromCanonicalIDs
	}
	return nil
}

func (m *Alias) GetNamespaceID() string {
	if m != nil {
		return m.NamespaceID
	}
	return ""
}

// Deprecated. Retained for backwards compatibility.
type EntityStorageEntry struct {
	Personas             []*PersonaIndexEntry   `sentinel:"" protobuf:"bytes,1,rep,name=personas,proto3" json:"personas,omitempty"`
	ID                   string                 `sentinel:"" protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
	Name                 string                 `sentinel:"" protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	Metadata             map[string]string      `sentinel:"" protobuf:"bytes,4,rep,name=metadata,proto3" json:"metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	CreationTime         *timestamp.Timestamp   `sentinel:"" protobuf:"bytes,5,opt,name=creation_time,json=creationTime,proto3" json:"creation_time,omitempty"`
	LastUpdateTime       *timestamp.Timestamp   `sentinel:"" protobuf:"bytes,6,opt,name=last_update_time,json=lastUpdateTime,proto3" json:"last_update_time,omitempty"`
	MergedEntityIDs      []string               `sentinel:"" protobuf:"bytes,7,rep,name=merged_entity_ids,json=mergedEntityIDs,proto3" json:"merged_entity_ids,omitempty"`
	Policies             []string               `sentinel:"" protobuf:"bytes,8,rep,name=policies,proto3" json:"policies,omitempty"`
	BucketKeyHash        string                 `sentinel:"" protobuf:"bytes,9,opt,name=bucket_key_hash,json=bucketKeyHash,proto3" json:"bucket_key_hash,omitempty"`
	MFASecrets           map[string]*mfa.Secret `sentinel:"" protobuf:"bytes,10,rep,name=mfa_secrets,json=mfaSecrets,proto3" json:"mfa_secrets,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *EntityStorageEntry) Reset()         { *m = EntityStorageEntry{} }
func (m *EntityStorageEntry) String() string { return proto.CompactTextString(m) }
func (*EntityStorageEntry) ProtoMessage()    {}
func (*EntityStorageEntry) Descriptor() ([]byte, []int) {
	return fileDescriptor_319efdc71a5d7416, []int{3}
}

func (m *EntityStorageEntry) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EntityStorageEntry.Unmarshal(m, b)
}
func (m *EntityStorageEntry) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EntityStorageEntry.Marshal(b, m, deterministic)
}
func (m *EntityStorageEntry) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EntityStorageEntry.Merge(m, src)
}
func (m *EntityStorageEntry) XXX_Size() int {
	return xxx_messageInfo_EntityStorageEntry.Size(m)
}
func (m *EntityStorageEntry) XXX_DiscardUnknown() {
	xxx_messageInfo_EntityStorageEntry.DiscardUnknown(m)
}

var xxx_messageInfo_EntityStorageEntry proto.InternalMessageInfo

func (m *EntityStorageEntry) GetPersonas() []*PersonaIndexEntry {
	if m != nil {
		return m.Personas
	}
	return nil
}

func (m *EntityStorageEntry) GetID() string {
	if m != nil {
		return m.ID
	}
	return ""
}

func (m *EntityStorageEntry) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *EntityStorageEntry) GetMetadata() map[string]string {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *EntityStorageEntry) GetCreationTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreationTime
	}
	return nil
}

func (m *EntityStorageEntry) GetLastUpdateTime() *timestamp.Timestamp {
	if m != nil {
		return m.LastUpdateTime
	}
	return nil
}

func (m *EntityStorageEntry) GetMergedEntityIDs() []string {
	if m != nil {
		return m.MergedEntityIDs
	}
	return nil
}

func (m *EntityStorageEntry) GetPolicies() []string {
	if m != nil {
		return m.Policies
	}
	return nil
}

func (m *EntityStorageEntry) GetBucketKeyHash() string {
	if m != nil {
		return m.BucketKeyHash
	}
	return ""
}

func (m *EntityStorageEntry) GetMFASecrets() map[string]*mfa.Secret {
	if m != nil {
		return m.MFASecrets
	}
	return nil
}

// Deprecated. Retained for backwards compatibility.
type PersonaIndexEntry struct {
	ID                   string               `sentinel:"" protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	EntityID             string               `sentinel:"" protobuf:"bytes,2,opt,name=entity_id,json=entityId,proto3" json:"entity_id,omitempty"`
	MountType            string               `sentinel:"" protobuf:"bytes,3,opt,name=mount_type,json=mountType,proto3" json:"mount_type,omitempty"`
	MountAccessor        string               `sentinel:"" protobuf:"bytes,4,opt,name=mount_accessor,json=mountAccessor,proto3" json:"mount_accessor,omitempty"`
	MountPath            string               `sentinel:"" protobuf:"bytes,5,opt,name=mount_path,json=mountPath,proto3" json:"mount_path,omitempty"`
	Metadata             map[string]string    `sentinel:"" protobuf:"bytes,6,rep,name=metadata,proto3" json:"metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	Name                 string               `sentinel:"" protobuf:"bytes,7,opt,name=name,proto3" json:"name,omitempty"`
	CreationTime         *timestamp.Timestamp `sentinel:"" protobuf:"bytes,8,opt,name=creation_time,json=creationTime,proto3" json:"creation_time,omitempty"`
	LastUpdateTime       *timestamp.Timestamp `sentinel:"" protobuf:"bytes,9,opt,name=last_update_time,json=lastUpdateTime,proto3" json:"last_update_time,omitempty"`
	MergedFromEntityIDs  []string             `sentinel:"" protobuf:"bytes,10,rep,name=merged_from_entity_ids,json=mergedFromEntityIDs,proto3" json:"merged_from_entity_ids,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *PersonaIndexEntry) Reset()         { *m = PersonaIndexEntry{} }
func (m *PersonaIndexEntry) String() string { return proto.CompactTextString(m) }
func (*PersonaIndexEntry) ProtoMessage()    {}
func (*PersonaIndexEntry) Descriptor() ([]byte, []int) {
	return fileDescriptor_319efdc71a5d7416, []int{4}
}

func (m *PersonaIndexEntry) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PersonaIndexEntry.Unmarshal(m, b)
}
func (m *PersonaIndexEntry) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PersonaIndexEntry.Marshal(b, m, deterministic)
}
func (m *PersonaIndexEntry) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PersonaIndexEntry.Merge(m, src)
}
func (m *PersonaIndexEntry) XXX_Size() int {
	return xxx_messageInfo_PersonaIndexEntry.Size(m)
}
func (m *PersonaIndexEntry) XXX_DiscardUnknown() {
	xxx_messageInfo_PersonaIndexEntry.DiscardUnknown(m)
}

var xxx_messageInfo_PersonaIndexEntry proto.InternalMessageInfo

func (m *PersonaIndexEntry) GetID() string {
	if m != nil {
		return m.ID
	}
	return ""
}

func (m *PersonaIndexEntry) GetEntityID() string {
	if m != nil {
		return m.EntityID
	}
	return ""
}

func (m *PersonaIndexEntry) GetMountType() string {
	if m != nil {
		return m.MountType
	}
	return ""
}

func (m *PersonaIndexEntry) GetMountAccessor() string {
	if m != nil {
		return m.MountAccessor
	}
	return ""
}

func (m *PersonaIndexEntry) GetMountPath() string {
	if m != nil {
		return m.MountPath
	}
	return ""
}

func (m *PersonaIndexEntry) GetMetadata() map[string]string {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *PersonaIndexEntry) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *PersonaIndexEntry) GetCreationTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreationTime
	}
	return nil
}

func (m *PersonaIndexEntry) GetLastUpdateTime() *timestamp.Timestamp {
	if m != nil {
		return m.LastUpdateTime
	}
	return nil
}

func (m *PersonaIndexEntry) GetMergedFromEntityIDs() []string {
	if m != nil {
		return m.MergedFromEntityIDs
	}
	return nil
}

func init() {
	proto.RegisterType((*Group)(nil), "identity.Group")
	proto.RegisterMapType((map[string]string)(nil), "identity.Group.MetadataEntry")
	proto.RegisterType((*Entity)(nil), "identity.Entity")
	proto.RegisterMapType((map[string]string)(nil), "identity.Entity.MetadataEntry")
	proto.RegisterMapType((map[string]*mfa.Secret)(nil), "identity.Entity.MFASecretsEntry")
	proto.RegisterType((*Alias)(nil), "identity.Alias")
	proto.RegisterMapType((map[string]string)(nil), "identity.Alias.MetadataEntry")
	proto.RegisterType((*EntityStorageEntry)(nil), "identity.EntityStorageEntry")
	proto.RegisterMapType((map[string]string)(nil), "identity.EntityStorageEntry.MetadataEntry")
	proto.RegisterMapType((map[string]*mfa.Secret)(nil), "identity.EntityStorageEntry.MFASecretsEntry")
	proto.RegisterType((*PersonaIndexEntry)(nil), "identity.PersonaIndexEntry")
	proto.RegisterMapType((map[string]string)(nil), "identity.PersonaIndexEntry.MetadataEntry")
}

func init() { proto.RegisterFile("helper/identity/types.proto", fileDescriptor_319efdc71a5d7416) }

var fileDescriptor_319efdc71a5d7416 = []byte{
	// 867 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xe4, 0x56, 0x5d, 0x8f, 0xdb, 0x44,
	0x14, 0x55, 0x3e, 0x9c, 0xd8, 0xd7, 0xf9, 0xd8, 0x0e, 0xa8, 0x32, 0x59, 0x95, 0x66, 0x2b, 0x15,
	0xa5, 0xab, 0xca, 0x91, 0xb6, 0x0f, 0xd0, 0xf2, 0x80, 0x16, 0xd8, 0x42, 0x40, 0x95, 0x2a, 0xb7,
	0xbc, 0xf0, 0x62, 0x4d, 0xec, 0x49, 0x32, 0xaa, 0xed, 0xb1, 0x3c, 0xe3, 0x8a, 0xfc, 0x03, 0x1e,
	0x78, 0xe0, 0x07, 0xf1, 0xc7, 0x78, 0x43, 0x33, 0xe3, 0xaf, 0xc6, 0xed, 0xd2, 0x15, 0x11, 0x02,
	0xf5, 0xcd, 0x73, 0xee, 0x9d, 0x3b, 0x37, 0xe7, 0x9e, 0x7b, 0x14, 0x38, 0xdd, 0x91, 0x28, 0x25,
	0xd9, 0x92, 0x86, 0x24, 0x11, 0x54, 0xec, 0x97, 0x62, 0x9f, 0x12, 0xee, 0xa6, 0x19, 0x13, 0x0c,
	0x99, 0x25, 0x3a, 0xbb, 0xbb, 0x65, 0x6c, 0x1b, 0x91, 0xa5, 0xc2, 0xd7, 0xf9, 0x66, 0x29, 0x68,
	0x4c, 0xb8, 0xc0, 0x71, 0xaa, 0x53, 0x67, 0x77, 0x0f, 0xeb, 0xc4, 0x1b, 0xdc, 0xac, 0x75, 0xef,
	0x8f, 0x3e, 0x18, 0xdf, 0x65, 0x2c, 0x4f, 0xd1, 0x04, 0xba, 0x34, 0x74, 0x3a, 0xf3, 0xce, 0xc2,
	0xf2, 0xba, 0x34, 0x44, 0x08, 0xfa, 0x09, 0x8e, 0x89, 0xd3, 0x55, 0x88, 0xfa, 0x46, 0x33, 0x30,
	0x53, 0x16, 0xd1, 0x80, 0x12, 0xee, 0xf4, 0xe6, 0xbd, 0x85, 0xe5, 0x55, 0x67, 0xb4, 0x80, 0x93,
	0x14, 0x67, 0x24, 0x11, 0xfe, 0x56, 0xd6, 0xf3, 0x69, 0xc8, 0x9d, 0xbe, 0xca, 0x99, 0x68, 0x5c,
	0x3d, 0xb3, 0x0a, 0x39, 0x3a, 0x87, 0x5b, 0x31, 0x89, 0xd7, 0x24, 0xf3, 0x75, 0x53, 0x2a, 0xd5,
	0x50, 0xa9, 0x53, 0x1d, 0xb8, 0x52, 0xb8, 0xcc, 0x7d, 0x0c, 0x66, 0x4c, 0x04, 0x0e, 0xb1, 0xc0,
	0xce, 0x60, 0xde, 0x5b, 0xd8, 0x17, 0x77, 0xdc, 0xf2, 0xc7, 0xb8, 0xaa, 0xa2, 0xfb, 0xac, 0x88,
	0x5f, 0x25, 0x22, 0xdb, 0x7b, 0x55, 0x3a, 0xfa, 0x0a, 0xc6, 0x41, 0x46, 0xb0, 0xa0, 0x2c, 0xf1,
	0x25, 0x2f, 0xce, 0x70, 0xde, 0x59, 0xd8, 0x17, 0x33, 0x57, 0x93, 0xe6, 0x96, 0xa4, 0xb9, 0x2f,
	0x4b, 0xd2, 0xbc, 0x51, 0x79, 0x41, 0x42, 0xe8, 0x5b, 0x38, 0x89, 0x30, 0x17, 0x7e, 0x9e, 0x86,
	0x58, 0x10, 0x5d, 0xc3, 0xfc, 0xdb, 0x1a, 0x13, 0x79, 0xe7, 0x27, 0x75, 0x45, 0x55, 0x39, 0x83,
	0x51, 0xcc, 0x42, 0xba, 0xd9, 0xfb, 0x34, 0x09, 0xc9, 0x2f, 0x8e, 0x35, 0xef, 0x2c, 0xfa, 0x9e,
	0xad, 0xb1, 0x95, 0x84, 0xd0, 0x1d, 0x80, 0x75, 0x1e, 0xbc, 0x22, 0xc2, 0x7f, 0x45, 0xf6, 0x0e,
	0x28, 0xc2, 0x2d, 0x8d, 0xfc, 0x48, 0xf6, 0xe8, 0x3e, 0x18, 0x38, 0xa2, 0x98, 0x3b, 0xb6, 0x7a,
	0x7c, 0x5a, 0x13, 0x70, 0x29, 0x61, 0x4f, 0x47, 0xe5, 0xc0, 0xe4, 0x64, 0x9d, 0x91, 0x1e, 0x98,
	0xfc, 0x96, 0x8f, 0xcb, 0xc1, 0xf1, 0x14, 0x07, 0xc4, 0xa7, 0xa1, 0x33, 0x56, 0x31, 0xbb, 0xc2,
	0x56, 0xe1, 0xec, 0x4b, 0x18, 0xbf, 0xc1, 0x20, 0x3a, 0x81, 0x9e, 0x6c, 0x43, 0x2b, 0x41, 0x7e,
	0xa2, 0x8f, 0xc1, 0x78, 0x8d, 0xa3, 0xbc, 0xd4, 0x82, 0x3e, 0x3c, 0xe9, 0x7e, 0xd1, 0xb9, 0xf7,
	0x9b, 0x01, 0x03, 0x3d, 0x2c, 0xf4, 0x00, 0x86, 0xaa, 0x0f, 0xc2, 0x9d, 0x8e, 0x1a, 0x54, 0xab,
	0xcf, 0x32, 0x5e, 0x48, 0xad, 0xdb, 0x92, 0x5a, 0xaf, 0x21, 0xb5, 0x27, 0x8d, 0xc1, 0xf7, 0x55,
	0xbd, 0x4f, 0xeb, 0x7a, 0xfa, 0xc9, 0xf7, 0x9f, 0xbc, 0x71, 0x84, 0xc9, 0x0f, 0x6e, 0x3c, 0x79,
	0xa5, 0xf3, 0x6c, 0x4b, 0xc2, 0xa6, 0xce, 0x87, 0xa5, 0xce, 0x65, 0xa0, 0xd6, 0x79, 0x73, 0xb3,
	0xcc, 0x83, 0xcd, 0x7a, 0x53, 0x1e, 0xd6, 0xa1, 0x3c, 0x2e, 0xc1, 0x8e, 0x37, 0xd8, 0xe7, 0x24,
	0xc8, 0x88, 0xe0, 0x0e, 0x28, 0xb2, 0xe6, 0x6d, 0xb2, 0x36, 0xf8, 0x85, 0x4e, 0xd1, 0x74, 0x41,
	0x5c, 0x01, 0xf2, 0xf5, 0x90, 0x72, 0xbc, 0x8e, 0x48, 0xa8, 0x44, 0x66, 0x7a, 0xd5, 0xb9, 0x25,
	0xa1, 0xd1, 0x71, 0x25, 0x34, 0xfb, 0x01, 0xa6, 0x07, 0xad, 0xbd, 0xe5, 0xfa, 0x59, 0xf3, 0xba,
	0x7d, 0x61, 0xbb, 0xf1, 0x06, 0xbb, 0xfa, 0x4e, 0x53, 0x8e, 0xbf, 0xf7, 0xc1, 0x50, 0x5a, 0x6b,
	0xb9, 0xd9, 0x19, 0x8c, 0x02, 0x9c, 0xb0, 0x84, 0x06, 0x38, 0xf2, 0x2b, 0xf1, 0xd9, 0x15, 0xb6,
	0x0a, 0x25, 0xcd, 0x31, 0xcb, 0x13, 0xe1, 0xab, 0x2d, 0xd2, 0x5a, 0xb4, 0x14, 0xf2, 0x52, 0xae,
	0xd2, 0x7d, 0x98, 0xe8, 0x30, 0x0e, 0x02, 0xc2, 0x39, 0xcb, 0x9c, 0xbe, 0x4a, 0x19, 0x2b, 0xf4,
	0xb2, 0x00, 0xeb, 0x2a, 0x29, 0x16, 0x3b, 0x25, 0xbc, 0xb2, 0xca, 0x73, 0x2c, 0x76, 0xd7, 0xfb,
	0x99, 0x6a, 0xfd, 0x9d, 0xaa, 0x2e, 0xb7, 0x64, 0xd8, 0xd8, 0x92, 0x96, 0xd2, 0xcd, 0x23, 0x28,
	0xdd, 0xba, 0xb1, 0xd2, 0x1f, 0xc3, 0x27, 0x85, 0xd2, 0x37, 0x19, 0x8b, 0xfd, 0x26, 0xd3, 0x5a,
	0x90, 0x96, 0x77, 0x5b, 0x27, 0x3c, 0xcd, 0x58, 0xfc, 0x4d, 0x4d, 0x3a, 0x6f, 0xc9, 0xcb, 0x3e,
	0xb2, 0x43, 0xfd, 0x6a, 0x00, 0xd2, 0x1b, 0xf0, 0x42, 0xb0, 0x0c, 0x6f, 0x89, 0x2e, 0xf1, 0x39,
	0x98, 0x29, 0xc9, 0x38, 0x4b, 0x70, 0x69, 0x57, 0xa7, 0xf5, 0x1c, 0x9e, 0xeb, 0x88, 0x32, 0xe7,
	0x62, 0x0a, 0x65, 0xf2, 0x7b, 0x79, 0xd7, 0xd3, 0x96, 0x77, 0x9d, 0x1f, 0xae, 0x63, 0xb3, 0x99,
	0x0f, 0xc5, 0xc7, 0x3e, 0x83, 0x69, 0xed, 0x63, 0xfe, 0x0e, 0xf3, 0x5d, 0x61, 0x66, 0xe3, 0xca,
	0xcc, 0xbe, 0xc7, 0x7c, 0x87, 0x9e, 0xbd, 0xcd, 0xd0, 0x1e, 0x5e, 0xcf, 0xe0, 0xbb, 0xcd, 0xed,
	0xbf, 0xe3, 0x4e, 0x7f, 0xf6, 0xe0, 0x56, 0x4b, 0x5a, 0x2d, 0xa7, 0x3a, 0x05, 0xab, 0xa2, 0xb9,
	0xe8, 0xc7, 0x24, 0x05, 0xbf, 0xff, 0x8e, 0x47, 0x5d, 0xb5, 0x3c, 0xea, 0xc1, 0x35, 0xbb, 0xf1,
	0x7f, 0xf4, 0xab, 0x47, 0x70, 0xbb, 0xe9, 0x57, 0x0d, 0x59, 0x6b, 0xb3, 0xfa, 0xa8, 0x36, 0xab,
	0x4a, 0xda, 0xff, 0x48, 0x47, 0x5f, 0x3f, 0xfc, 0xf9, 0x7c, 0x4b, 0xc5, 0x2e, 0x5f, 0xbb, 0x01,
	0x8b, 0x97, 0x52, 0xfb, 0x34, 0x60, 0x59, 0xba, 0x7c, 0x8d, 0xf3, 0x48, 0x2c, 0x0f, 0xfe, 0xa5,
	0xaf, 0x07, 0xea, 0x37, 0x3c, 0xfa, 0x2b, 0x00, 0x00, 0xff, 0xff, 0x54, 0x4e, 0x98, 0x4a, 0x07,
	0x0c, 0x00, 0x00,
}
