package dom

// Code generated by cdproto-gen. DO NOT EDIT.

import (
	"github.com/mailru/easyjson"
)

// Quad an array of quad vertices, x immediately followed by y for each
// point, points clock-wise.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/DOM#type-Quad
type Quad []float64

// BoxModel box model.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/DOM#type-BoxModel
type BoxModel struct {
	Content      Quad              `json:"content"`                // Content box
	Padding      Quad              `json:"padding"`                // Padding box
	Border       Quad              `json:"border"`                 // Border box
	Margin       Quad              `json:"margin"`                 // Margin box
	Width        int64             `json:"width"`                  // Node width
	Height       int64             `json:"height"`                 // Node height
	ShapeOutside *ShapeOutsideInfo `json:"shapeOutside,omitempty"` // Shape outside coordinates
}

// ShapeOutsideInfo CSS Shape Outside details.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/DOM#type-ShapeOutsideInfo
type ShapeOutsideInfo struct {
	Bounds      Quad                  `json:"bounds"`      // Shape bounds
	Shape       []easyjson.RawMessage `json:"shape"`       // Shape coordinate details
	MarginShape []easyjson.RawMessage `json:"marginShape"` // Margin shape bounds
}

// Rect Rectangle.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/DOM#type-Rect
type Rect struct {
	X      float64 `json:"x"`      // X coordinate
	Y      float64 `json:"y"`      // Y coordinate
	Width  float64 `json:"width"`  // Rectangle width
	Height float64 `json:"height"` // Rectangle height
}
