/*
Copyright 2019 Openstorage.org

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	v1alpha1 "github.com/libopenstorage/autopilot-api/pkg/apis/autopilot/v1alpha1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeAutopilotRules implements AutopilotRuleInterface
type FakeAutopilotRules struct {
	Fake *FakeAutopilotV1alpha1
}

var autopilotrulesResource = schema.GroupVersionResource{Group: "autopilot.libopenstorage.org", Version: "v1alpha1", Resource: "autopilotrules"}

var autopilotrulesKind = schema.GroupVersionKind{Group: "autopilot.libopenstorage.org", Version: "v1alpha1", Kind: "AutopilotRule"}

// Get takes name of the autopilotRule, and returns the corresponding autopilotRule object, and an error if there is any.
func (c *FakeAutopilotRules) Get(name string, options v1.GetOptions) (result *v1alpha1.AutopilotRule, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootGetAction(autopilotrulesResource, name), &v1alpha1.AutopilotRule{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.AutopilotRule), err
}

// List takes label and field selectors, and returns the list of AutopilotRules that match those selectors.
func (c *FakeAutopilotRules) List(opts v1.ListOptions) (result *v1alpha1.AutopilotRuleList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootListAction(autopilotrulesResource, autopilotrulesKind, opts), &v1alpha1.AutopilotRuleList{})
	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1alpha1.AutopilotRuleList{ListMeta: obj.(*v1alpha1.AutopilotRuleList).ListMeta}
	for _, item := range obj.(*v1alpha1.AutopilotRuleList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested autopilotRules.
func (c *FakeAutopilotRules) Watch(opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewRootWatchAction(autopilotrulesResource, opts))
}

// Create takes the representation of a autopilotRule and creates it.  Returns the server's representation of the autopilotRule, and an error, if there is any.
func (c *FakeAutopilotRules) Create(autopilotRule *v1alpha1.AutopilotRule) (result *v1alpha1.AutopilotRule, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootCreateAction(autopilotrulesResource, autopilotRule), &v1alpha1.AutopilotRule{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.AutopilotRule), err
}

// Update takes the representation of a autopilotRule and updates it. Returns the server's representation of the autopilotRule, and an error, if there is any.
func (c *FakeAutopilotRules) Update(autopilotRule *v1alpha1.AutopilotRule) (result *v1alpha1.AutopilotRule, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootUpdateAction(autopilotrulesResource, autopilotRule), &v1alpha1.AutopilotRule{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.AutopilotRule), err
}

// Delete takes name of the autopilotRule and deletes it. Returns an error if one occurs.
func (c *FakeAutopilotRules) Delete(name string, options *v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewRootDeleteAction(autopilotrulesResource, name), &v1alpha1.AutopilotRule{})
	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeAutopilotRules) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	action := testing.NewRootDeleteCollectionAction(autopilotrulesResource, listOptions)

	_, err := c.Fake.Invokes(action, &v1alpha1.AutopilotRuleList{})
	return err
}

// Patch applies the patch and returns the patched autopilotRule.
func (c *FakeAutopilotRules) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha1.AutopilotRule, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootPatchSubresourceAction(autopilotrulesResource, name, pt, data, subresources...), &v1alpha1.AutopilotRule{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.AutopilotRule), err
}
