/*
Copyright 2019 Openstorage.org

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by informer-gen. DO NOT EDIT.

package v1alpha1

import (
	time "time"

	autopilotv1alpha1 "github.com/libopenstorage/autopilot-api/pkg/apis/autopilot/v1alpha1"
	versioned "github.com/libopenstorage/autopilot-api/pkg/client/clientset/versioned"
	internalinterfaces "github.com/libopenstorage/autopilot-api/pkg/client/informers/externalversions/internalinterfaces"
	v1alpha1 "github.com/libopenstorage/autopilot-api/pkg/client/listers/autopilot/v1alpha1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	runtime "k8s.io/apimachinery/pkg/runtime"
	watch "k8s.io/apimachinery/pkg/watch"
	cache "k8s.io/client-go/tools/cache"
)

// AutopilotRuleInformer provides access to a shared informer and lister for
// AutopilotRules.
type AutopilotRuleInformer interface {
	Informer() cache.SharedIndexInformer
	Lister() v1alpha1.AutopilotRuleLister
}

type autopilotRuleInformer struct {
	factory          internalinterfaces.SharedInformerFactory
	tweakListOptions internalinterfaces.TweakListOptionsFunc
}

// NewAutopilotRuleInformer constructs a new informer for AutopilotRule type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewAutopilotRuleInformer(client versioned.Interface, resyncPeriod time.Duration, indexers cache.Indexers) cache.SharedIndexInformer {
	return NewFilteredAutopilotRuleInformer(client, resyncPeriod, indexers, nil)
}

// NewFilteredAutopilotRuleInformer constructs a new informer for AutopilotRule type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewFilteredAutopilotRuleInformer(client versioned.Interface, resyncPeriod time.Duration, indexers cache.Indexers, tweakListOptions internalinterfaces.TweakListOptionsFunc) cache.SharedIndexInformer {
	return cache.NewSharedIndexInformer(
		&cache.ListWatch{
			ListFunc: func(options v1.ListOptions) (runtime.Object, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.AutopilotV1alpha1().AutopilotRules().List(options)
			},
			WatchFunc: func(options v1.ListOptions) (watch.Interface, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.AutopilotV1alpha1().AutopilotRules().Watch(options)
			},
		},
		&autopilotv1alpha1.AutopilotRule{},
		resyncPeriod,
		indexers,
	)
}

func (f *autopilotRuleInformer) defaultInformer(client versioned.Interface, resyncPeriod time.Duration) cache.SharedIndexInformer {
	return NewFilteredAutopilotRuleInformer(client, resyncPeriod, cache.Indexers{cache.NamespaceIndex: cache.MetaNamespaceIndexFunc}, f.tweakListOptions)
}

func (f *autopilotRuleInformer) Informer() cache.SharedIndexInformer {
	return f.factory.InformerFor(&autopilotv1alpha1.AutopilotRule{}, f.defaultInformer)
}

func (f *autopilotRuleInformer) Lister() v1alpha1.AutopilotRuleLister {
	return v1alpha1.NewAutopilotRuleLister(f.Informer().GetIndexer())
}
