/*
Copyright 2018 Openstorage.org

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	v1alpha1 "github.com/libopenstorage/stork/pkg/apis/stork/v1alpha1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeSchedulePolicies implements SchedulePolicyInterface
type FakeSchedulePolicies struct {
	Fake *FakeStorkV1alpha1
}

var schedulepoliciesResource = schema.GroupVersionResource{Group: "stork.libopenstorage.org", Version: "v1alpha1", Resource: "schedulepolicies"}

var schedulepoliciesKind = schema.GroupVersionKind{Group: "stork.libopenstorage.org", Version: "v1alpha1", Kind: "SchedulePolicy"}

// Get takes name of the schedulePolicy, and returns the corresponding schedulePolicy object, and an error if there is any.
func (c *FakeSchedulePolicies) Get(name string, options v1.GetOptions) (result *v1alpha1.SchedulePolicy, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootGetAction(schedulepoliciesResource, name), &v1alpha1.SchedulePolicy{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.SchedulePolicy), err
}

// List takes label and field selectors, and returns the list of SchedulePolicies that match those selectors.
func (c *FakeSchedulePolicies) List(opts v1.ListOptions) (result *v1alpha1.SchedulePolicyList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootListAction(schedulepoliciesResource, schedulepoliciesKind, opts), &v1alpha1.SchedulePolicyList{})
	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1alpha1.SchedulePolicyList{ListMeta: obj.(*v1alpha1.SchedulePolicyList).ListMeta}
	for _, item := range obj.(*v1alpha1.SchedulePolicyList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested schedulePolicies.
func (c *FakeSchedulePolicies) Watch(opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewRootWatchAction(schedulepoliciesResource, opts))
}

// Create takes the representation of a schedulePolicy and creates it.  Returns the server's representation of the schedulePolicy, and an error, if there is any.
func (c *FakeSchedulePolicies) Create(schedulePolicy *v1alpha1.SchedulePolicy) (result *v1alpha1.SchedulePolicy, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootCreateAction(schedulepoliciesResource, schedulePolicy), &v1alpha1.SchedulePolicy{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.SchedulePolicy), err
}

// Update takes the representation of a schedulePolicy and updates it. Returns the server's representation of the schedulePolicy, and an error, if there is any.
func (c *FakeSchedulePolicies) Update(schedulePolicy *v1alpha1.SchedulePolicy) (result *v1alpha1.SchedulePolicy, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootUpdateAction(schedulepoliciesResource, schedulePolicy), &v1alpha1.SchedulePolicy{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.SchedulePolicy), err
}

// Delete takes name of the schedulePolicy and deletes it. Returns an error if one occurs.
func (c *FakeSchedulePolicies) Delete(name string, options *v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewRootDeleteAction(schedulepoliciesResource, name), &v1alpha1.SchedulePolicy{})
	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeSchedulePolicies) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	action := testing.NewRootDeleteCollectionAction(schedulepoliciesResource, listOptions)

	_, err := c.Fake.Invokes(action, &v1alpha1.SchedulePolicyList{})
	return err
}

// Patch applies the patch and returns the patched schedulePolicy.
func (c *FakeSchedulePolicies) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha1.SchedulePolicy, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootPatchSubresourceAction(schedulepoliciesResource, name, pt, data, subresources...), &v1alpha1.SchedulePolicy{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.SchedulePolicy), err
}
