/*
Copyright 2018 Openstorage.org

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1alpha1

import (
	v1alpha1 "github.com/libopenstorage/stork/pkg/apis/stork/v1alpha1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// ApplicationBackupScheduleLister helps list ApplicationBackupSchedules.
type ApplicationBackupScheduleLister interface {
	// List lists all ApplicationBackupSchedules in the indexer.
	List(selector labels.Selector) (ret []*v1alpha1.ApplicationBackupSchedule, err error)
	// ApplicationBackupSchedules returns an object that can list and get ApplicationBackupSchedules.
	ApplicationBackupSchedules(namespace string) ApplicationBackupScheduleNamespaceLister
	ApplicationBackupScheduleListerExpansion
}

// applicationBackupScheduleLister implements the ApplicationBackupScheduleLister interface.
type applicationBackupScheduleLister struct {
	indexer cache.Indexer
}

// NewApplicationBackupScheduleLister returns a new ApplicationBackupScheduleLister.
func NewApplicationBackupScheduleLister(indexer cache.Indexer) ApplicationBackupScheduleLister {
	return &applicationBackupScheduleLister{indexer: indexer}
}

// List lists all ApplicationBackupSchedules in the indexer.
func (s *applicationBackupScheduleLister) List(selector labels.Selector) (ret []*v1alpha1.ApplicationBackupSchedule, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.ApplicationBackupSchedule))
	})
	return ret, err
}

// ApplicationBackupSchedules returns an object that can list and get ApplicationBackupSchedules.
func (s *applicationBackupScheduleLister) ApplicationBackupSchedules(namespace string) ApplicationBackupScheduleNamespaceLister {
	return applicationBackupScheduleNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// ApplicationBackupScheduleNamespaceLister helps list and get ApplicationBackupSchedules.
type ApplicationBackupScheduleNamespaceLister interface {
	// List lists all ApplicationBackupSchedules in the indexer for a given namespace.
	List(selector labels.Selector) (ret []*v1alpha1.ApplicationBackupSchedule, err error)
	// Get retrieves the ApplicationBackupSchedule from the indexer for a given namespace and name.
	Get(name string) (*v1alpha1.ApplicationBackupSchedule, error)
	ApplicationBackupScheduleNamespaceListerExpansion
}

// applicationBackupScheduleNamespaceLister implements the ApplicationBackupScheduleNamespaceLister
// interface.
type applicationBackupScheduleNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all ApplicationBackupSchedules in the indexer for a given namespace.
func (s applicationBackupScheduleNamespaceLister) List(selector labels.Selector) (ret []*v1alpha1.ApplicationBackupSchedule, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.ApplicationBackupSchedule))
	})
	return ret, err
}

// Get retrieves the ApplicationBackupSchedule from the indexer for a given namespace and name.
func (s applicationBackupScheduleNamespaceLister) Get(name string) (*v1alpha1.ApplicationBackupSchedule, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1alpha1.Resource("applicationbackupschedule"), name)
	}
	return obj.(*v1alpha1.ApplicationBackupSchedule), nil
}
