/*
Copyright 2018 Openstorage.org

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1alpha1

import (
	v1alpha1 "github.com/libopenstorage/stork/pkg/apis/stork/v1alpha1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// GroupVolumeSnapshotLister helps list GroupVolumeSnapshots.
type GroupVolumeSnapshotLister interface {
	// List lists all GroupVolumeSnapshots in the indexer.
	List(selector labels.Selector) (ret []*v1alpha1.GroupVolumeSnapshot, err error)
	// GroupVolumeSnapshots returns an object that can list and get GroupVolumeSnapshots.
	GroupVolumeSnapshots(namespace string) GroupVolumeSnapshotNamespaceLister
	GroupVolumeSnapshotListerExpansion
}

// groupVolumeSnapshotLister implements the GroupVolumeSnapshotLister interface.
type groupVolumeSnapshotLister struct {
	indexer cache.Indexer
}

// NewGroupVolumeSnapshotLister returns a new GroupVolumeSnapshotLister.
func NewGroupVolumeSnapshotLister(indexer cache.Indexer) GroupVolumeSnapshotLister {
	return &groupVolumeSnapshotLister{indexer: indexer}
}

// List lists all GroupVolumeSnapshots in the indexer.
func (s *groupVolumeSnapshotLister) List(selector labels.Selector) (ret []*v1alpha1.GroupVolumeSnapshot, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.GroupVolumeSnapshot))
	})
	return ret, err
}

// GroupVolumeSnapshots returns an object that can list and get GroupVolumeSnapshots.
func (s *groupVolumeSnapshotLister) GroupVolumeSnapshots(namespace string) GroupVolumeSnapshotNamespaceLister {
	return groupVolumeSnapshotNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// GroupVolumeSnapshotNamespaceLister helps list and get GroupVolumeSnapshots.
type GroupVolumeSnapshotNamespaceLister interface {
	// List lists all GroupVolumeSnapshots in the indexer for a given namespace.
	List(selector labels.Selector) (ret []*v1alpha1.GroupVolumeSnapshot, err error)
	// Get retrieves the GroupVolumeSnapshot from the indexer for a given namespace and name.
	Get(name string) (*v1alpha1.GroupVolumeSnapshot, error)
	GroupVolumeSnapshotNamespaceListerExpansion
}

// groupVolumeSnapshotNamespaceLister implements the GroupVolumeSnapshotNamespaceLister
// interface.
type groupVolumeSnapshotNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all GroupVolumeSnapshots in the indexer for a given namespace.
func (s groupVolumeSnapshotNamespaceLister) List(selector labels.Selector) (ret []*v1alpha1.GroupVolumeSnapshot, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.GroupVolumeSnapshot))
	})
	return ret, err
}

// Get retrieves the GroupVolumeSnapshot from the indexer for a given namespace and name.
func (s groupVolumeSnapshotNamespaceLister) Get(name string) (*v1alpha1.GroupVolumeSnapshot, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1alpha1.Resource("groupvolumesnapshot"), name)
	}
	return obj.(*v1alpha1.GroupVolumeSnapshot), nil
}
