package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ResetOrganizationUserPassword invokes the baas.ResetOrganizationUserPassword API synchronously
// api document: https://help.aliyun.com/api/baas/resetorganizationuserpassword.html
func (client *Client) ResetOrganizationUserPassword(request *ResetOrganizationUserPasswordRequest) (response *ResetOrganizationUserPasswordResponse, err error) {
	response = CreateResetOrganizationUserPasswordResponse()
	err = client.DoAction(request, response)
	return
}

// ResetOrganizationUserPasswordWithChan invokes the baas.ResetOrganizationUserPassword API asynchronously
// api document: https://help.aliyun.com/api/baas/resetorganizationuserpassword.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ResetOrganizationUserPasswordWithChan(request *ResetOrganizationUserPasswordRequest) (<-chan *ResetOrganizationUserPasswordResponse, <-chan error) {
	responseChan := make(chan *ResetOrganizationUserPasswordResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ResetOrganizationUserPassword(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ResetOrganizationUserPasswordWithCallback invokes the baas.ResetOrganizationUserPassword API asynchronously
// api document: https://help.aliyun.com/api/baas/resetorganizationuserpassword.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ResetOrganizationUserPasswordWithCallback(request *ResetOrganizationUserPasswordRequest, callback func(response *ResetOrganizationUserPasswordResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ResetOrganizationUserPasswordResponse
		var err error
		defer close(result)
		response, err = client.ResetOrganizationUserPassword(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ResetOrganizationUserPasswordRequest is the request struct for api ResetOrganizationUserPassword
type ResetOrganizationUserPasswordRequest struct {
	*requests.RpcRequest
	OrganizationId string `position:"Body" name:"OrganizationId"`
	Password       string `position:"Body" name:"Password"`
	Location       string `position:"Body" name:"Location"`
	Username       string `position:"Body" name:"Username"`
}

// ResetOrganizationUserPasswordResponse is the response struct for api ResetOrganizationUserPassword
type ResetOrganizationUserPasswordResponse struct {
	*responses.BaseResponse
	RequestId string                                `json:"RequestId" xml:"RequestId"`
	Success   bool                                  `json:"Success" xml:"Success"`
	ErrorCode int                                   `json:"ErrorCode" xml:"ErrorCode"`
	Result    ResultInResetOrganizationUserPassword `json:"Result" xml:"Result"`
}

// CreateResetOrganizationUserPasswordRequest creates a request to invoke ResetOrganizationUserPassword API
func CreateResetOrganizationUserPasswordRequest() (request *ResetOrganizationUserPasswordRequest) {
	request = &ResetOrganizationUserPasswordRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-07-31", "ResetOrganizationUserPassword", "", "")
	return
}

// CreateResetOrganizationUserPasswordResponse creates a response to parse from ResetOrganizationUserPassword response
func CreateResetOrganizationUserPasswordResponse() (response *ResetOrganizationUserPasswordResponse) {
	response = &ResetOrganizationUserPasswordResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
