package ehpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteContainerApps invokes the ehpc.DeleteContainerApps API synchronously
// api document: https://help.aliyun.com/api/ehpc/deletecontainerapps.html
func (client *Client) DeleteContainerApps(request *DeleteContainerAppsRequest) (response *DeleteContainerAppsResponse, err error) {
	response = CreateDeleteContainerAppsResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteContainerAppsWithChan invokes the ehpc.DeleteContainerApps API asynchronously
// api document: https://help.aliyun.com/api/ehpc/deletecontainerapps.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteContainerAppsWithChan(request *DeleteContainerAppsRequest) (<-chan *DeleteContainerAppsResponse, <-chan error) {
	responseChan := make(chan *DeleteContainerAppsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteContainerApps(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteContainerAppsWithCallback invokes the ehpc.DeleteContainerApps API asynchronously
// api document: https://help.aliyun.com/api/ehpc/deletecontainerapps.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteContainerAppsWithCallback(request *DeleteContainerAppsRequest, callback func(response *DeleteContainerAppsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteContainerAppsResponse
		var err error
		defer close(result)
		response, err = client.DeleteContainerApps(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteContainerAppsRequest is the request struct for api DeleteContainerApps
type DeleteContainerAppsRequest struct {
	*requests.RpcRequest
	ContainerApp *[]DeleteContainerAppsContainerApp `position:"Query" name:"ContainerApp"  type:"Repeated"`
}

// DeleteContainerAppsContainerApp is a repeated param struct in DeleteContainerAppsRequest
type DeleteContainerAppsContainerApp struct {
	Id string `name:"Id"`
}

// DeleteContainerAppsResponse is the response struct for api DeleteContainerApps
type DeleteContainerAppsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteContainerAppsRequest creates a request to invoke DeleteContainerApps API
func CreateDeleteContainerAppsRequest() (request *DeleteContainerAppsRequest) {
	request = &DeleteContainerAppsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("EHPC", "2018-04-12", "DeleteContainerApps", "ehs", "openAPI")
	return
}

// CreateDeleteContainerAppsResponse creates a response to parse from DeleteContainerApps response
func CreateDeleteContainerAppsResponse() (response *DeleteContainerAppsResponse) {
	response = &DeleteContainerAppsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
