package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDataSourceSchemaDatabase invokes the emr.DescribeDataSourceSchemaDatabase API synchronously
// api document: https://help.aliyun.com/api/emr/describedatasourceschemadatabase.html
func (client *Client) DescribeDataSourceSchemaDatabase(request *DescribeDataSourceSchemaDatabaseRequest) (response *DescribeDataSourceSchemaDatabaseResponse, err error) {
	response = CreateDescribeDataSourceSchemaDatabaseResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDataSourceSchemaDatabaseWithChan invokes the emr.DescribeDataSourceSchemaDatabase API asynchronously
// api document: https://help.aliyun.com/api/emr/describedatasourceschemadatabase.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeDataSourceSchemaDatabaseWithChan(request *DescribeDataSourceSchemaDatabaseRequest) (<-chan *DescribeDataSourceSchemaDatabaseResponse, <-chan error) {
	responseChan := make(chan *DescribeDataSourceSchemaDatabaseResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDataSourceSchemaDatabase(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDataSourceSchemaDatabaseWithCallback invokes the emr.DescribeDataSourceSchemaDatabase API asynchronously
// api document: https://help.aliyun.com/api/emr/describedatasourceschemadatabase.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeDataSourceSchemaDatabaseWithCallback(request *DescribeDataSourceSchemaDatabaseRequest, callback func(response *DescribeDataSourceSchemaDatabaseResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDataSourceSchemaDatabaseResponse
		var err error
		defer close(result)
		response, err = client.DescribeDataSourceSchemaDatabase(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDataSourceSchemaDatabaseRequest is the request struct for api DescribeDataSourceSchemaDatabase
type DescribeDataSourceSchemaDatabaseRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	DbName          string           `position:"Query" name:"DbName"`
	DataSourceId    string           `position:"Query" name:"DataSourceId"`
}

// DescribeDataSourceSchemaDatabaseResponse is the response struct for api DescribeDataSourceSchemaDatabase
type DescribeDataSourceSchemaDatabaseResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	DataSourceId string `json:"DataSourceId" xml:"DataSourceId"`
	Schema       Schema `json:"Schema" xml:"Schema"`
}

// CreateDescribeDataSourceSchemaDatabaseRequest creates a request to invoke DescribeDataSourceSchemaDatabase API
func CreateDescribeDataSourceSchemaDatabaseRequest() (request *DescribeDataSourceSchemaDatabaseRequest) {
	request = &DescribeDataSourceSchemaDatabaseRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "DescribeDataSourceSchemaDatabase", "emr", "openAPI")
	return
}

// CreateDescribeDataSourceSchemaDatabaseResponse creates a response to parse from DescribeDataSourceSchemaDatabase response
func CreateDescribeDataSourceSchemaDatabaseResponse() (response *DescribeDataSourceSchemaDatabaseResponse) {
	response = &DescribeDataSourceSchemaDatabaseResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
