package ivision

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateUploadToken invokes the ivision.CreateUploadToken API synchronously
// api document: https://help.aliyun.com/api/ivision/createuploadtoken.html
func (client *Client) CreateUploadToken(request *CreateUploadTokenRequest) (response *CreateUploadTokenResponse, err error) {
	response = CreateCreateUploadTokenResponse()
	err = client.DoAction(request, response)
	return
}

// CreateUploadTokenWithChan invokes the ivision.CreateUploadToken API asynchronously
// api document: https://help.aliyun.com/api/ivision/createuploadtoken.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateUploadTokenWithChan(request *CreateUploadTokenRequest) (<-chan *CreateUploadTokenResponse, <-chan error) {
	responseChan := make(chan *CreateUploadTokenResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateUploadToken(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateUploadTokenWithCallback invokes the ivision.CreateUploadToken API asynchronously
// api document: https://help.aliyun.com/api/ivision/createuploadtoken.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateUploadTokenWithCallback(request *CreateUploadTokenRequest, callback func(response *CreateUploadTokenResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateUploadTokenResponse
		var err error
		defer close(result)
		response, err = client.CreateUploadToken(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateUploadTokenRequest is the request struct for api CreateUploadToken
type CreateUploadTokenRequest struct {
	*requests.RpcRequest
	ProjectId string           `position:"Query" name:"ProjectId"`
	ShowLog   string           `position:"Query" name:"ShowLog"`
	OwnerId   requests.Integer `position:"Query" name:"OwnerId"`
	FileName  string           `position:"Query" name:"FileName"`
}

// CreateUploadTokenResponse is the response struct for api CreateUploadToken
type CreateUploadTokenResponse struct {
	*responses.BaseResponse
	RequestId   string      `json:"RequestId" xml:"RequestId"`
	UploadToken UploadToken `json:"UploadToken" xml:"UploadToken"`
}

// CreateCreateUploadTokenRequest creates a request to invoke CreateUploadToken API
func CreateCreateUploadTokenRequest() (request *CreateUploadTokenRequest) {
	request = &CreateUploadTokenRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ivision", "2019-03-08", "CreateUploadToken", "ivision", "openAPI")
	return
}

// CreateCreateUploadTokenResponse creates a response to parse from CreateUploadToken response
func CreateCreateUploadTokenResponse() (response *CreateUploadTokenResponse) {
	response = &CreateUploadTokenResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
