//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package rtc

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetTemplateInfo invokes the rtc.GetTemplateInfo API synchronously
// api document: https://help.aliyun.com/api/rtc/gettemplateinfo.html
func (client *Client) GetTemplateInfo(request *GetTemplateInfoRequest) (response *GetTemplateInfoResponse, err error) {
	response = CreateGetTemplateInfoResponse()
	err = client.DoAction(request, response)
	return
}

// GetTemplateInfoWithChan invokes the rtc.GetTemplateInfo API asynchronously
// api document: https://help.aliyun.com/api/rtc/gettemplateinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetTemplateInfoWithChan(request *GetTemplateInfoRequest) (<-chan *GetTemplateInfoResponse, <-chan error) {
	responseChan := make(chan *GetTemplateInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetTemplateInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetTemplateInfoWithCallback invokes the rtc.GetTemplateInfo API asynchronously
// api document: https://help.aliyun.com/api/rtc/gettemplateinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetTemplateInfoWithCallback(request *GetTemplateInfoRequest, callback func(response *GetTemplateInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetTemplateInfoResponse
		var err error
		defer close(result)
		response, err = client.GetTemplateInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetTemplateInfoRequest is the request struct for api GetTemplateInfo
type GetTemplateInfoRequest struct {
	*requests.RpcRequest
	OwnerId    requests.Integer `position:"Query" name:"OwnerId"`
	AppId      string           `position:"Query" name:"AppId"`
	TemplateId requests.Integer `position:"Query" name:"TemplateId"`
}

// GetTemplateInfoResponse is the response struct for api GetTemplateInfo
type GetTemplateInfoResponse struct {
	*responses.BaseResponse
	RequestId         string                       `json:"RequestId" xml:"RequestId"`
	MixMode           int                          `json:"MixMode" xml:"MixMode"`
	ServiceMode       int                          `json:"ServiceMode" xml:"ServiceMode"`
	CallBack          string                       `json:"CallBack" xml:"CallBack"`
	MaxMixStreamCount int                          `json:"MaxMixStreamCount" xml:"MaxMixStreamCount"`
	MediaConfig       int                          `json:"MediaConfig" xml:"MediaConfig"`
	LayOut            GetTemplateInfoLayOut0       `json:"LayOut" xml:"LayOut"`
	RecordConfig      GetTemplateInfoRecordConfig0 `json:"RecordConfig" xml:"RecordConfig"`
	LiveConfig        GetTemplateInfoLiveConfig0   `json:"LiveConfig" xml:"LiveConfig"`
}

type GetTemplateInfoLayOut0 struct {
	Color    string `json:"Color" xml:"Color"`
	Cutmode  int    `json:"Cutmode" xml:"Cutmode"`
	LayoutID int    `json:"LayoutID" xml:"LayoutID"`
}

type GetTemplateInfoRecordConfig0 struct {
	StorageType         string `json:"StorageType" xml:"StorageType"`
	FileFormat          int    `json:"FileFormat" xml:"FileFormat"`
	OssEndpoint         string `json:"OssEndpoint" xml:"OssEndpoint"`
	OssBucket           string `json:"OssBucket" xml:"OssBucket"`
	VodTranscodeGroupId int    `json:"VodTranscodeGroupId" xml:"VodTranscodeGroupId"`
}

type GetTemplateInfoLiveConfig0 struct {
	DomainName string `json:"DomainName" xml:"DomainName"`
	AppName    string `json:"AppName" xml:"AppName"`
}

// CreateGetTemplateInfoRequest creates a request to invoke GetTemplateInfo API
func CreateGetTemplateInfoRequest() (request *GetTemplateInfoRequest) {
	request = &GetTemplateInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("rtc", "2018-01-11", "GetTemplateInfo", "rtc", "openAPI")
	return
}

// CreateGetTemplateInfoResponse creates a response to parse from GetTemplateInfo response
func CreateGetTemplateInfoResponse() (response *GetTemplateInfoResponse) {
	response = &GetTemplateInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
