/*
Copyright 2018 Openstorage.org

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	v1alpha1 "github.com/libopenstorage/stork/pkg/apis/stork/v1alpha1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeBackupLocations implements BackupLocationInterface
type FakeBackupLocations struct {
	Fake *FakeStorkV1alpha1
	ns   string
}

var backuplocationsResource = schema.GroupVersionResource{Group: "stork.libopenstorage.org", Version: "v1alpha1", Resource: "backuplocations"}

var backuplocationsKind = schema.GroupVersionKind{Group: "stork.libopenstorage.org", Version: "v1alpha1", Kind: "BackupLocation"}

// Get takes name of the backupLocation, and returns the corresponding backupLocation object, and an error if there is any.
func (c *FakeBackupLocations) Get(name string, options v1.GetOptions) (result *v1alpha1.BackupLocation, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(backuplocationsResource, c.ns, name), &v1alpha1.BackupLocation{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.BackupLocation), err
}

// List takes label and field selectors, and returns the list of BackupLocations that match those selectors.
func (c *FakeBackupLocations) List(opts v1.ListOptions) (result *v1alpha1.BackupLocationList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(backuplocationsResource, backuplocationsKind, c.ns, opts), &v1alpha1.BackupLocationList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1alpha1.BackupLocationList{ListMeta: obj.(*v1alpha1.BackupLocationList).ListMeta}
	for _, item := range obj.(*v1alpha1.BackupLocationList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested backupLocations.
func (c *FakeBackupLocations) Watch(opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(backuplocationsResource, c.ns, opts))

}

// Create takes the representation of a backupLocation and creates it.  Returns the server's representation of the backupLocation, and an error, if there is any.
func (c *FakeBackupLocations) Create(backupLocation *v1alpha1.BackupLocation) (result *v1alpha1.BackupLocation, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(backuplocationsResource, c.ns, backupLocation), &v1alpha1.BackupLocation{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.BackupLocation), err
}

// Update takes the representation of a backupLocation and updates it. Returns the server's representation of the backupLocation, and an error, if there is any.
func (c *FakeBackupLocations) Update(backupLocation *v1alpha1.BackupLocation) (result *v1alpha1.BackupLocation, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(backuplocationsResource, c.ns, backupLocation), &v1alpha1.BackupLocation{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.BackupLocation), err
}

// Delete takes name of the backupLocation and deletes it. Returns an error if one occurs.
func (c *FakeBackupLocations) Delete(name string, options *v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteAction(backuplocationsResource, c.ns, name), &v1alpha1.BackupLocation{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeBackupLocations) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(backuplocationsResource, c.ns, listOptions)

	_, err := c.Fake.Invokes(action, &v1alpha1.BackupLocationList{})
	return err
}

// Patch applies the patch and returns the patched backupLocation.
func (c *FakeBackupLocations) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha1.BackupLocation, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(backuplocationsResource, c.ns, name, pt, data, subresources...), &v1alpha1.BackupLocation{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.BackupLocation), err
}
