/*
Copyright 2018 Openstorage.org

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	v1alpha1 "github.com/libopenstorage/stork/pkg/apis/stork/v1alpha1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeMigrationSchedules implements MigrationScheduleInterface
type FakeMigrationSchedules struct {
	Fake *FakeStorkV1alpha1
	ns   string
}

var migrationschedulesResource = schema.GroupVersionResource{Group: "stork.libopenstorage.org", Version: "v1alpha1", Resource: "migrationschedules"}

var migrationschedulesKind = schema.GroupVersionKind{Group: "stork.libopenstorage.org", Version: "v1alpha1", Kind: "MigrationSchedule"}

// Get takes name of the migrationSchedule, and returns the corresponding migrationSchedule object, and an error if there is any.
func (c *FakeMigrationSchedules) Get(name string, options v1.GetOptions) (result *v1alpha1.MigrationSchedule, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(migrationschedulesResource, c.ns, name), &v1alpha1.MigrationSchedule{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.MigrationSchedule), err
}

// List takes label and field selectors, and returns the list of MigrationSchedules that match those selectors.
func (c *FakeMigrationSchedules) List(opts v1.ListOptions) (result *v1alpha1.MigrationScheduleList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(migrationschedulesResource, migrationschedulesKind, c.ns, opts), &v1alpha1.MigrationScheduleList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1alpha1.MigrationScheduleList{ListMeta: obj.(*v1alpha1.MigrationScheduleList).ListMeta}
	for _, item := range obj.(*v1alpha1.MigrationScheduleList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested migrationSchedules.
func (c *FakeMigrationSchedules) Watch(opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(migrationschedulesResource, c.ns, opts))

}

// Create takes the representation of a migrationSchedule and creates it.  Returns the server's representation of the migrationSchedule, and an error, if there is any.
func (c *FakeMigrationSchedules) Create(migrationSchedule *v1alpha1.MigrationSchedule) (result *v1alpha1.MigrationSchedule, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(migrationschedulesResource, c.ns, migrationSchedule), &v1alpha1.MigrationSchedule{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.MigrationSchedule), err
}

// Update takes the representation of a migrationSchedule and updates it. Returns the server's representation of the migrationSchedule, and an error, if there is any.
func (c *FakeMigrationSchedules) Update(migrationSchedule *v1alpha1.MigrationSchedule) (result *v1alpha1.MigrationSchedule, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(migrationschedulesResource, c.ns, migrationSchedule), &v1alpha1.MigrationSchedule{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.MigrationSchedule), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeMigrationSchedules) UpdateStatus(migrationSchedule *v1alpha1.MigrationSchedule) (*v1alpha1.MigrationSchedule, error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateSubresourceAction(migrationschedulesResource, "status", c.ns, migrationSchedule), &v1alpha1.MigrationSchedule{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.MigrationSchedule), err
}

// Delete takes name of the migrationSchedule and deletes it. Returns an error if one occurs.
func (c *FakeMigrationSchedules) Delete(name string, options *v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteAction(migrationschedulesResource, c.ns, name), &v1alpha1.MigrationSchedule{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeMigrationSchedules) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(migrationschedulesResource, c.ns, listOptions)

	_, err := c.Fake.Invokes(action, &v1alpha1.MigrationScheduleList{})
	return err
}

// Patch applies the patch and returns the patched migrationSchedule.
func (c *FakeMigrationSchedules) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha1.MigrationSchedule, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(migrationschedulesResource, c.ns, name, pt, data, subresources...), &v1alpha1.MigrationSchedule{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.MigrationSchedule), err
}
