package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeETLJob invokes the emr.DescribeETLJob API synchronously
// api document: https://help.aliyun.com/api/emr/describeetljob.html
func (client *Client) DescribeETLJob(request *DescribeETLJobRequest) (response *DescribeETLJobResponse, err error) {
	response = CreateDescribeETLJobResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeETLJobWithChan invokes the emr.DescribeETLJob API asynchronously
// api document: https://help.aliyun.com/api/emr/describeetljob.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeETLJobWithChan(request *DescribeETLJobRequest) (<-chan *DescribeETLJobResponse, <-chan error) {
	responseChan := make(chan *DescribeETLJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeETLJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeETLJobWithCallback invokes the emr.DescribeETLJob API asynchronously
// api document: https://help.aliyun.com/api/emr/describeetljob.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeETLJobWithCallback(request *DescribeETLJobRequest, callback func(response *DescribeETLJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeETLJobResponse
		var err error
		defer close(result)
		response, err = client.DescribeETLJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeETLJobRequest is the request struct for api DescribeETLJob
type DescribeETLJobRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Id              string           `position:"Query" name:"Id"`
}

// DescribeETLJobResponse is the response struct for api DescribeETLJob
type DescribeETLJobResponse struct {
	*responses.BaseResponse
	RequestId           string              `json:"RequestId" xml:"RequestId"`
	Id                  string              `json:"Id" xml:"Id"`
	Name                string              `json:"Name" xml:"Name"`
	Description         string              `json:"Description" xml:"Description"`
	CategoryId          string              `json:"CategoryId" xml:"CategoryId"`
	Graph               string              `json:"Graph" xml:"Graph"`
	ClusterConfig       ClusterConfig       `json:"ClusterConfig" xml:"ClusterConfig"`
	AlertConfig         AlertConfig         `json:"AlertConfig" xml:"AlertConfig"`
	TriggerRuleList     TriggerRuleList     `json:"TriggerRuleList" xml:"TriggerRuleList"`
	StageList           StageList           `json:"StageList" xml:"StageList"`
	StageConnectionList StageConnectionList `json:"StageConnectionList" xml:"StageConnectionList"`
}

// CreateDescribeETLJobRequest creates a request to invoke DescribeETLJob API
func CreateDescribeETLJobRequest() (request *DescribeETLJobRequest) {
	request = &DescribeETLJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "DescribeETLJob", "emr", "openAPI")
	return
}

// CreateDescribeETLJobResponse creates a response to parse from DescribeETLJob response
func CreateDescribeETLJobResponse() (response *DescribeETLJobResponse) {
	response = &DescribeETLJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
