package ess

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeactivateScalingConfiguration invokes the ess.DeactivateScalingConfiguration API synchronously
// api document: https://help.aliyun.com/api/ess/deactivatescalingconfiguration.html
func (client *Client) DeactivateScalingConfiguration(request *DeactivateScalingConfigurationRequest) (response *DeactivateScalingConfigurationResponse, err error) {
	response = CreateDeactivateScalingConfigurationResponse()
	err = client.DoAction(request, response)
	return
}

// DeactivateScalingConfigurationWithChan invokes the ess.DeactivateScalingConfiguration API asynchronously
// api document: https://help.aliyun.com/api/ess/deactivatescalingconfiguration.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeactivateScalingConfigurationWithChan(request *DeactivateScalingConfigurationRequest) (<-chan *DeactivateScalingConfigurationResponse, <-chan error) {
	responseChan := make(chan *DeactivateScalingConfigurationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeactivateScalingConfiguration(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeactivateScalingConfigurationWithCallback invokes the ess.DeactivateScalingConfiguration API asynchronously
// api document: https://help.aliyun.com/api/ess/deactivatescalingconfiguration.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeactivateScalingConfigurationWithCallback(request *DeactivateScalingConfigurationRequest, callback func(response *DeactivateScalingConfigurationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeactivateScalingConfigurationResponse
		var err error
		defer close(result)
		response, err = client.DeactivateScalingConfiguration(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeactivateScalingConfigurationRequest is the request struct for api DeactivateScalingConfiguration
type DeactivateScalingConfigurationRequest struct {
	*requests.RpcRequest
	ResourceOwnerAccount   string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount           string           `position:"Query" name:"OwnerAccount"`
	OwnerId                requests.Integer `position:"Query" name:"OwnerId"`
	ScalingConfigurationId string           `position:"Query" name:"ScalingConfigurationId"`
}

// DeactivateScalingConfigurationResponse is the response struct for api DeactivateScalingConfiguration
type DeactivateScalingConfigurationResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeactivateScalingConfigurationRequest creates a request to invoke DeactivateScalingConfiguration API
func CreateDeactivateScalingConfigurationRequest() (request *DeactivateScalingConfigurationRequest) {
	request = &DeactivateScalingConfigurationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ess", "2014-08-28", "DeactivateScalingConfiguration", "ess", "openAPI")
	return
}

// CreateDeactivateScalingConfigurationResponse creates a response to parse from DeactivateScalingConfiguration response
func CreateDeactivateScalingConfigurationResponse() (response *DeactivateScalingConfigurationResponse) {
	response = &DeactivateScalingConfigurationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
