package ros

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ValidateTemplate invokes the ros.ValidateTemplate API synchronously
// api document: https://help.aliyun.com/api/ros/validatetemplate.html
func (client *Client) ValidateTemplate(request *ValidateTemplateRequest) (response *ValidateTemplateResponse, err error) {
	response = CreateValidateTemplateResponse()
	err = client.DoAction(request, response)
	return
}

// ValidateTemplateWithChan invokes the ros.ValidateTemplate API asynchronously
// api document: https://help.aliyun.com/api/ros/validatetemplate.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ValidateTemplateWithChan(request *ValidateTemplateRequest) (<-chan *ValidateTemplateResponse, <-chan error) {
	responseChan := make(chan *ValidateTemplateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ValidateTemplate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ValidateTemplateWithCallback invokes the ros.ValidateTemplate API asynchronously
// api document: https://help.aliyun.com/api/ros/validatetemplate.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ValidateTemplateWithCallback(request *ValidateTemplateRequest, callback func(response *ValidateTemplateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ValidateTemplateResponse
		var err error
		defer close(result)
		response, err = client.ValidateTemplate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ValidateTemplateRequest is the request struct for api ValidateTemplate
type ValidateTemplateRequest struct {
	*requests.RoaRequest
}

// ValidateTemplateResponse is the response struct for api ValidateTemplate
type ValidateTemplateResponse struct {
	*responses.BaseResponse
}

// CreateValidateTemplateRequest creates a request to invoke ValidateTemplate API
func CreateValidateTemplateRequest() (request *ValidateTemplateRequest) {
	request = &ValidateTemplateRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("ROS", "2015-09-01", "ValidateTemplate", "/validate", "", "")
	request.Method = requests.POST
	return
}

// CreateValidateTemplateResponse creates a response to parse from ValidateTemplate response
func CreateValidateTemplateResponse() (response *ValidateTemplateResponse) {
	response = &ValidateTemplateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
