import { __rest } from "tslib";
import { ChartBulletStyles } from '../../ChartTheme';
import { getBulletComparativeErrorMeasureTheme, getBulletComparativeMeasureTheme, getBulletComparativeWarningMeasureTheme, getBulletPrimaryDotMeasureTheme, getBulletPrimarySegmentedMeasureTheme, getBulletQualitativeRangeTheme } from '../../ChartUtils';
const scaleDimensions = ({ defaultSize, height, horizontal = true, scale = 1, value, width }) => {
    if (horizontal && height > defaultSize) {
        return value + (height - defaultSize) * scale;
    }
    else if (horizontal) {
        return value - (defaultSize - height) * scale;
    }
    else if (width > defaultSize) {
        return value + (width - defaultSize) * scale;
    }
    return value - (defaultSize - width) * scale;
};
// Scale bar width per the given size properties
export const scaleBarWidth = (props) => Math.max(scaleDimensions(props), 0);
// Scale size per the given size properties
export const scaleSize = (_a) => {
    var { value } = _a, rest = __rest(_a, ["value"]);
    return Math.round(scaleDimensions(Object.assign({ scale: 1 / value, value }, rest)));
};
export const getComparativeMeasureErrorWidth = ({ height, horizontal, themeColor, themeVariant, width, 
// destructure last
theme = getBulletComparativeErrorMeasureTheme(themeColor, themeVariant) }) => scaleBarWidth({
    defaultSize: theme.bar.height,
    height,
    horizontal,
    value: ChartBulletStyles.comparativeMeasureErrorWidth,
    width
});
export const getComparativeMeasureWidth = ({ height, horizontal, themeColor, themeVariant, width, 
// destructure last
theme = getBulletComparativeMeasureTheme(themeColor, themeVariant) }) => scaleBarWidth({
    defaultSize: theme.bar.height,
    height,
    horizontal,
    value: ChartBulletStyles.comparativeMeasureWidth,
    width
});
export const getComparativeMeasureWarningWidth = ({ height, horizontal, themeColor, themeVariant, width, 
// destructure last
theme = getBulletComparativeWarningMeasureTheme(themeColor, themeVariant) }) => scaleBarWidth({
    defaultSize: theme.bar.height,
    height,
    horizontal,
    value: ChartBulletStyles.comparativeMeasureWarningWidth,
    width
});
export const getPrimaryDotMeasureSize = ({ height, horizontal, themeColor, themeVariant, width, 
// destructure last
theme = getBulletPrimaryDotMeasureTheme(themeColor, themeVariant) }) => scaleSize({
    defaultSize: theme.group.height,
    height,
    horizontal,
    value: ChartBulletStyles.primaryDotMeasureSize,
    width
});
export const getPrimarySegmentedMeasureWidth = ({ height, horizontal, themeColor, themeVariant, width, 
// destructure last
theme = getBulletPrimarySegmentedMeasureTheme(themeColor, themeVariant) }) => scaleBarWidth({
    defaultSize: theme.group.height,
    height,
    horizontal,
    scale: 0.3,
    value: ChartBulletStyles.primarySegmentedMeasureWidth,
    width
});
export const getQualitativeRangeBarWidth = ({ height, horizontal, themeColor, themeVariant, width, 
// destructure last
theme = getBulletQualitativeRangeTheme(themeColor, themeVariant) }) => scaleBarWidth({
    defaultSize: theme.group.height,
    height,
    horizontal,
    value: ChartBulletStyles.qualitativeRangeWidth,
    width
});
//# sourceMappingURL=chart-bullet-size.js.map