import { K8sGroupVersionKind, K8sResourceCommon, Patch, QueryParams, Status } from '../extensions/console-types';
import { K8sModel } from './common-types';
import { Options } from './internal-types';
export declare type K8sGet = <R extends K8sResourceCommon>(options: {
    model: K8sModel;
    name: string;
    ns?: string;
    path?: string;
    queryParams?: QueryParams;
    requestInit?: RequestInit;
}) => Promise<R>;
export declare type K8sCreate = <R extends K8sResourceCommon>(options: {
    model: K8sModel;
    data: R;
    path?: string;
    queryParams?: QueryParams;
}) => Promise<R>;
export declare type K8sUpdate = <R extends K8sResourceCommon>(options: {
    model: K8sModel;
    data: R;
    path?: string;
    queryParams?: QueryParams;
}) => Promise<R>;
export declare type K8sPatch = <R extends K8sResourceCommon>(options: {
    model: K8sModel;
    resource: R;
    data: Patch[];
    path?: string;
    queryParams?: QueryParams;
}) => Promise<R>;
export declare type K8sDelete = <R extends K8sResourceCommon>(options: {
    model: K8sModel;
    resource: R;
    path?: string;
    queryParams?: QueryParams;
    requestInit?: RequestInit;
    json?: Record<string, any>;
}) => Promise<Status>;
export declare type K8sList = <R extends K8sResourceCommon>(options: {
    model: K8sModel;
    queryParams: {
        [key: string]: any;
    };
    requestInit?: RequestInit;
}) => Promise<R[]>;
export declare type GetK8sResourcePath = (model: K8sModel, options: Options) => string;
export declare type GetAPIVersionForModel = (model: K8sModel) => string;
export declare type GetGroupVersionKindForResource = (resource: K8sResourceCommon) => K8sGroupVersionKind;
export declare type GetGroupVersionKindForModel = (model: K8sModel) => K8sGroupVersionKind;
