"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ChartBulletTitle = void 0;
const tslib_1 = require("tslib");
const React = tslib_1.__importStar(require("react"));
const ChartContainer_1 = require("../ChartContainer");
const ChartLabel_1 = require("../ChartLabel");
const ChartTheme_1 = require("../ChartTheme");
const ChartUtils_1 = require("../ChartUtils");
exports.ChartBulletTitle = ({ ariaDesc, ariaTitle, capHeight = 1.1, horizontal = true, legendPosition = 'bottom', padding, standalone = true, subTitle, themeColor, themeVariant, title, titleComponent = React.createElement(ChartLabel_1.ChartLabel, null), titlePosition, 
// destructure last
theme = ChartUtils_1.getBulletTheme(themeColor, themeVariant), height = horizontal ? theme.chart.height : theme.chart.width, width = horizontal ? theme.chart.width : theme.chart.height }) => {
    const chartSize = {
        height: horizontal ? theme.chart.height : height,
        width: horizontal ? width : theme.chart.height
    };
    const defaultPadding = {
        bottom: ChartUtils_1.getPaddingForSide('bottom', padding, theme.chart.padding),
        left: ChartUtils_1.getPaddingForSide('left', padding, theme.chart.padding),
        right: ChartUtils_1.getPaddingForSide('right', padding, theme.chart.padding),
        top: ChartUtils_1.getPaddingForSide('top', padding, theme.chart.padding)
    };
    // Returns title
    const getTitle = () => {
        const showBoth = title && subTitle;
        let labelPosition = horizontal ? 'left' : 'bottom';
        if (titlePosition && titlePosition.includes('left') && horizontal) {
            labelPosition = titlePosition;
        }
        let textAnchor = 'middle';
        if (labelPosition === 'top-left') {
            textAnchor = 'start';
        }
        else if (horizontal) {
            textAnchor = 'end';
        }
        // Adjust for padding
        let dy = ChartTheme_1.ChartCommonStyles.legend.margin * 2 - defaultPadding.bottom;
        if (labelPosition === 'top-left') {
            const offsetLabelPosition = showBoth ? 0 : 1;
            dy =
                defaultPadding.top * 0.5 +
                    (defaultPadding.bottom * 0.5 - defaultPadding.bottom) +
                    58 -
                    ChartTheme_1.ChartCommonStyles.legend.margin +
                    offsetLabelPosition;
        }
        else if (horizontal) {
            dy = defaultPadding.top * 0.5 + (defaultPadding.bottom * 0.5 - defaultPadding.bottom);
        }
        // The x and y calculations below are used to adjust the position of the title, based on padding and scale.
        // This ensures that when padding is adjusted, the title moves along with the chart's position.
        return React.cloneElement(titleComponent, Object.assign(Object.assign(Object.assign({}, (showBoth && { capHeight })), { style: [ChartTheme_1.ChartBulletStyles.label.title, ChartTheme_1.ChartBulletStyles.label.subTitle], text: showBoth ? [title, subTitle] : title, textAnchor, verticalAnchor: labelPosition === 'top-left' ? 'end' : 'middle', 
            // Adjust for padding
            x: horizontal
                ? ChartUtils_1.getBulletLabelX({
                    chartWidth: chartSize.width,
                    dx: labelPosition === 'top-left'
                        ? defaultPadding.left
                        : defaultPadding.left - ChartTheme_1.ChartCommonStyles.label.margin * 1.75,
                    labelPosition: 'left',
                    legendPosition,
                    svgWidth: width
                })
                : defaultPadding.left * 0.5 +
                    (defaultPadding.right * 0.5 - (defaultPadding.right - 50)) +
                    ChartTheme_1.ChartBulletStyles.qualitativeRangeWidth / 2, y: ChartUtils_1.getBulletLabelY({
                chartHeight: chartSize.height,
                dy,
                labelPosition
            }) }), titleComponent.props));
    };
    return standalone ? (React.createElement(ChartContainer_1.ChartContainer, { desc: ariaDesc, height: height, title: ariaTitle, width: width }, getTitle())) : (React.createElement(React.Fragment, null, getTitle()));
};
exports.ChartBulletTitle.displayName = 'ChartBulletTitle';
//# sourceMappingURL=ChartBulletTitle.js.map