import * as React from 'react';
import { RouteComponentProps } from 'react-router-dom';
import { DashboardItemProps } from '@console/internal/components/dashboard/with-dashboard-resources';
import { AccessReviewResourceAttributes, Action, K8sResourceKindReference, PageComponentProps } from '../extensions';
import { K8sResourceCommon } from '../extensions/console-types';
import { DisplayFilters, TopologyDataResources } from '../extensions/topology-types';
import { K8sModel, MatchLabels, Selector as SelectorKind } from './common-types';
import { TimestampProps } from '@console/internal/components/utils';
import { RootState } from '@console/internal/redux';
import { AnyAction, Store } from 'redux';
export { RequestSizeInput } from '@console/internal/components/utils/request-size-input';
export { ActivityItem } from './internal-api';
export { default as ResourceDropdown } from '@console/shared/src/components/dropdown/ResourceDropdown';
export declare const InternalReduxStore: Store<RootState, AnyAction>;
export declare const navFactory: NavFactory;
export declare const NodeLink: (React.ComponentClass<Pick<{
    name: string;
    flags: {
        [key: string]: boolean;
    };
}, "name">, any> & {
    WrappedComponent: React.ComponentType<{
        name: string;
        flags: {
            [key: string]: boolean;
        };
    }>;
}) | (React.FunctionComponent<Pick<{
    name: string;
    flags: {
        [key: string]: boolean;
    };
}, "name">> & {
    WrappedComponent: React.ComponentType<{
        name: string;
        flags: {
            [key: string]: boolean;
        };
    }>;
});
export declare const CommonActionFactory: ResourceActionFactory;
export declare const useK8sGet: <R extends K8sResourceCommon = K8sResourceCommon>(kind: K8sModel, name?: string, namespace?: string, opts?: {
    [k: string]: string;
}) => [R, boolean, any];
export declare const useMultipleAccessReviews: (multipleResourceAttributes: AccessReviewResourceAttributes[], impersonate?: boolean) => [AccessReviewsResult[], boolean];
export declare const getSwaggerDefinitions: () => SwaggerDefinitions, getPropertyDescription: (kindObj: K8sModel, propertyPath: string | string[]) => string;
export declare const openAPItoJSONSchema: (openAPI: any) => {
    definitions: {};
    oneOf: any[];
};
export declare const withDashboardResources: <P extends DashboardItemProps>(WrappedComponent: React.ComponentType<P>) => React.ComponentClass<P>;
export declare const withStartGuide: <P>(WrappedComponent: React.ComponentType<P & {
    noProjectsAvailable?: boolean;
}>, disable?: boolean) => React.ComponentType<P>;
export declare const CreateConnector: React.LazyExoticComponent<React.FC<{
    startPoint: import("@patternfly/react-topology").Point;
    endPoint: import("@patternfly/react-topology").Point;
    hints: string[];
    dragging?: boolean;
}>>;
export declare const NodeShadows: React.LazyExoticComponent<React.FC<{}>>;
export declare const useAllowEdgeCreation: () => boolean;
export declare const useDisplayFilters: () => DisplayFilters;
export declare const useSearchFilter: (text: string) => [boolean, string];
export declare const workloadActions: (contextMenuResource: K8sResourceKind, allowRegroup?: boolean, resources?: TopologyDataResources, isOperatorBacked?: boolean) => KebabOption[];
export declare const BlueInfoCircleIcon: React.FC<ColoredIconProps>, ErrorStatus: React.FC<StatusComponentProps>, PendingStatus: React.FC<StatusComponentProps>, ProgressStatus: React.FC<StatusComponentProps>, RedExclamationCircleIcon: React.FC<ColoredIconProps>, SuccessStatus: React.FC<StatusComponentProps>, WarningStatus: React.FC<StatusComponentProps>, InfoStatus: React.FC<StatusComponentProps>, YellowExclamationTriangleIcon: React.FC<ColoredIconProps>;
export declare const GreenCheckCircleIcon: React.FC<ColoredIconProps>;
export declare const StorageClassDropdown: (props: any) => JSX.Element;
export declare const createModal: (getModalContainer: GetModalContainer) => {
    result: Promise<any>;
}, createModalLauncher: CreateModalLauncher;
export declare const confirmModal: (props: any) => {
    result: Promise<{}>;
};
export declare const createProjectModal: (props: ModalComponentProps & CreateModalLauncherProps & {
    onSubmit: (newProject: any) => void;
}) => {
    result: Promise<{}>;
};
export declare const resourcePath: (kind: string, name?: string, namespace?: string) => string, useAccessReview: (resourceAttributes: AccessReviewResourceAttributes, impersonate?: any) => boolean, useAccessReview2: (resourceAttributes: AccessReviewResourceAttributes, impersonate?: any) => [boolean, boolean];
export declare const modelFor: (ref: string) => K8sModel, modelForGroupKind: (group: string, kind: string) => K8sModel;
export declare const Firehose: React.ComponentClass<Pick<{
    k8sModels?: Map<string, any>;
    doNotConnectToState?: boolean;
}, "doNotConnectToState"> & {
    resources: any;
}, any> & {
    WrappedComponent: React.Component<{
        k8sModels?: Map<string, any>;
        doNotConnectToState?: boolean;
    }, {}, any>;
};
export declare const getImageForIconClass: (iconClass: string) => string;
export declare const connectToFlags: ConnectToFlags;
export declare const connectToPlural: ConnectToPlural;
export declare const NamespaceBar: React.FC<{
    children?: React.ReactNode;
    disabled?: boolean;
    onNamespaceChange?: Function;
    hideProjects?: boolean;
}>;
export declare const useActiveNamespace: () => [string, (ns: string) => void];
export declare const useFlag: (flag: string) => boolean;
export declare const YAMLEditor: React.LazyExoticComponent<React.ForwardRefExoticComponent<{
    value?: string;
    options?: object;
    minHeight?: string | number;
    showShortcuts?: boolean;
    toolbarLinks?: React.ReactNodeArray;
    onChange?: (newValue: any, event: any) => {};
    onSave?: () => {};
} & React.RefAttributes<import("react-monaco-editor/lib/editor").default>>>;
export declare const Table: React.LazyExoticComponent<React.FC<import("@console/internal/components/factory/table").TableProps<any, any>>>;
export declare const TableData: React.LazyExoticComponent<React.FC<import("@console/internal/components/factory/table").TableDataProps>>;
export declare const DetailsPage: React.LazyExoticComponent<React.ComponentType<import("@console/internal/components/factory/details").DetailsPageProps>>;
export declare const ListPage: React.LazyExoticComponent<React.ComponentType<{
    canCreate?: boolean;
    createButtonText?: string;
    createProps?: {
        action?: string;
        createLink?: (item: string) => string;
        to?: string;
        items?: {
            [key: string]: string;
        };
        onClick?: () => void;
        isDisabled?: boolean;
        id?: string;
    };
    flatten?: import("@console/internal/components/factory/list-page").Flatten<{
        [key: string]: K8sResourceCommon | K8sResourceCommon[];
    }, any>;
    title?: string;
    showTitle?: boolean;
    filterLabel?: string;
    textFilter?: string;
    rowFilters?: import("@console/internal/components/filter-toolbar").RowFilter<any>[];
    ListComponent: React.ComponentType<any>;
    namespace?: string;
    customData?: any;
    badge?: React.ReactNode;
    hideNameLabelFilters?: boolean;
    hideLabelFilter?: boolean;
    columnLayout?: import("../extensions").ColumnLayout;
    hideColumnManagement?: boolean;
    labelFilterPlaceholder?: string;
    nameFilterPlaceholder?: string;
    autoFocus?: boolean;
    mock?: boolean;
} & {
    kind: string;
    helpText?: React.ReactNode;
    selector?: SelectorKind;
    fieldSelector?: string;
    createHandler?: () => void;
    name?: string;
    filters?: any;
    limit?: number;
    nameFilter?: string;
    match?: import("react-router").match<any>;
    skipAccessReview?: boolean;
}>>;
export declare const MultiListPage: React.LazyExoticComponent<React.FC<{
    canCreate?: boolean;
    createButtonText?: string;
    createProps?: {
        action?: string;
        createLink?: (item: string) => string;
        to?: string;
        items?: {
            [key: string]: string;
        };
        onClick?: () => void;
        isDisabled?: boolean;
        id?: string;
    };
    flatten?: import("@console/internal/components/factory/list-page").Flatten<{
        [key: string]: K8sResourceCommon | K8sResourceCommon[];
    }, any>;
    title?: string;
    showTitle?: boolean;
    filterLabel?: string;
    textFilter?: string;
    rowFilters?: import("@console/internal/components/filter-toolbar").RowFilter<any>[];
    ListComponent: React.ComponentType<any>;
    namespace?: string;
    customData?: any;
    badge?: React.ReactNode;
    hideNameLabelFilters?: boolean;
    hideLabelFilter?: boolean;
    columnLayout?: import("../extensions").ColumnLayout;
    hideColumnManagement?: boolean;
    labelFilterPlaceholder?: string;
    nameFilterPlaceholder?: string;
    autoFocus?: boolean;
    mock?: boolean;
} & {
    createAccessReview?: {
        model: import("@console/internal/module/k8s").K8sKind;
        namespace?: string;
    };
    label?: string;
    hideTextFilter?: boolean;
    helpText?: React.ReactNode;
    resources: (Pick<import("@console/internal/components/utils").FirehoseResource, "kind" | "name" | "namespace" | "namespaced" | "selector" | "limit" | "fieldSelector" | "isList" | "optional"> & {
        prop?: string;
    })[];
    staticFilters?: {
        key: string;
        value: string;
    }[];
    nameFilter?: string;
}>>;
export declare const TopologyListViewNode: React.LazyExoticComponent<import("react-redux").ComponentClass<{
    item: import("@patternfly/react-topology").Node<import("@patternfly/react-topology").NodeModel, any>;
    selectedIds: string[];
    onSelect: (ids: string[]) => void;
    badgeCell?: React.ReactNode;
    labelCell?: React.ReactNode;
    alertsCell?: React.ReactNode;
    memoryCell?: React.ReactNode;
    cpuCell?: React.ReactNode;
    statusCell?: React.ReactNode;
    groupResourcesCell?: React.ReactNode;
    hideAlerts?: boolean;
    noPods?: boolean;
}> & {
    WrappedComponent: React.StatelessComponent<{
        onSelectTab?: (name: string) => void;
    }>;
}>;
export declare const Kebab: any;
export declare const ResourceIcon: React.LazyExoticComponent<React.SFC<import("@console/internal/components/utils").ResourceIconProps>>;
export declare const LabelList: React.LazyExoticComponent<React.ComponentType<Pick<import("@console/internal/components/utils").LabelListProps, "kind" | "labels" | "expand"> & import("react-i18next").WithTranslationProps>>;
export declare const ListDropdown: React.LazyExoticComponent<{
    (props: any): JSX.Element;
    propTypes: {
        dataFilter: import("prop-types").Requireable<(...args: any[]) => any>;
        desc: import("prop-types").Requireable<string>;
        selectedKey: import("prop-types").Requireable<string>;
        selectedKeyKind: import("prop-types").Requireable<string>;
        fixed: import("prop-types").Requireable<boolean>;
        resources: import("prop-types").Validator<import("prop-types").InferProps<{
            kind: import("prop-types").Validator<string>;
            namespace: import("prop-types").Requireable<string>;
        }>[]>;
        placeholder: import("prop-types").Requireable<string>;
        onChange: import("prop-types").Requireable<(...args: any[]) => any>;
        id: import("prop-types").Requireable<string>;
        disabled: import("prop-types").Requireable<boolean>;
    };
}>;
export declare const ResourceSummary: React.LazyExoticComponent<React.FC<import("@console/internal/components/utils").ResourceSummaryProps>>;
export declare const ResourceName: React.LazyExoticComponent<React.SFC<import("@console/internal/components/utils").ResourceNameProps>>;
export declare const ResourceKebab: React.LazyExoticComponent<import("react-redux").ComponentClass<any> & {
    WrappedComponent: React.StatelessComponent<any>;
}>;
export declare const Dropdown: React.LazyExoticComponent<{
    (props: any): JSX.Element;
    displayName: string;
    propTypes: {
        actionItems: import("prop-types").Requireable<import("prop-types").InferProps<{
            actionKey: import("prop-types").Requireable<string>;
            actionTitle: import("prop-types").Requireable<string>;
        }>[]>;
        autocompleteFilter: import("prop-types").Requireable<(...args: any[]) => any>;
        autocompletePlaceholder: import("prop-types").Requireable<string>;
        canFavorite: import("prop-types").Requireable<boolean>;
        className: import("prop-types").Requireable<string>;
        dropDownClassName: import("prop-types").Requireable<string>;
        enableBookmarks: import("prop-types").Requireable<boolean>;
        headerBefore: import("prop-types").Requireable<{
            [x: string]: string;
        }>;
        items: import("prop-types").Validator<object>;
        menuClassName: import("prop-types").Requireable<string>;
        buttonClassName: import("prop-types").Requireable<string>;
        noSelection: import("prop-types").Requireable<boolean>;
        userSettingsPrefix: import("prop-types").Requireable<string>;
        storageKey: import("prop-types").Requireable<string>;
        spacerBefore: import("prop-types").Requireable<Set<unknown>>;
        textFilter: import("prop-types").Requireable<string>;
        title: import("prop-types").Requireable<import("prop-types").ReactNodeLike>;
        disabled: import("prop-types").Requireable<boolean>;
        id: import("prop-types").Requireable<string>;
        onChange: import("prop-types").Requireable<(...args: any[]) => any>;
        selectedKey: import("prop-types").Requireable<string>;
        titlePrefix: import("prop-types").Requireable<string>;
        ariaLabel: import("prop-types").Requireable<string>;
        name: import("prop-types").Requireable<string>;
        autoSelect: import("prop-types").Requireable<boolean>;
        describedBy: import("prop-types").Requireable<string>;
        required: import("prop-types").Requireable<boolean>;
        dataTest: import("prop-types").Requireable<string>;
    };
}>;
export declare const StatusBox: React.LazyExoticComponent<React.FC<{
    label?: string;
    loadError?: any;
    loaded?: boolean;
    data?: any;
    unfilteredData?: any;
    skeleton?: React.ReactNode;
    NoDataEmptyMsg?: React.ComponentType<{}>;
    EmptyMsg?: React.ComponentType<{}>;
    children?: React.ReactNode;
}>>;
export declare const Selector: React.LazyExoticComponent<React.FC<{
    kind?: string;
    selector: SelectorKind;
    namespace?: string;
}>>;
export declare const Timestamp: React.ComponentClass<Omit<TimestampProps, 'now'>>;
export declare const DashboardCardLink: React.LazyExoticComponent<React.FC<import("@patternfly/react-core").ButtonProps & {
    children: React.ReactNode;
    className?: string;
} & {
    to: string;
}>>;
export declare const GenericStatus: React.LazyExoticComponent<React.FC<import("@console/shared/src/components/status/types").StatusComponentProps & {
    Icon: React.ComponentType<{
        title?: string;
    }>;
    popoverTitle?: string;
    noTooltip?: boolean;
}>>;
export declare const EventItem: React.LazyExoticComponent<React.FC<{
    event: import("@console/internal/module/k8s").EventKind;
    isExpanded: (key: string) => boolean;
    onToggle: (key: string) => void;
}>>;
export declare const InventoryItem: React.LazyExoticComponent<React.FC<{
    isLoading: boolean;
    title: string;
    titlePlural?: string;
    count: number;
    children?: React.ReactNode;
    error?: boolean;
    TitleComponent?: React.ComponentType<{}>;
    ExpandedComponent?: React.ComponentType<{}>;
    dataTest?: string;
}>>;
export declare const CpuCellComponent: React.LazyExoticComponent<React.FC<{
    cpuByPod: any;
    totalCores: number;
}>>;
export declare const MemoryCellComponent: React.LazyExoticComponent<React.FC<{
    totalBytes: number;
    memoryByPod: any;
}>>;
export declare const ModalErrorContent: React.LazyExoticComponent<({ error, title, cancel }: {
    error: any;
    title?: string;
    cancel?: any;
}) => JSX.Element>;
export declare const ResourcesEventStream: React.LazyExoticComponent<({ filters, namespace }: {
    filters: any;
    namespace: any;
}) => JSX.Element>;
export declare const ServicesList: React.LazyExoticComponent<any>;
export declare const ErrorPage404: React.LazyExoticComponent<React.SFC<Pick<import("@console/internal/components/error").ErrorComponentProps, "message">>>;
export declare const Conditions: React.LazyExoticComponent<React.FC<import("@console/internal/components/conditions").ConditionsProps>>;
export declare const ActivityProgress: React.LazyExoticComponent<React.FC<{
    title: string;
    progress: number;
}>>;
export declare const DroppableEditYAML: React.ComponentType<any>;
export declare const EnvFromEditor: React.LazyExoticComponent<React.ComponentType<Pick<any, string | number | symbol> & import("react-i18next").WithTranslationProps>>;
export { PrometheusUtilizationItem, PrometheusMultilineUtilizationItem, } from '@console/internal/components/dashboard/dashboards-page/cluster-dashboard/utilization-card';
export declare const RecentEventsBodyContent: React.LazyExoticComponent<React.FC<import("./internal-types").RecentEventsBodyProps & {
    paused?: boolean;
    setPaused?: (paused: boolean) => void;
}>>;
export declare const VirtualizedGrid: React.LazyExoticComponent<React.FC<{
    items: import("@console/shared/src/components/virtualized-grid/types").GroupedItems | import("@console/shared/src/components/virtualized-grid/types").Item[];
    renderCell: import("@console/shared/src/components/virtualized-grid/types").RenderCell;
    renderHeader?: import("@console/shared/src/components/virtualized-grid/types").RenderHeader;
    isItemsGrouped?: boolean;
    className?: string;
    cellWidth?: number;
    cellMargin?: number;
    celldefaultHeight?: number;
    estimatedCellHeight?: number;
    overscanRowCount?: number;
    headerHeight?: number;
}>>;
declare type SwaggerDefinition = {
    definitions?: SwaggerDefinitions;
    description?: string;
    type?: string;
    enum?: string[];
    $ref?: string;
    items?: SwaggerDefinition;
    required?: string[];
    properties?: {
        [prop: string]: SwaggerDefinition;
    };
};
declare type SwaggerDefinitions = {
    [name: string]: SwaggerDefinition;
};
declare type ResourceActionCreator = (kind: K8sModel, obj: K8sResourceKind, relatedResource?: K8sResourceKind) => Action;
declare type ResourceActionFactory = {
    [name: string]: ResourceActionCreator;
};
declare type K8sResourceKind = K8sResourceCommon & {
    spec?: {
        selector?: SelectorKind | MatchLabels;
        [key: string]: any;
    };
    status?: {
        [key: string]: any;
    };
    data?: {
        [key: string]: any;
    };
};
declare type ColoredIconProps = {
    className?: string;
    title?: string;
    size?: 'sm' | 'md' | 'lg' | 'xl';
};
declare type StatusComponentProps = {
    title?: string;
    iconOnly?: boolean;
    noTooltip?: boolean;
    className?: string;
    popoverTitle?: string;
};
declare type ModalComponentProps = {
    cancel?: () => void;
    close?: () => void;
};
declare type CreateModalLauncherProps = {
    blocking?: boolean;
    modalClassName?: string;
};
declare type GetModalContainer = (onClose: (e?: React.SyntheticEvent) => void) => React.ReactElement;
declare type CreateModalLauncher = <P extends ModalComponentProps>(C: React.ComponentType<P>) => (props: P & CreateModalLauncherProps) => {
    result: Promise<{}>;
};
export interface DragOperationWithType {
    type: string;
}
export declare type NavPage = {
    href?: string;
    path?: string;
    name: string;
    component: React.ComponentType<RouteComponentProps>;
};
export declare type Page<D = any> = Partial<Omit<NavPage, 'component'>> & {
    component?: React.ComponentType<PageComponentProps & D>;
    badge?: React.ReactNode;
    pageData?: D;
    nameKey?: string;
};
declare type NavFactory = {
    [name: string]: (c?: React.ComponentType<any>) => Page;
};
export declare type KebabOption = {
    hidden?: boolean;
    label?: React.ReactNode;
    labelKey?: string;
    labelKind?: {
        [key: string]: string | string[];
    };
    href?: string;
    callback?: () => any;
    accessReview?: AccessReviewResourceAttributes;
    isDisabled?: boolean;
    tooltip?: string;
    tooltipKey?: string;
    path?: string;
    pathKey?: string;
    icon?: React.ReactNode;
};
export declare type FlagsObject = {
    [key: string]: boolean;
};
export declare type WithFlagsProps = {
    flags: FlagsObject;
};
export declare type ConnectToFlags = <P extends WithFlagsProps>(...flags: string[]) => (C: React.ComponentType<P>) => React.ComponentType<Omit<P, keyof WithFlagsProps>> & {
    WrappedComponent: React.ComponentType<P>;
};
declare type WithPluralProps = {
    kindObj?: K8sModel;
    modelRef?: K8sResourceKindReference;
    kindsInFlight?: boolean;
};
export declare type ConnectToPlural = <P extends WithPluralProps>(C: React.ComponentType<P>) => React.ComponentType<Omit<P, keyof WithPluralProps>> & {
    WrappedComponent: React.ComponentType<P>;
};
declare type AccessReviewsResult = {
    resourceAttributes: AccessReviewResourceAttributes;
    allowed: boolean;
};
