import * as React from 'react';
import { UseK8sWatchResource, UseK8sWatchResources, ConsoleFetch, ConsoleFetchJSON, ConsoleFetchText, HorizontalNavProps, UseResolvedExtensions, VirtualizedTableFC, TableDataProps, UseActiveColumns, ListPageHeaderProps, ListPageCreateProps, ListPageCreateLinkProps, ListPageCreateButtonProps, ListPageCreateDropdownProps, ListPageFilterProps, UseListPageFilter, ResourceLinkProps, UseK8sModel, UseK8sModels, UseActivePerspective } from '../extensions/console-types';
import { K8sGet, K8sCreate, K8sUpdate, K8sPatch, K8sDelete, K8sList } from './k8s-types';
export declare const useK8sWatchResource: UseK8sWatchResource;
export declare const useK8sWatchResources: UseK8sWatchResources;
export declare const useResolvedExtensions: UseResolvedExtensions;
export declare const consoleFetch: ConsoleFetch;
export declare const consoleFetchJSON: ConsoleFetchJSON;
export declare const consoleFetchText: ConsoleFetchText;
export declare const useActivePerspective: UseActivePerspective;
/**
 * A component that creates a Navigation bar. It takes array of NavPage objects and renderes a NavBar.
 * Routing is handled as part of the component.
 * @example
 * const HomePage: React.FC = (props) => {
 *     const page = {
 *       href: '/home',
 *       name: 'Home',
 *       component: () => <>Home</>
 *     }
 *     return <HorizontalNav match={props.match} pages={[page]} />
 * }
 *
 * @param {object=} resource - The resource associated with this Navigation, an object of K8sResourceCommon type
 * @param {NavPage[]} pages - An array of page objects
 * @param {object} match - match object provided by React Router
 */
export declare const HorizontalNav: React.FC<HorizontalNavProps>;
export declare const VirtualizedTable: VirtualizedTableFC;
export declare const TableData: React.FC<TableDataProps>;
export declare const useActiveColumns: UseActiveColumns;
export declare const ListPageHeader: React.FC<ListPageHeaderProps>;
export declare const ListPageCreate: React.FC<ListPageCreateProps>;
export declare const ListPageCreateLink: React.FC<ListPageCreateLinkProps>;
export declare const ListPageCreateButton: React.FC<ListPageCreateButtonProps>;
export declare const ListPageCreateDropdown: React.FC<ListPageCreateDropdownProps>;
export declare const ListPageBody: React.FC;
export declare const ListPageFilter: React.FC<ListPageFilterProps>;
export declare const useListPageFilter: UseListPageFilter;
export declare const ResourceLink: React.FC<ResourceLinkProps>;
export declare const useK8sModel: UseK8sModel;
export declare const useK8sModels: UseK8sModels;
export declare const k8sGet: K8sGet;
export declare const k8sCreate: K8sCreate;
export declare const k8sUpdate: K8sUpdate;
export declare const k8sPatch: K8sPatch;
export declare const k8sDelete: K8sDelete;
export declare const k8sList: K8sList;
export { getAPIVersionForModel, getGroupVersionKindForResource, getGroupVersionKindForModel, } from '@console/dynamic-plugin-sdk/src/utils/k8s/k8s-ref';
