export const useK8sWatchResource = require('@console/internal/components/utils/k8s-watch-hook')
    .useK8sWatchResource;
export const useK8sWatchResources = require('@console/internal/components/utils/k8s-watch-hook')
    .useK8sWatchResources;
export const useResolvedExtensions = require('@console/dynamic-plugin-sdk/src/api/useResolvedExtensions')
    .useResolvedExtensions;
export const consoleFetch = require('@console/dynamic-plugin-sdk/src/utils/fetch')
    .consoleFetch;
export const consoleFetchJSON = require('@console/dynamic-plugin-sdk/src/utils/fetch')
    .consoleFetchJSON;
export const consoleFetchText = require('@console/dynamic-plugin-sdk/src/utils/fetch')
    .consoleFetchText;
export const useActivePerspective = require('@console/dynamic-plugin-sdk/src/perspective/useActivePerspective')
    .default;
/**
 * A component that creates a Navigation bar. It takes array of NavPage objects and renderes a NavBar.
 * Routing is handled as part of the component.
 * @example
 * const HomePage: React.FC = (props) => {
 *     const page = {
 *       href: '/home',
 *       name: 'Home',
 *       component: () => <>Home</>
 *     }
 *     return <HorizontalNav match={props.match} pages={[page]} />
 * }
 *
 * @param {object=} resource - The resource associated with this Navigation, an object of K8sResourceCommon type
 * @param {NavPage[]} pages - An array of page objects
 * @param {object} match - match object provided by React Router
 */
export const HorizontalNav = require('@console/internal/components/utils/horizontal-nav')
    .HorizontalNavFacade;
export const VirtualizedTable = require('@console/internal/components/factory/Table/VirtualizedTable')
    .default;
export const TableData = require('@console/internal/components/factory/Table/VirtualizedTable')
    .TableData;
export const useActiveColumns = require('@console/internal/components/factory/Table/active-columns-hook')
    .useActiveColumns;
export const ListPageHeader = require('@console/internal/components/factory/ListPage/ListPageHeader')
    .default;
export const ListPageCreate = require('@console/internal/components/factory/ListPage/ListPageCreate')
    .default;
export const ListPageCreateLink = require('@console/internal/components/factory/ListPage/ListPageCreate')
    .ListPageCreateLink;
export const ListPageCreateButton = require('@console/internal/components/factory/ListPage/ListPageCreate')
    .ListPageCreateButton;
export const ListPageCreateDropdown = require('@console/internal/components/factory/ListPage/ListPageCreate')
    .ListPageCreateDropdown;
export const ListPageBody = require('@console/internal/components/factory/ListPage/ListPageBody')
    .default;
export const ListPageFilter = require('@console/internal/components/factory/ListPage/ListPageFilter')
    .default;
export const useListPageFilter = require('@console/internal/components/factory/ListPage/filter-hook')
    .useListPageFilter;
export const ResourceLink = require('@console/internal/components/utils/resource-link')
    .ResourceLink;
export const useK8sModel = require('@console/shared/src/hooks/useK8sModel')
    .useK8sModel;
export const useK8sModels = require('@console/shared/src/hooks/useK8sModels')
    .useK8sModels;
// Expose K8s CRUD utilities as below
export const k8sGet = require('@console/dynamic-plugin-sdk/src/utils/k8s').k8sGetResource;
export const k8sCreate = require('@console/dynamic-plugin-sdk/src/utils/k8s')
    .k8sCreateResource;
export const k8sUpdate = require('@console/dynamic-plugin-sdk/src/utils/k8s')
    .k8sUpdateResource;
export const k8sPatch = require('@console/dynamic-plugin-sdk/src/utils/k8s')
    .k8sPatchResource;
export const k8sDelete = require('@console/dynamic-plugin-sdk/src/utils/k8s')
    .k8sDeleteResource;
export const k8sList = require('@console/dynamic-plugin-sdk/src/utils/k8s')
    .k8sListResource;
export { getAPIVersionForModel, getGroupVersionKindForResource, getGroupVersionKindForModel, } from '@console/dynamic-plugin-sdk/src/utils/k8s/k8s-ref';
//# sourceMappingURL=core-api.js.map