"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const Ajv = require("ajv");
const ValidationAssertions_1 = require("./ValidationAssertions");
const ValidationResult_1 = require("./ValidationResult");
class SchemaValidator {
    constructor(description, ajv = new Ajv({ allErrors: true })) {
        this.ajv = ajv;
        this.result = new ValidationResult_1.ValidationResult(description);
        this.assert = new ValidationAssertions_1.ValidationAssertions(this.result);
    }
    validate(schema, data, dataVar = 'obj') {
        if (!this.ajv.validate(schema, data)) {
            this.ajv.errors.forEach((error) => {
                // This format is consistent with ajv.errorsText() implementation
                this.result.addError(`${dataVar}${error.dataPath} ${error.message}`);
            });
        }
        return this.result;
    }
}
exports.SchemaValidator = SchemaValidator;
//# sourceMappingURL=SchemaValidator.js.map