import * as React from 'react';
import { Graph, Node, Model, EdgeModel, NodeModel, EventListener, ModelKind, GraphElement } from '@patternfly/react-topology';
import { PrometheusAlert } from '../api/common-types';
import { K8sResourceCommon, K8sResourceKindReference, WatchK8sResults } from './console-types';
export declare type Point = [number, number];
export interface OdcNodeModel extends NodeModel {
    resource?: K8sResourceCommon;
    resourceKind?: K8sResourceKindReference;
}
export interface OdcEdgeModel extends EdgeModel {
    resource?: K8sResourceCommon;
    resourceKind?: K8sResourceKindReference;
}
export declare type TopologyResourcesObject = {
    [key: string]: K8sResourceCommon[];
};
export declare type TopologyDataResources = WatchK8sResults<TopologyResourcesObject>;
export declare type TopologyDataModelGetter = (namespace: string, resources: TopologyDataResources, workloads: K8sResourceCommon[]) => Promise<Model>;
export declare enum TopologyViewType {
    graph = "graph",
    list = "list"
}
export declare type ViewComponentFactory = (kind: ModelKind, type: string, view?: TopologyViewType) => React.ComponentType<{
    element: GraphElement;
}> | undefined;
export declare type TopologyDataModelDepicted = (resource: K8sResourceCommon, model: Model) => boolean;
export declare type TopologyDataModelReconciler = (model: Model, resources: TopologyDataResources) => void;
export declare type CreateConnection = (source: Node, target: Node | Graph) => Promise<React.ReactElement[] | null>;
export declare type CreateConnectionGetter = (createHints: string[], source?: Node, target?: Node) => CreateConnection;
export declare type RelationshipProviderProvides = (source: Node, target: Node) => Promise<boolean>;
export declare type RelationshipProviderCreate = (source: Node, target: Node) => Promise<void>;
export declare enum TopologyDisplayFilterType {
    show = "show",
    expand = "expand",
    kind = "kind"
}
export declare type TopologyDisplayOption = {
    type: TopologyDisplayFilterType;
    id: string;
    label?: string;
    labelKey?: string;
    priority: number;
    value: boolean;
};
export declare type OverviewItem<T = K8sResourceCommon> = {
    obj: T;
    hpas?: K8sResourceCommon[];
    isOperatorBackedService?: boolean;
    isMonitorable?: boolean;
    monitoringAlerts?: PrometheusAlert[];
};
export declare type DisplayFilters = TopologyDisplayOption[];
export declare type TopologyApplyDisplayOptions = (model: Model, filters: DisplayFilters) => string[];
export declare enum TopologyDecoratorQuadrant {
    upperLeft = "upperLeft",
    upperRight = "upperRight",
    lowerLeft = "lowerLeft",
    lowerRight = "lowerRight"
}
export declare type TopologyDecoratorGetter = (element: Node, radius: number, centerX: number, centerY: number) => React.ReactElement;
export declare type TopologyDecorator = {
    id: string;
    priority: number;
    quadrant: TopologyDecoratorQuadrant;
    decorator: TopologyDecoratorGetter;
};
export interface TopologyDataObject<D = {}> {
    id: string;
    name: string;
    type: string;
    resources: OverviewItem;
    pods?: K8sResourceCommon[];
    data: D;
    resource: K8sResourceCommon | null;
    groupResources?: OdcNodeModel[];
}
export interface TopologyApplicationObject {
    id: string;
    name: string;
    resources: OdcNodeModel[];
}
export interface WorkloadData {
    editURL?: string;
    vcsURI?: string;
    vcsRef?: string;
    builderImage?: string;
    kind?: string;
    isKnativeResource?: boolean;
}
export declare type TrafficData = {
    nodes: KialiNode[];
    edges: KialiEdge[];
};
export declare type KialiNode = {
    data: {
        id: string;
        nodeType: string;
        namespace: string;
        workload: string;
        app: string;
        version?: string;
        destServices?: {
            [key: string]: any;
        }[];
        traffic?: {
            [key: string]: any;
        }[];
    };
};
export declare type KialiEdge = {
    data: {
        id: string;
        source: string;
        target: string;
        traffic: {
            [key: string]: any;
        };
    };
};
export declare type GraphData = {
    namespace: string;
    createResourceAccess: string[];
    eventSourceEnabled: boolean;
    createConnectorExtensions?: CreateConnectionGetter[];
    decorators?: {
        [key: string]: TopologyDecorator[];
    };
};
export declare type BuildConfigOverviewItem = K8sResourceCommon & {
    builds: K8sResourceCommon[];
};
export declare type BuildConfigData = {
    loaded: boolean;
    loadError: string;
    buildConfigs: BuildConfigOverviewItem[];
};
export declare const SHOW_GROUPING_HINT_EVENT = "show-regroup-hint";
export declare type ShowGroupingHintEventListener = EventListener<[Node, string]>;
