package airec

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RunInstance invokes the airec.RunInstance API synchronously
// api document: https://help.aliyun.com/api/airec/runinstance.html
func (client *Client) RunInstance(request *RunInstanceRequest) (response *RunInstanceResponse, err error) {
	response = CreateRunInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// RunInstanceWithChan invokes the airec.RunInstance API asynchronously
// api document: https://help.aliyun.com/api/airec/runinstance.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RunInstanceWithChan(request *RunInstanceRequest) (<-chan *RunInstanceResponse, <-chan error) {
	responseChan := make(chan *RunInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RunInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RunInstanceWithCallback invokes the airec.RunInstance API asynchronously
// api document: https://help.aliyun.com/api/airec/runinstance.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RunInstanceWithCallback(request *RunInstanceRequest, callback func(response *RunInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RunInstanceResponse
		var err error
		defer close(result)
		response, err = client.RunInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RunInstanceRequest is the request struct for api RunInstance
type RunInstanceRequest struct {
	*requests.RoaRequest
	InstanceId string `position:"Path" name:"InstanceId"`
}

// RunInstanceResponse is the response struct for api RunInstance
type RunInstanceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Result    bool   `json:"Result" xml:"Result"`
}

// CreateRunInstanceRequest creates a request to invoke RunInstance API
func CreateRunInstanceRequest() (request *RunInstanceRequest) {
	request = &RunInstanceRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Airec", "2018-10-12", "RunInstance", "/openapi/instances/[InstanceId]/actions/import", "airec", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRunInstanceResponse creates a response to parse from RunInstance response
func CreateRunInstanceResponse() (response *RunInstanceResponse) {
	response = &RunInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
