package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeMonitoringAgentStatuses invokes the cms.DescribeMonitoringAgentStatuses API synchronously
// api document: https://help.aliyun.com/api/cms/describemonitoringagentstatuses.html
func (client *Client) DescribeMonitoringAgentStatuses(request *DescribeMonitoringAgentStatusesRequest) (response *DescribeMonitoringAgentStatusesResponse, err error) {
	response = CreateDescribeMonitoringAgentStatusesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeMonitoringAgentStatusesWithChan invokes the cms.DescribeMonitoringAgentStatuses API asynchronously
// api document: https://help.aliyun.com/api/cms/describemonitoringagentstatuses.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeMonitoringAgentStatusesWithChan(request *DescribeMonitoringAgentStatusesRequest) (<-chan *DescribeMonitoringAgentStatusesResponse, <-chan error) {
	responseChan := make(chan *DescribeMonitoringAgentStatusesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeMonitoringAgentStatuses(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeMonitoringAgentStatusesWithCallback invokes the cms.DescribeMonitoringAgentStatuses API asynchronously
// api document: https://help.aliyun.com/api/cms/describemonitoringagentstatuses.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeMonitoringAgentStatusesWithCallback(request *DescribeMonitoringAgentStatusesRequest, callback func(response *DescribeMonitoringAgentStatusesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeMonitoringAgentStatusesResponse
		var err error
		defer close(result)
		response, err = client.DescribeMonitoringAgentStatuses(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeMonitoringAgentStatusesRequest is the request struct for api DescribeMonitoringAgentStatuses
type DescribeMonitoringAgentStatusesRequest struct {
	*requests.RpcRequest
	InstanceIds string `position:"Query" name:"InstanceIds"`
}

// DescribeMonitoringAgentStatusesResponse is the response struct for api DescribeMonitoringAgentStatuses
type DescribeMonitoringAgentStatusesResponse struct {
	*responses.BaseResponse
	Code           string         `json:"Code" xml:"Code"`
	Message        string         `json:"Message" xml:"Message"`
	Success        bool           `json:"Success" xml:"Success"`
	RequestId      string         `json:"RequestId" xml:"RequestId"`
	NodeStatusList NodeStatusList `json:"NodeStatusList" xml:"NodeStatusList"`
}

// CreateDescribeMonitoringAgentStatusesRequest creates a request to invoke DescribeMonitoringAgentStatuses API
func CreateDescribeMonitoringAgentStatusesRequest() (request *DescribeMonitoringAgentStatusesRequest) {
	request = &DescribeMonitoringAgentStatusesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2019-01-01", "DescribeMonitoringAgentStatuses", "cms", "openAPI")
	return
}

// CreateDescribeMonitoringAgentStatusesResponse creates a response to parse from DescribeMonitoringAgentStatuses response
func CreateDescribeMonitoringAgentStatusesResponse() (response *DescribeMonitoringAgentStatusesResponse) {
	response = &DescribeMonitoringAgentStatusesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
